/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.Soft1RONextItSolLogic;

public class ArticleResponseBean {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    String MTRL;
    String CODE;
    String NAME;
    String MTRUNIT1;
    String VAT;
    Date INSDATE;
    Date UPDDATE;
    Double referencePrice = 0.0;
    Map<String, Double> tierPrices;
    String eanBarcode;

    public static ArticleResponseBean fromMap(Map<String, String> beanMap, Map<String, String> tierApiMap) {
        ArticleResponseBean a = new ArticleResponseBean();
        a.setMTRL(beanMap.get("MTRL"));
        a.setCODE(beanMap.get("CODE"));
        a.setNAME(beanMap.get("NAME"));
        a.setMTRUNIT1(beanMap.get("MTRUNIT1"));
        a.setVAT(beanMap.get("VAT"));
        double pricer = Soft1RONextItSolLogic.roundDoubleUp(Double.parseDouble(beanMap.get("PRICER")), 3);
        a.setReferencePrice(pricer);
        try {
            a.INSDATE = dateFormat.parse(beanMap.get("INSDATE"));
            a.UPDDATE = dateFormat.parse(beanMap.get("UPDDATE"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (String key : beanMap.keySet()) {
            if (!key.startsWith("PRET_")) continue;
            String s = beanMap.get(key);
            double tierPrice = Soft1RONextItSolLogic.roundDoubleUp(Double.parseDouble(s), 3);
            String tagApiName = tierApiMap.get(key);
            a.tierPrices.put(tagApiName, tierPrice);
        }
        String ean_code = beanMap.get("COD_EAN");
        if (ean_code != null && ean_code.length() > 0) {
            a.eanBarcode = ean_code;
        }
        return a;
    }

    private static Map<String, Double> $default$tierPrices() {
        return new LinkedHashMap<String, Double>();
    }

    public static ArticleResponseBeanBuilder builder() {
        return new ArticleResponseBeanBuilder();
    }

    public String getMTRL() {
        return this.MTRL;
    }

    public String getCODE() {
        return this.CODE;
    }

    public String getNAME() {
        return this.NAME;
    }

    public String getMTRUNIT1() {
        return this.MTRUNIT1;
    }

    public String getVAT() {
        return this.VAT;
    }

    public Date getINSDATE() {
        return this.INSDATE;
    }

    public Date getUPDDATE() {
        return this.UPDDATE;
    }

    public Double getReferencePrice() {
        return this.referencePrice;
    }

    public Map<String, Double> getTierPrices() {
        return this.tierPrices;
    }

    public String getEanBarcode() {
        return this.eanBarcode;
    }

    public void setMTRL(String MTRL) {
        this.MTRL = MTRL;
    }

    public void setCODE(String CODE) {
        this.CODE = CODE;
    }

    public void setNAME(String NAME) {
        this.NAME = NAME;
    }

    public void setMTRUNIT1(String MTRUNIT1) {
        this.MTRUNIT1 = MTRUNIT1;
    }

    public void setVAT(String VAT) {
        this.VAT = VAT;
    }

    public void setINSDATE(Date INSDATE) {
        this.INSDATE = INSDATE;
    }

    public void setUPDDATE(Date UPDDATE) {
        this.UPDDATE = UPDDATE;
    }

    public void setReferencePrice(Double referencePrice) {
        this.referencePrice = referencePrice;
    }

    public void setTierPrices(Map<String, Double> tierPrices) {
        this.tierPrices = tierPrices;
    }

    public void setEanBarcode(String eanBarcode) {
        this.eanBarcode = eanBarcode;
    }

    public ArticleResponseBean() {
        this.tierPrices = ArticleResponseBean.$default$tierPrices();
    }

    public ArticleResponseBean(String MTRL, String CODE, String NAME, String MTRUNIT1, String VAT, Date INSDATE, Date UPDDATE, Double referencePrice, Map<String, Double> tierPrices, String eanBarcode) {
        this.MTRL = MTRL;
        this.CODE = CODE;
        this.NAME = NAME;
        this.MTRUNIT1 = MTRUNIT1;
        this.VAT = VAT;
        this.INSDATE = INSDATE;
        this.UPDDATE = UPDDATE;
        this.referencePrice = referencePrice;
        this.tierPrices = tierPrices;
        this.eanBarcode = eanBarcode;
    }

    public String toString() {
        return "ArticleResponseBean(MTRL=" + this.getMTRL() + ", CODE=" + this.getCODE() + ", NAME=" + this.getNAME() + ", MTRUNIT1=" + this.getMTRUNIT1() + ", VAT=" + this.getVAT() + ", INSDATE=" + this.getINSDATE() + ", UPDDATE=" + this.getUPDDATE() + ", referencePrice=" + this.getReferencePrice() + ", tierPrices=" + this.getTierPrices() + ", eanBarcode=" + this.getEanBarcode() + ")";
    }

    public static class ArticleResponseBeanBuilder {
        private String MTRL;
        private String CODE;
        private String NAME;
        private String MTRUNIT1;
        private String VAT;
        private Date INSDATE;
        private Date UPDDATE;
        private Double referencePrice;
        private boolean tierPrices$set;
        private Map<String, Double> tierPrices$value;
        private String eanBarcode;

        ArticleResponseBeanBuilder() {
        }

        public ArticleResponseBeanBuilder setMTRL(String MTRL) {
            this.MTRL = MTRL;
            return this;
        }

        public ArticleResponseBeanBuilder setCODE(String CODE) {
            this.CODE = CODE;
            return this;
        }

        public ArticleResponseBeanBuilder setNAME(String NAME) {
            this.NAME = NAME;
            return this;
        }

        public ArticleResponseBeanBuilder setMTRUNIT1(String MTRUNIT1) {
            this.MTRUNIT1 = MTRUNIT1;
            return this;
        }

        public ArticleResponseBeanBuilder setVAT(String VAT) {
            this.VAT = VAT;
            return this;
        }

        public ArticleResponseBeanBuilder setINSDATE(Date INSDATE) {
            this.INSDATE = INSDATE;
            return this;
        }

        public ArticleResponseBeanBuilder setUPDDATE(Date UPDDATE) {
            this.UPDDATE = UPDDATE;
            return this;
        }

        public ArticleResponseBeanBuilder setReferencePrice(Double referencePrice) {
            this.referencePrice = referencePrice;
            return this;
        }

        public ArticleResponseBeanBuilder setTierPrices(Map<String, Double> tierPrices) {
            this.tierPrices$value = tierPrices;
            this.tierPrices$set = true;
            return this;
        }

        public ArticleResponseBeanBuilder setEanBarcode(String eanBarcode) {
            this.eanBarcode = eanBarcode;
            return this;
        }

        public ArticleResponseBean build() {
            Map tierPrices$value = this.tierPrices$value;
            if (!this.tierPrices$set) {
                tierPrices$value = ArticleResponseBean.$default$tierPrices();
            }
            return new ArticleResponseBean(this.MTRL, this.CODE, this.NAME, this.MTRUNIT1, this.VAT, this.INSDATE, this.UPDDATE, this.referencePrice, tierPrices$value, this.eanBarcode);
        }

        public String toString() {
            return "ArticleResponseBean.ArticleResponseBeanBuilder(MTRL=" + this.MTRL + ", CODE=" + this.CODE + ", NAME=" + this.NAME + ", MTRUNIT1=" + this.MTRUNIT1 + ", VAT=" + this.VAT + ", INSDATE=" + this.INSDATE + ", UPDDATE=" + this.UPDDATE + ", referencePrice=" + this.referencePrice + ", tierPrices$value=" + this.tierPrices$value + ", eanBarcode=" + this.eanBarcode + ")";
        }
    }
}

