/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.OperationResult;
import ro.deversoft.odf.gearbox.common.OperationResultResponseDDD;
import ro.deversoft.odf.gearbox.common.domain.CurrencyDDD;
import ro.deversoft.odf.gearbox.common.domain.EMAIL_FIELDS;
import ro.deversoft.odf.gearbox.common.domain.GenericKeyValueDDD;
import ro.deversoft.odf.gearbox.common.domain.GenericKeyValueListDDD;
import ro.deversoft.odf.gearbox.common.domain.GpsPointDDD;
import ro.deversoft.odf.gearbox.common.domain.LanguageDDD;
import ro.deversoft.odf.gearbox.common.domain.NfcTagIdWrapper;
import ro.deversoft.odf.gearbox.common.domain.ODFIdWithNameListDDD;
import ro.deversoft.odf.gearbox.common.domain.OrderEventDetailsWithNamesDDD;
import ro.deversoft.odf.gearbox.common.domain.StringI18List;
import ro.deversoft.odf.gearbox.common.domain.StringWithLanguageIndication;
import ro.deversoft.odf.gearbox.common.domain.address.AddressFieldTypeEnum;
import ro.deversoft.odf.gearbox.common.domain.address.StructuredAddress;
import ro.deversoft.odf.gearbox.common.domain.print.WorkOrderLineDDD;
import ro.deversoft.odf.gearbox.common.domain.promotion.WeeklyScheduleDDD;
import ro.deversoft.odf.gearbox.common.enums.CurrencyType;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;

public final class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final int VALUE_DECIMALS = 2;
    public static final int QTY_DECIMALS = 6;
    public static final String CRLF = "\r\n";
    public static final DecimalFormat NUMBER_2DECIMALS = new DecimalFormat("###0.##");
    public static final DecimalFormat NUMBER_2DECIMALS_THOUSANDS = new DecimalFormat("#,##0.##");
    public static final DecimalFormat NUMBER_2DECIMALS_NO_TRUNC = new DecimalFormat("###0.00");
    public static final DecimalFormat NUMBER_2DECIMALS_NO_TRUNC_THOUSANDS = new DecimalFormat("#,##0.00");
    public static final Map<String, DateTimeFormatter> timeFormatters = new ConcurrentHashMap<String, DateTimeFormatter>();
    public static final SimpleDateFormat FULL_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final Pattern pricePerQtyPriceTagValueFormat = Pattern.compile("^(?<price>[0-9]*\\.?[0-9]+)\\/(?<qty>[0-9]*\\.?[0-9]+)$");
    public static final String sqlInjectionForbiddedCharsPatternString = "[^a-fA-F0-9:;NFC]";
    public static final Pattern compiled = Pattern.compile("[^a-fA-F0-9:;NFC]");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm");
    static final Pattern emailPattern = Pattern.compile("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)");

    public static double[] getPriceAndQtyFromPriceTagValue(String pricePerQtyTagValue) {
        Matcher m = pricePerQtyPriceTagValueFormat.matcher(pricePerQtyTagValue);
        if (m.matches()) {
            String priceS = m.group("price");
            String qtyS = m.group("qty");
            if (CommonUtils.correctDouble(priceS) && CommonUtils.correctDouble(qtyS)) {
                return new double[]{Double.parseDouble(priceS), Double.parseDouble(qtyS)};
            }
        }
        log.error("Error parsing " + pricePerQtyTagValue + " with pattern " + pricePerQtyPriceTagValueFormat.pattern());
        return null;
    }

    public static String humanReadableFileSize(long fileSize, boolean evaluate) {
        return evaluate ? CommonUtils.humanReadableFileSize(fileSize) : "<file size not evaluated>";
    }

    public static String humanReadableFileSize(long fileSize) {
        if (fileSize < 0L) {
            throw new ODFRuntimeException("Negative fileSize, therefor it is invalid !");
        }
        if (fileSize < 1024L) {
            return String.format("%,d bytes", fileSize);
        }
        if (fileSize < 0x100000L) {
            return String.format("%,d kb", fileSize / 1024L);
        }
        return String.format("%,d mb", fileSize / 1024L * 1024L);
    }

    public static boolean isMapNullOrEmtpy(Map map, Object key) {
        return map == null || map.get(key) == null;
    }

    public static JsonNode buildEmptyJsonNode() {
        try {
            return new ObjectMapper().readTree("{}");
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public static String getNotNullString(String value, String defaultValue) {
        if (value == null || value.trim().length() == 0) {
            return defaultValue != null ? defaultValue : "";
        }
        return value;
    }

    public static String getNotNullString(String value) {
        return CommonUtils.getNotNullString(value, "");
    }

    public static double roundDoubleUp(double toRound, int scale) {
        try {
            return CommonUtils.roundDoubleUpNoCatch(toRound, scale);
        }
        catch (Exception e) {
            e.printStackTrace();
            return toRound;
        }
    }

    public static double roundDoubleUpNoCatch(double toRound, int scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(toRound).setScale(scale + 4, RoundingMode.HALF_UP);
        double res1 = bigDecimal.doubleValue();
        BigDecimal bd2 = BigDecimal.valueOf(res1).setScale(scale, RoundingMode.HALF_UP);
        double res2 = bd2.doubleValue();
        return res2;
    }

    public static CurrencyDDD buildLoyaltyPointsCurrency() {
        return new CurrencyDDD().setCode("LP").setCurrencyType(CurrencyType.INTERNAL).setDescription("Loyalty Points");
    }

    public static CurrencyDDD buildExperienceCurrency() {
        return new CurrencyDDD().setCode("XP").setCurrencyType(CurrencyType.INTERNAL).setDescription("Experience Points");
    }

    public static JsonNode getDetailsJsonNode(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return CommonUtils.getJsonNodeFromMap(map);
    }

    public static JsonNode getJsonNodeFromMap(Map map) {
        return new ObjectMapper().valueToTree((Object)map);
    }

    public static OperationResultResponseDDD returnError(String error) {
        return OperationResultResponseDDD.builder().setOperationResult(OperationResult.FAIL).setOperationResultDesc(error).setAdditionalInfos(CommonUtils.getDetailsJsonNode("Error", error)).build();
    }

    public static OperationResultResponseDDD returnWarn(String warningText) {
        return OperationResultResponseDDD.builder().setOperationResult(OperationResult.WARN).setOperationResultDesc(warningText).setAdditionalInfos(CommonUtils.getDetailsJsonNode("Warning", warningText)).build();
    }

    public static OperationResultResponseDDD returnOk() {
        return OperationResultResponseDDD.builder().setOperationResult(OperationResult.OK).setOperationResultDesc("OK").build();
    }

    public static OperationResultResponseDDD returnResult(boolean smthDone) {
        return OperationResultResponseDDD.builder().setOperationResult(smthDone ? OperationResult.OK : OperationResult.FAIL).build();
    }

    public static String formatDateFullTimestamp(Date date) {
        return FULL_TIMESTAMP.format(date);
    }

    public static String formatDate(String pattern, LocalDateTime localDateTime) {
        DateTimeFormatter formatter = timeFormatters.getOrDefault(pattern, DateTimeFormatter.ofPattern(pattern));
        timeFormatters.put(pattern, formatter);
        return localDateTime.format(formatter);
    }

    public static Map<String, Object> buildDefaultFormatterMapForOperatorTasks(String tableName, String zoneName, LocalDateTime requestDate) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("table", tableName);
        res.put("zone", zoneName);
        res.put("hour", requestDate.format(DateTimeFormatter.ISO_LOCAL_TIME));
        return res;
    }

    public static void addMaxINTIfEmptyList(List<Integer> list) {
        if (list.size() == 0) {
            list.add(Integer.MAX_VALUE);
        }
    }

    public static void addRandomUUIDIfEmptyList(List<String> list) {
        if (list.size() == 0) {
            list.add(UUID.randomUUID().toString());
        }
    }

    public static List<ODFId> cloneAndSortOdfIdList(List<ODFId> list) {
        ArrayList<ODFId> allList = new ArrayList<ODFId>();
        list.stream().forEach(k -> allList.add((ODFId)k));
        Collections.sort(allList, new Comparator<ODFId>(){

            @Override
            public int compare(ODFId odfId, ODFId t1) {
                return odfId.getUuidValue().compareToIgnoreCase(t1.getUuidValue());
            }
        });
        return allList;
    }

    public static GenericKeyValueDDD buildKeyValue(EMAIL_FIELDS field, String value) {
        return GenericKeyValueDDD.builder().setKey(field.name()).setValue(value).build();
    }

    public static boolean isValueZero(double check) {
        return CommonUtils.isValueZero(check, false);
    }

    public static boolean isValueZero(double check, boolean debug) {
        boolean b;
        double epsilon = 0.001;
        double abs = Math.abs(check);
        boolean bl = b = abs < epsilon;
        if (debug) {
            log.debug("isValueZero : toCheck {} , abs {} , result {} ", new Object[]{check, abs, b});
        }
        return b;
    }

    public static <K, V> Map<K, V> getJsonAsMap(JsonNode node, K key, V value, ObjectMapper objectMapper) {
        try {
            String json = objectMapper.writeValueAsString((Object)node);
            return CommonUtils.getJsonAsMap(json, key, value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode getJsonNodeFromObject(Object object, ObjectMapper objectMapper) {
        JsonNode node = objectMapper.valueToTree(object);
        return node;
    }

    public static <K, V> Map<K, V> getJsonAsMap(String json, K key, V value) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference typeRef = new TypeReference<Map<K, V>>(){};
            return (Map)mapper.readValue(json, typeRef);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldnt parse json:" + json, e);
        }
    }

    public static final StringI18List buildStringI18List(String payload, String lang) {
        ArrayList<StringWithLanguageIndication> stringWithLanguageIndications = new ArrayList<StringWithLanguageIndication>();
        stringWithLanguageIndications.add(StringWithLanguageIndication.builder().setLang(LanguageDDD.builder().code(lang).build()).setPayload(payload).build());
        return new StringI18List(stringWithLanguageIndications);
    }

    public static final String getTranslationForLangOrM2M(StringI18List list, String language) {
        return list.getForLang(language, "M2M");
    }

    public static final GenericKeyValueListDDD getKeyValueListFromJsonNodeOfGenericKeyValueDDD(JsonNode payload, String origin) {
        try {
            GenericKeyValueListDDD result = new GenericKeyValueListDDD();
            TypeReference<List<GenericKeyValueDDD>> listTypeReference = new TypeReference<List<GenericKeyValueDDD>>(){};
            List genericKeyValueDDDS = CommonUtils.convertToNonNullValue(payload, listTypeReference, new ArrayList(), origin);
            genericKeyValueDDDS.stream().forEach(k -> result.add((GenericKeyValueDDD)k));
            return result;
        }
        catch (Exception e) {
            log.error("getKeyValueListFromJsonNodeOfGenericKeyValueDDD ERROR {} for payload {} ", (Object)e.getMessage(), (Object)payload.toPrettyString());
            log.error("Exception follows {}", (Object)e.getMessage());
            return new GenericKeyValueListDDD();
        }
    }

    public static final <T> T convertToNonNullValue(Object fromValue, TypeReference<T> toValueTypeRef, T defaultValue, String origin) {
        return CommonUtils.convertToNonNullValue(fromValue, toValueTypeRef, defaultValue, origin, true);
    }

    public static final <T> T convertToNonNullValue(Object fromValue, TypeReference<T> toValueTypeRef, T defaultValue, String origin, boolean deserializationFailOnUnkownProperties) {
        Object t;
        ObjectMapper objectMapper = new ObjectMapper();
        if (!deserializationFailOnUnkownProperties) {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        if ((t = objectMapper.convertValue(fromValue, toValueTypeRef)) == null) {
            log.warn("NULL VALUE detected in convertToNonNullValue origin {} , using default ", (Object)origin);
            t = defaultValue;
        }
        return (T)t;
    }

    public static final GenericKeyValueListDDD getKeyValueListFromJsonNodeOfGenericKeyValueList(JsonNode payload, String origin) {
        try {
            TypeReference<GenericKeyValueListDDD> listTypeReference = new TypeReference<GenericKeyValueListDDD>(){};
            GenericKeyValueListDDD result = CommonUtils.convertToNonNullValue(payload, listTypeReference, new GenericKeyValueListDDD(), origin);
            return result;
        }
        catch (Exception e) {
            try {
                GenericKeyValueListDDD secondChoice = CommonUtils.getKeyValueListFromJsonNodeOfGenericKeyValueDDD(payload, origin);
                return secondChoice;
            }
            catch (Exception e1) {
                log.error("getKeyValueListFromJsonNodeOfGenericKeyValueList ERROR {} for payload {} ", (Object)e.getMessage(), (Object)payload.toPrettyString());
                log.error("Exception follows {}", (Object)e.getMessage());
                return new GenericKeyValueListDDD();
            }
        }
    }

    public static boolean correctBoolean(String toCheck) {
        String s;
        return CommonUtils.correctString(toCheck) && ((s = toCheck.trim().toLowerCase()).equalsIgnoreCase("true") || s.equalsIgnoreCase("false"));
    }

    public static boolean correctDouble(String toCheck) {
        if (CommonUtils.correctString(toCheck)) {
            try {
                Double.parseDouble(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctString(String toCheck) {
        return toCheck != null && !toCheck.trim().equals("");
    }

    public static boolean correctInteger(String toCheck) {
        if (CommonUtils.correctString(toCheck)) {
            try {
                Integer.parseInt(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctUUID(String toCheck) {
        try {
            UUID uuid = UUID.fromString(toCheck);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean correctList(List list) {
        return list != null && list.size() > 0;
    }

    public static boolean correctSet(Set list) {
        return list != null && list.size() > 0;
    }

    public static String sanitizeFilename(String inputName) {
        return inputName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static boolean correctEmail(String toCheck) {
        return CommonUtils.correctString(toCheck) && emailPattern.matcher(toCheck).matches();
    }

    public static String getHumanFriendlyToString(List<StringI18List> i18Names, String lang, String defaultLang) {
        Function<StringI18List, String> translate = k -> k.getForLang(lang, defaultLang);
        return i18Names.stream().map(translate).collect(Collectors.joining(", "));
    }

    public static GpsPointDDD gpsPointFromStructuredAddress(StructuredAddress sa) {
        GpsPointDDD point = GpsPointDDD.builder().setLat(sa.getValueForField(AddressFieldTypeEnum.GPS_LATITUDE)).setLon(sa.getValueForField(AddressFieldTypeEnum.GPS_LONGITUDE)).build();
        return point;
    }

    public static boolean isCorrectGpsAddress(StructuredAddress sa) {
        return sa != null && CommonUtils.correctString(sa.getValueForField(AddressFieldTypeEnum.GPS_LATITUDE)) && CommonUtils.correctString(sa.getValueForField(AddressFieldTypeEnum.GPS_LONGITUDE));
    }

    public static boolean isCorrectGpsPoint(GpsPointDDD point) {
        return point != null && CommonUtils.correctDouble(point.getLat()) && CommonUtils.correctDouble(point.getLon());
    }

    public static String getString2DecimalsNoTrunc(Double number) {
        if (number == null) {
            return "";
        }
        String result = NUMBER_2DECIMALS_NO_TRUNC.format(number);
        return result;
    }

    public static String getString2Decimals(Double number) {
        if (number == null) {
            return "";
        }
        String result = NUMBER_2DECIMALS.format(number);
        return result;
    }

    public static double extractVAT_3Decimals(double source, int vatPercent) {
        return CommonUtils.extractVAT_N_Decimals(source, vatPercent, 3);
    }

    public static double extractVAT_2Decimals(double source, int vatPercent) {
        return CommonUtils.extractVAT_N_Decimals(source, vatPercent, 2);
    }

    public static double extractVAT_N_Decimals(double source, int vatPercent, int decimals) {
        double result = source / (1.0 + (double)vatPercent / 100.0);
        return CommonUtils.roundDoubleUp(result, decimals);
    }

    public static Object runGetter(String fieldName, Object o) {
        try {
            Field field = WeeklyScheduleDDD.class.getDeclaredField(fieldName);
            try {
                Object value = field.get(o);
                return value;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (Method method : o.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || !methodName.equalsIgnoreCase("get" + fieldName)) continue;
            try {
                return method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public static LocalDateTime getNowInUTC() {
        Instant instant = Instant.now();
        LocalDateTime now = instant.atZone(ZoneId.of("UTC")).toLocalDateTime();
        return now;
    }

    public static ZonedDateTime setCurrentDateToLocalDateTime(ZonedDateTime keepTime, ZonedDateTime now) {
        ZonedDateTime result = keepTime.withDayOfYear(now.getDayOfYear()).withMonth(now.getMonthValue()).withYear(now.getYear());
        return result;
    }

    public static String getDetails(WorkOrderLineDDD workOrderLineDDD, String prefLang) {
        List<OrderEventDetailsWithNamesDDD> textDetails = workOrderLineDDD.getTextDetails();
        if (textDetails == null || textDetails.size() == 0) {
            return "";
        }
        return CommonUtils.getDetails(textDetails, prefLang);
    }

    public static String getDetails(List<OrderEventDetailsWithNamesDDD> textDetails, String prefLang) {
        return CommonUtils.getDetails(textDetails, prefLang, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public static String getDetails(List<OrderEventDetailsWithNamesDDD> textDetails, String prefLang, @NonNull Map<String, String> collectInMapHumanReadableKeys, @NonNull Map<String, String> collectInMapM2MKeys) {
        if (collectInMapHumanReadableKeys == null) {
            throw new NullPointerException("collectInMapHumanReadableKeys is marked non-null but is null");
        }
        if (collectInMapM2MKeys == null) {
            throw new NullPointerException("collectInMapM2MKeys is marked non-null but is null");
        }
        StringBuffer result = new StringBuffer();
        result.append("(");
        String separator = ", ";
        for (OrderEventDetailsWithNamesDDD field : textDetails) {
            String keyHumanReadable = field.getOptionNames().getForLang(prefLang, prefLang);
            String keyM2M = field.getOptionNames().getForLang("M2M", "M2M");
            if (keyM2M == null) {
                keyM2M = keyHumanReadable;
            }
            boolean smthDone = false;
            ODFIdWithNameListDDD selectedIds = field.getSelectedIds();
            if (selectedIds != null && selectedIds.getList() != null && selectedIds.getList().size() > 0) {
                ArrayList arr = new ArrayList();
                selectedIds.getList().stream().forEach(k -> arr.add(k.getNames().getForLang(prefLang, prefLang)));
                if (arr.size() > 0) {
                    String allValues = arr.stream().collect(Collectors.joining(separator));
                    String prefix = keyHumanReadable != null ? keyHumanReadable + ":" : "";
                    result.append(prefix + "[" + allValues + "]" + separator);
                    collectInMapHumanReadableKeys.put(keyHumanReadable, allValues);
                    collectInMapM2MKeys.put(keyM2M, allValues);
                    smthDone = true;
                }
            } else if (field.getUserInput() != null) {
                String value = field.getUserInput().getPayload();
                String prefix = keyHumanReadable != null ? keyHumanReadable + ":" : "";
                result.append(prefix + value);
                collectInMapHumanReadableKeys.put(keyHumanReadable, value);
                collectInMapM2MKeys.put(keyM2M, value);
                smthDone = true;
            }
            if (!smthDone) continue;
            result.append(separator);
        }
        if (result.length() > 1) {
            result.setLength(result.length() - separator.length());
        }
        result.append(")");
        if (result.length() == 2) {
            result.setLength(0);
        }
        return result.toString();
    }

    public static Object fileToObject(File file, Class _class) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        Object o = mapper.readValue(file, _class);
        return o;
    }

    public static Object fileToObject(InputStream file, Class _class) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        Object o = mapper.readValue(file, _class);
        return o;
    }

    public static Object stringToObject(String jsonText, Class _class) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        Object o = mapper.readValue(jsonText, _class);
        return o;
    }

    public static Object treeToObject(JsonNode node, Class _class) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object o = mapper.treeToValue((TreeNode)node, _class);
        return o;
    }

    public static JsonNode objectToTree(Object o) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode n = mapper.valueToTree(o);
        return n;
    }

    public static Object cloneByJson(Object o) {
        try {
            return CommonUtils.treeToObject(CommonUtils.objectToTree(o), o.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getForLangOrM2M(StringI18List stringI18List, String langCode) {
        return stringI18List.getForLang(langCode, "M2M");
    }

    public static String getNicknameFromEmailAddress(String emailAddress) {
        int maxChars = 6;
        if (emailAddress != null) {
            int until = emailAddress.indexOf("@");
            if (until > maxChars) {
                until = maxChars;
            }
            String res = emailAddress.substring(0, until);
            return res;
        }
        return UUID.randomUUID().toString().substring(0, maxChars);
    }

    public static String getStringMaxSize(int totalDigits, String toConvert, Character fillChar, boolean before) {
        if (toConvert == null) {
            toConvert = "";
        }
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            if (fillChar != null) {
                for (int i = toConvert.length(); i < totalDigits; ++i) {
                    result = before ? fillChar.charValue() + result : result + fillChar.charValue();
                }
            }
            return result;
        }
        return toConvert;
    }

    public static GenericKeyValueDDD normalizePossibleTagId(String cardOrTagId) {
        String out;
        boolean fromNFC = false;
        String actualData = cardOrTagId;
        try {
            NfcTagIdWrapper nfcTagIdWrapper = (NfcTagIdWrapper)CommonUtils.stringToObject(cardOrTagId, NfcTagIdWrapper.class);
            String tagId = nfcTagIdWrapper.getTagId();
            log.debug("normalizePossibleTagId : detected NFC wrapper {}, tagId \"{}\", tagData \"{}\"", new Object[]{nfcTagIdWrapper, tagId, nfcTagIdWrapper.getTagData()});
            actualData = tagId;
            fromNFC = true;
        }
        catch (IOException nfcTagIdWrapper) {
            // empty catch block
        }
        String prefix = "NFC:";
        if (actualData.toUpperCase().startsWith(prefix)) {
            actualData = actualData.substring(prefix.length());
            actualData = actualData + ";";
            fromNFC = true;
        }
        if (!cardOrTagId.equals(out = actualData.replace(":", "").toLowerCase())) {
            log.debug("normalizePossibleTagId : input {}, out {}", (Object)cardOrTagId, (Object)out);
        }
        return GenericKeyValueDDD.builder().setKey(fromNFC ? "NFC" : "lesserSecurity").setValue(out).build();
    }

    public static Date getFirstDay(int month, int year) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addYearsToDate(Date date, int toAdd) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, toAdd);
        return calendar.getTime();
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static <T> List<T> listOf(T ... arr) {
        ArrayList<T> res = new ArrayList<T>();
        for (T t : arr) {
            if (t == null) continue;
            res.add(t);
        }
        return res;
    }

    private CommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

