/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.enums;

import lombok.NonNull;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;

public interface EnumWithStringConstantAsTheName<E extends Enum<E>> {
    public static final String EXCEPTION_MESSAGE_FORMAT = "Enums<%s> member<%s> should have an associated similar constant name string";

    default public void makeSureEnumConstantHasSameNameAsGivenStr(@NonNull String enumConstantStringName) {
        if (enumConstantStringName == null) {
            throw new NullPointerException("enumConstantStringName is marked non-null but is null");
        }
        Enum thisEnumMember = (Enum)((Object)this);
        this.setEnumConstantStringName(enumConstantStringName);
        if (!thisEnumMember.name().equals(this.getEnumConstantStringName())) {
            throw new ODFRuntimeException(String.format(EXCEPTION_MESSAGE_FORMAT, this.getClass().getSimpleName(), thisEnumMember.name()));
        }
    }

    public String getEnumConstantStringName();

    public E setEnumConstantStringName(@NonNull String var1);
}

