/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.Token;
import com.google.zxing.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short a;
    private final short b;

    BinaryShiftToken(Token token, int n2, int n3) {
        super(token);
        this.a = (short)n2;
        this.b = (short)n3;
    }

    @Override
    public final void appendTo(BitArray bitArray, byte[] byArray) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (i2 == 0 || i2 == 31 && this.b <= 62) {
                bitArray.appendBits(31, 5);
                if (this.b > 62) {
                    bitArray.appendBits(this.b - 31, 16);
                } else if (i2 == 0) {
                    bitArray.appendBits(Math.min(this.b, 31), 5);
                } else {
                    bitArray.appendBits(this.b - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.a + i2], 8);
        }
    }

    public final String toString() {
        return "<" + this.a + "::" + (this.a + this.b - 1) + '>';
    }
}

