/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import com.google.zxing.oned.UPCEReader;
import java.util.Map;

public final class UPCEWriter
extends UPCEANWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.UPC_E) {
            throw new IllegalArgumentException("Can only encode UPC_E, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2 = string.length();
        switch (n2) {
            case 7: {
                try {
                    n2 = UPCEANReader.a(UPCEReader.convertUPCEtoUPCA(string));
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException(formatException);
                }
                string = string + n2;
                break;
            }
            case 8: {
                try {
                    if (!UPCEANReader.a(string)) {
                        throw new IllegalArgumentException("Contents do not pass checksum");
                    }
                    break;
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + n2);
            }
        }
        n2 = Character.digit(string.charAt(0), 10);
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Number system must be 0 or 1");
        }
        int n3 = Character.digit(string.charAt(7), 10);
        n2 = UPCEReader.c[n2][n3];
        boolean[] blArray = new boolean[51];
        int n4 = 0 + UPCEWriter.appendPattern(blArray, 0, UPCEANReader.b, true);
        for (int i2 = 1; i2 <= 6; ++i2) {
            int n5 = Character.digit(string.charAt(i2), 10);
            if ((n2 >> 6 - i2 & 1) == 1) {
                n5 += 10;
            }
            n4 += UPCEWriter.appendPattern(blArray, n4, UPCEANReader.b[n5], false);
        }
        UPCEWriter.appendPattern(blArray, n4, UPCEANReader.d, false);
        return blArray;
    }
}

