/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.types.EnumStringType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPersisterManager {
    private static final p DEFAULT_ENUM_PERSISTER = EnumStringType.getSingleton();
    private static final Map<String, p> builtInMap;
    private static List<p> registeredPersisters;

    private DataPersisterManager() {
    }

    public static void registerDataPersisters(p ... pArray) {
        ArrayList<p> arrayList = new ArrayList<p>();
        if (registeredPersisters != null) {
            arrayList.addAll(registeredPersisters);
        }
        for (p p2 : pArray) {
            arrayList.add(p2);
        }
        registeredPersisters = arrayList;
    }

    public static void clear() {
        registeredPersisters = null;
    }

    public static p lookupForField(Field field) {
        Object object;
        if (registeredPersisters != null) {
            object = registeredPersisters.iterator();
            while (object.hasNext()) {
                p p2 = object.next();
                if (p2.isValidForField(field)) {
                    return p2;
                }
                for (Class<?> clazz : p2.getAssociatedClasses()) {
                    if (field.getType() != clazz) continue;
                    return p2;
                }
            }
        }
        if ((object = builtInMap.get(field.getType().getName())) != null) {
            return object;
        }
        if (field.getType().isEnum()) {
            return DEFAULT_ENUM_PERSISTER;
        }
        return null;
    }

    static {
        registeredPersisters = null;
        builtInMap = new HashMap<String, p>();
        DataType[] dataTypeArray = DataType.values();
        int n2 = dataTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            p p2 = dataTypeArray[i2].getDataPersister();
            if (p2 == null) continue;
            for (Class<?> clazz : p2.getAssociatedClasses()) {
                builtInMap.put(clazz.getName(), p2);
            }
            if (p2.getAssociatedClassNames() == null) continue;
            for (String string : p2.getAssociatedClassNames()) {
                builtInMap.put(string, p2);
            }
        }
    }
}

