/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.EagerForeignCollection;
import com.j256.ormlite.dao.LazyForeignCollection;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldType$LevelCounters;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    private static boolean DEFAULT_VALUE_BOOLEAN;
    private static byte DEFAULT_VALUE_BYTE;
    private static char DEFAULT_VALUE_CHAR;
    private static short DEFAULT_VALUE_SHORT;
    private static int DEFAULT_VALUE_INT;
    private static long DEFAULT_VALUE_LONG;
    private static float DEFAULT_VALUE_FLOAT;
    private static double DEFAULT_VALUE_DOUBLE;
    private final L connectionSource;
    private final String tableName;
    private final Field field;
    private final String columnName;
    private final DatabaseFieldConfig fieldConfig;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final String generatedIdSequence;
    private final Method fieldGetMethod;
    private final Method fieldSetMethod;
    private final Class<?> parentClass;
    private p dataPersister;
    private Object defaultValue;
    private Object dataTypeConfigObj;
    private q fieldConverter;
    private FieldType foreignIdField;
    private TableInfo<?, ?> foreignTableInfo;
    private FieldType foreignFieldType;
    private BaseDaoImpl<?, ?> foreignDao;
    private MappedQueryForId<Object, Object> mappedQueryForId;
    private static final ThreadLocal<FieldType$LevelCounters> threadLevelCounters;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldType(L object, String string, Field field, DatabaseFieldConfig databaseFieldConfig, Class<?> clazz) {
        Object object2;
        Object object3;
        p p2;
        Class<? extends p> clazz2;
        block46: {
            block45: {
                this.connectionSource = object;
                this.tableName = string;
                object = object.a();
                this.field = field;
                this.parentClass = clazz;
                databaseFieldConfig.postProcess();
                clazz = field.getType();
                if (databaseFieldConfig.getDataPersister() != null) break block45;
                clazz2 = databaseFieldConfig.getPersisterClass();
                if (clazz2 == null || clazz2 == t.class) {
                    p2 = DataPersisterManager.lookupForField(field);
                    break block46;
                } else {
                    try {
                        object3 = clazz2.getDeclaredMethod("getSingleton", new Class[0]);
                    }
                    catch (Exception exception) {
                        throw LoggerFactory$1.create("Could not find getSingleton static method on class " + clazz2, exception);
                    }
                    try {
                        object2 = ((Method)object3).invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw LoggerFactory$1.create("Could not run getSingleton method on class " + clazz2, invocationTargetException.getTargetException());
                    }
                    catch (Exception exception) {
                        throw LoggerFactory$1.create("Could not run getSingleton method on class " + clazz2, exception);
                    }
                    if (object2 == null) {
                        throw new SQLException("Static getSingleton method should not return null on class " + clazz2);
                    }
                    try {
                        p2 = (p)object2;
                    }
                    catch (Exception exception) {
                        throw LoggerFactory$1.create("Could not cast result of static getSingleton method to DataPersister from class " + clazz2, exception);
                    }
                }
            }
            p2 = databaseFieldConfig.getDataPersister();
            if (!p2.isValidForField(field)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Field class ").append(clazz.getName());
                stringBuilder.append(" for field ").append(this);
                stringBuilder.append(" is not valid for type ").append(p2);
                Class<?> clazz3 = p2.getPrimaryClass();
                if (clazz3 != null) {
                    stringBuilder.append(", maybe should be " + clazz3);
                }
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        }
        clazz2 = databaseFieldConfig.getForeignColumnName();
        object3 = field.getName();
        if (databaseFieldConfig.isForeign() || databaseFieldConfig.isForeignAutoRefresh() || clazz2 != null) {
            if (p2 != null && p2.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + clazz + " but marked as foreign");
            }
            object3 = clazz2 == null ? (String)object3 + FOREIGN_ID_FIELD_SUFFIX : (String)object3 + "_" + (String)((Object)clazz2);
            if (g.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field '" + field.getName() + "' in class " + clazz + "' should use the @" + ForeignCollectionField.class.getSimpleName() + " annotation not foreign=true");
            }
        } else if (databaseFieldConfig.isForeignCollection()) {
            if (clazz != Collection.class && !g.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be of class " + g.class.getSimpleName() + " or Collection.");
            }
            object2 = field.getGenericType();
            if (!(object2 instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection.");
            }
            if (((ParameterizedType)object2).getActualTypeArguments().length == 0) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
        } else if (p2 == null && !databaseFieldConfig.isForeignCollection()) {
            if (byte[].class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'. byte[] fields must specify dataType=DataType.BYTE_ARRAY or SERIALIZABLE");
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite does not know how to store " + clazz + " for field '" + field.getName() + "'.  Use another class, custom persister, or to serialize it use dataType=DataType.SERIALIZABLE");
            }
            throw new IllegalArgumentException("ORMLite does not know how to store " + clazz + " for field " + field.getName() + ". Use another class or a custom persister.");
        }
        this.columnName = databaseFieldConfig.getColumnName() == null ? object3 : databaseFieldConfig.getColumnName();
        this.fieldConfig = databaseFieldConfig;
        if (databaseFieldConfig.isId()) {
            if (databaseFieldConfig.isGeneratedId() || databaseFieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        } else if (databaseFieldConfig.isGeneratedId()) {
            if (databaseFieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = true;
            this.generatedIdSequence = object.isIdSequenceNeeded() ? object.generateIdSequenceName(string, this) : null;
        } else if (databaseFieldConfig.getGeneratedIdSequence() != null) {
            this.isId = true;
            this.isGeneratedId = true;
            object2 = databaseFieldConfig.getGeneratedIdSequence();
            if (object.isEntityNamesMustBeUpCase()) {
                object2 = ((String)object2).toUpperCase();
            }
            this.generatedIdSequence = object2;
        } else {
            this.isId = false;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        }
        if (this.isId && (databaseFieldConfig.isForeign() || databaseFieldConfig.isForeignAutoRefresh())) {
            throw new IllegalArgumentException("Id field " + field.getName() + " cannot also be a foreign object");
        }
        if (databaseFieldConfig.isUseGetSet()) {
            this.fieldGetMethod = DatabaseFieldConfig.findGetMethod(field, true);
            this.fieldSetMethod = DatabaseFieldConfig.findSetMethod(field, true);
        } else {
            if (!field.isAccessible()) {
                try {
                    this.field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException("Could not open access to field " + field.getName() + ".  You may have to set useGetSet=true to fix.");
                }
            }
            this.fieldGetMethod = null;
            this.fieldSetMethod = null;
        }
        if (databaseFieldConfig.isAllowGeneratedIdInsert() && !databaseFieldConfig.isGeneratedId()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must be a generated-id if allowGeneratedIdInsert = true");
        }
        if (databaseFieldConfig.isForeignAutoRefresh() && !databaseFieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoRefresh = true");
        }
        if (databaseFieldConfig.isForeignAutoCreate() && !databaseFieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignAutoCreate = true");
        }
        if (databaseFieldConfig.getForeignColumnName() != null && !databaseFieldConfig.isForeign()) {
            throw new IllegalArgumentException("Field " + field.getName() + " must have foreign = true if foreignColumnName is set");
        }
        if (databaseFieldConfig.isVersion() && (p2 == null || !p2.isValidForVersion())) {
            throw new IllegalArgumentException("Field " + field.getName() + " is not a valid type to be a version field");
        }
        if (databaseFieldConfig.getMaxForeignAutoRefreshLevel() > 0 && !databaseFieldConfig.isForeignAutoRefresh()) {
            throw new IllegalArgumentException("Field " + field.getName() + " has maxForeignAutoRefreshLevel set but not foreignAutoRefresh is false");
        }
        this.assignDataType((m)object, p2);
    }

    public void configDaoInformation(L object, Class<?> object2) {
        DatabaseTableConfig<?> databaseTableConfig;
        Object object3 = this.field.getType();
        m m2 = object.a();
        Object object4 = this.fieldConfig.getForeignColumnName();
        if (this.fieldConfig.isForeignAutoRefresh() || object4 != null) {
            databaseTableConfig = this.fieldConfig.getForeignTableConfig();
            if (databaseTableConfig == null) {
                databaseTableConfig = (BaseDaoImpl)DaoManager.createDao((L)object, object3);
                object = ((BaseDaoImpl)((Object)databaseTableConfig)).getTableInfo();
            } else {
                databaseTableConfig.extractFieldTypes((L)object);
                databaseTableConfig = (BaseDaoImpl)DaoManager.createDao((L)object, databaseTableConfig);
                object = ((BaseDaoImpl)((Object)databaseTableConfig)).getTableInfo();
            }
            if (object4 == null) {
                object2 = ((TableInfo)object).getIdField();
                if (object2 == null) {
                    throw new IllegalArgumentException("Foreign field " + object3 + " does not have id field");
                }
            } else {
                object2 = ((TableInfo)object).getFieldTypeByColumnName((String)object4);
                if (object2 == null) {
                    throw new IllegalArgumentException("Foreign field " + object3 + " does not have field named '" + (String)object4 + "'");
                }
            }
            object4 = MappedQueryForId.build(m2, object, (FieldType)object2);
            object3 = null;
        } else if (this.fieldConfig.isForeign()) {
            if (this.dataPersister != null && this.dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + object3 + " but marked as foreign");
            }
            databaseTableConfig = this.fieldConfig.getForeignTableConfig();
            if (databaseTableConfig != null) {
                databaseTableConfig.extractFieldTypes((L)object);
                databaseTableConfig = (BaseDaoImpl)DaoManager.createDao(object, databaseTableConfig);
            } else {
                databaseTableConfig = (BaseDaoImpl)DaoManager.createDao(object, object3);
            }
            object = ((BaseDaoImpl)((Object)databaseTableConfig)).getTableInfo();
            object2 = ((TableInfo)object).getIdField();
            if (object2 == null) {
                throw new IllegalArgumentException("Foreign field " + object3 + " does not have id field");
            }
            if (this.isForeignAutoCreate() && !((FieldType)object2).isGeneratedId()) {
                throw new IllegalArgumentException("Field " + this.field.getName() + ", if foreignAutoCreate = true then class " + ((Class)object3).getSimpleName() + " must have id field with generatedId = true");
            }
            object3 = null;
            object4 = null;
        } else if (this.fieldConfig.isForeignCollection()) {
            if (object3 != Collection.class && !g.class.isAssignableFrom((Class<?>)object3)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be of class " + g.class.getSimpleName() + " or Collection.");
            }
            databaseTableConfig = this.field.getGenericType();
            if (!(databaseTableConfig instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection.");
            }
            object3 = ((ParameterizedType)((Object)databaseTableConfig)).getActualTypeArguments();
            if (((Type[])object3).length == 0) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
            object3 = (Class)object3[0];
            databaseTableConfig = this.fieldConfig.getForeignTableConfig();
            object = databaseTableConfig == null ? (BaseDaoImpl)DaoManager.createDao(object, object3) : (BaseDaoImpl)DaoManager.createDao(object, databaseTableConfig);
            databaseTableConfig = object;
            object3 = this.findForeignFieldType((Class<?>)object3, (Class<?>)object2, (BaseDaoImpl<?, ?>)object);
            object2 = null;
            object = null;
            object4 = null;
        } else {
            object = null;
            object2 = null;
            object3 = null;
            databaseTableConfig = null;
            object4 = null;
        }
        this.mappedQueryForId = object4;
        this.foreignTableInfo = object;
        this.foreignFieldType = object3;
        this.foreignDao = databaseTableConfig;
        this.foreignIdField = object2;
        if (this.foreignIdField != null) {
            this.assignDataType(m2, this.foreignIdField.getDataPersister());
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public p getDataPersister() {
        return this.dataPersister;
    }

    public Object getDataTypeConfigObj() {
        return this.dataTypeConfigObj;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.fieldConfig.getWidth();
    }

    public boolean isCanBeNull() {
        return this.fieldConfig.isCanBeNull();
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isGeneratedIdSequence() {
        return this.generatedIdSequence != null;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public boolean isForeign() {
        return this.fieldConfig.isForeign();
    }

    public void assignField(Object object, Object object2, boolean bl2, i i2) {
        if (this.foreignIdField != null && object2 != null) {
            Object object3 = this.extractJavaFieldValue(object);
            if (object3 != null && object3.equals(object2)) {
                return;
            }
            if (!bl2) {
                Object object4;
                object3 = threadLevelCounters.get();
                if (((FieldType$LevelCounters)object3).autoRefreshLevel == 0) {
                    ((FieldType$LevelCounters)object3).autoRefreshLevelMax = this.fieldConfig.getMaxForeignAutoRefreshLevel();
                }
                if (((FieldType$LevelCounters)object3).autoRefreshLevel >= ((FieldType$LevelCounters)object3).autoRefreshLevelMax) {
                    object4 = this.foreignTableInfo.createObject();
                    this.foreignIdField.assignField(object4, object2, false, i2);
                } else {
                    if (this.mappedQueryForId == null) {
                        MappedQueryForId<?, ?> mappedQueryForId = MappedQueryForId.build(this.connectionSource.a(), this.foreignDao.getTableInfo(), this.foreignIdField);
                        this.mappedQueryForId = mappedQueryForId;
                    }
                    ++((FieldType$LevelCounters)object3).autoRefreshLevel;
                    try {
                        object4 = this.connectionSource.a();
                        object4 = this.mappedQueryForId.execute((DatabaseConnection)object4, object2, i2);
                    }
                    finally {
                        --((FieldType$LevelCounters)object3).autoRefreshLevel;
                    }
                }
                object2 = object4;
            }
        }
        if (this.fieldSetMethod == null) {
            try {
                this.field.set(object, object2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LoggerFactory$1.create("Could not assign object '" + object2 + "' to field " + this, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw LoggerFactory$1.create("Could not assign object '" + object2 + "' to field " + this, illegalAccessException);
            }
        }
        try {
            this.fieldSetMethod.invoke(object, object2);
            return;
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not call " + this.fieldSetMethod + " on object with '" + object2 + "' for " + this, exception);
        }
    }

    public Object assignIdValue(Object object, Number object2, i i2) {
        if ((object2 = this.dataPersister.convertIdNumber((Number)object2)) == null) {
            throw new SQLException("Invalid class " + this.dataPersister + " for sequence-id " + this);
        }
        this.assignField(object, object2, false, i2);
        return object2;
    }

    public <FV> FV extractRawJavaFieldValue(Object object) {
        if (this.fieldGetMethod == null) {
            try {
                object = this.field.get(object);
            }
            catch (Exception exception) {
                throw LoggerFactory$1.create("Could not get field value for " + this, exception);
            }
        }
        try {
            object = this.fieldGetMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not call " + this.fieldGetMethod + " for " + this, exception);
        }
        return (FV)object;
    }

    public Object extractJavaFieldValue(Object object) {
        object = this.extractRawJavaFieldValue(object);
        if (this.foreignIdField != null && object != null) {
            object = this.foreignIdField.extractRawJavaFieldValue(object);
        }
        return object;
    }

    public Object extractJavaFieldToSqlArgValue(Object object) {
        return this.convertJavaFieldToSqlArgValue(this.extractJavaFieldValue(object));
    }

    public Object convertJavaFieldToSqlArgValue(Object object) {
        if (object == null) {
            return null;
        }
        return this.fieldConverter.javaToSqlArg(this, object);
    }

    public Object convertStringToJavaField(String string, int n2) {
        if (string == null) {
            return null;
        }
        return this.fieldConverter.resultStringToJava(this, string, n2);
    }

    public Object moveToNextValue(Object object) {
        if (this.dataPersister == null) {
            return null;
        }
        return this.dataPersister.moveToNextValue(object);
    }

    public FieldType getForeignIdField() {
        return this.foreignIdField;
    }

    public boolean isEscapedValue() {
        return this.dataPersister.isEscapedValue();
    }

    public Enum<?> getUnknownEnumVal() {
        return this.fieldConfig.getUnknownEnumValue();
    }

    public String getFormat() {
        return this.fieldConfig.getFormat();
    }

    public boolean isUnique() {
        return this.fieldConfig.isUnique();
    }

    public boolean isUniqueCombo() {
        return this.fieldConfig.isUniqueCombo();
    }

    public String getIndexName() {
        return this.fieldConfig.getIndexName(this.tableName);
    }

    public String getUniqueIndexName() {
        return this.fieldConfig.getUniqueIndexName(this.tableName);
    }

    public boolean isEscapedDefaultValue() {
        return this.dataPersister.isEscapedDefaultValue();
    }

    public boolean isComparable() {
        if (this.fieldConfig.isForeignCollection()) {
            return false;
        }
        if (this.dataPersister == null) {
            throw new SQLException("Internal error.  Data-persister is not configured for field.  Please post _full_ exception with associated data objects to mailing list: " + this);
        }
        return this.dataPersister.isComparable();
    }

    public boolean isArgumentHolderRequired() {
        return this.dataPersister.isArgumentHolderRequired();
    }

    public boolean isForeignCollection() {
        return this.fieldConfig.isForeignCollection();
    }

    public <FT, FID> BaseForeignCollection<FT, FID> buildForeignCollection(Object eagerForeignCollection, FID FID) {
        if (this.foreignFieldType == null) {
            return null;
        }
        BaseDaoImpl<?, ?> baseDaoImpl = this.foreignDao;
        if (!this.fieldConfig.isForeignCollectionEager()) {
            return new LazyForeignCollection(baseDaoImpl, eagerForeignCollection, FID, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        FieldType$LevelCounters fieldType$LevelCounters = threadLevelCounters.get();
        if (fieldType$LevelCounters.foreignCollectionLevel == 0) {
            fieldType$LevelCounters.foreignCollectionLevelMax = this.fieldConfig.getForeignCollectionMaxEagerLevel();
        }
        if (fieldType$LevelCounters.foreignCollectionLevel >= fieldType$LevelCounters.foreignCollectionLevelMax) {
            return new LazyForeignCollection(baseDaoImpl, eagerForeignCollection, FID, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
        }
        ++fieldType$LevelCounters.foreignCollectionLevel;
        try {
            eagerForeignCollection = new EagerForeignCollection(baseDaoImpl, eagerForeignCollection, FID, this.foreignFieldType, this.fieldConfig.getForeignCollectionOrderColumnName(), this.fieldConfig.isForeignCollectionOrderAscending());
            return eagerForeignCollection;
        }
        finally {
            --fieldType$LevelCounters.foreignCollectionLevel;
        }
    }

    public <T> T resultToJava$7cb04d65(k k2, Map<String, Integer> object) {
        Integer n2 = object.get(this.columnName);
        if (n2 == null) {
            n2 = k2.d();
            object.put((String)this.columnName, (Integer)n2);
        }
        object = this.fieldConverter.resultToJava$6e4db97a(this, k2, n2);
        if (this.fieldConfig.isForeign()) {
            n2.intValue();
            if (k2.f()) {
                return null;
            }
        } else if (this.dataPersister.isPrimitive()) {
            if (this.fieldConfig.isThrowIfNull()) {
                n2.intValue();
                if (k2.f()) {
                    throw new SQLException("Results value for primitive field '" + this.field.getName() + "' was an invalid null value");
                }
            }
        } else if (!this.fieldConverter.isStreamType()) {
            n2.intValue();
            if (k2.f()) {
                return null;
            }
        }
        return (T)object;
    }

    public boolean isSelfGeneratedId() {
        return this.dataPersister.isSelfGeneratedId();
    }

    public boolean isAllowGeneratedIdInsert() {
        return this.fieldConfig.isAllowGeneratedIdInsert();
    }

    public String getColumnDefinition() {
        return this.fieldConfig.getColumnDefinition();
    }

    public boolean isForeignAutoCreate() {
        return this.fieldConfig.isForeignAutoCreate();
    }

    public boolean isVersion() {
        return this.fieldConfig.isVersion();
    }

    public Object generateId() {
        return this.dataPersister.generateId();
    }

    public boolean isReadOnly() {
        return this.fieldConfig.isReadOnly();
    }

    public <FV> FV getFieldValueIfNotDefault(Object object) {
        if (this.isFieldValueDefault(object = this.extractJavaFieldValue(object))) {
            return null;
        }
        return (FV)object;
    }

    public boolean isObjectsFieldValueDefault(Object object) {
        object = this.extractJavaFieldValue(object);
        return this.isFieldValueDefault(object);
    }

    public Object getJavaDefaultValueDefault() {
        if (this.field.getType() == Boolean.TYPE) {
            return DEFAULT_VALUE_BOOLEAN;
        }
        if (this.field.getType() == Byte.TYPE || this.field.getType() == Byte.class) {
            return DEFAULT_VALUE_BYTE;
        }
        if (this.field.getType() == Character.TYPE || this.field.getType() == Character.class) {
            return Character.valueOf(DEFAULT_VALUE_CHAR);
        }
        if (this.field.getType() == Short.TYPE || this.field.getType() == Short.class) {
            return DEFAULT_VALUE_SHORT;
        }
        if (this.field.getType() == Integer.TYPE || this.field.getType() == Integer.class) {
            return DEFAULT_VALUE_INT;
        }
        if (this.field.getType() == Long.TYPE || this.field.getType() == Long.class) {
            return DEFAULT_VALUE_LONG;
        }
        if (this.field.getType() == Float.TYPE || this.field.getType() == Float.class) {
            return Float.valueOf(DEFAULT_VALUE_FLOAT);
        }
        if (this.field.getType() == Double.TYPE || this.field.getType() == Double.class) {
            return DEFAULT_VALUE_DOUBLE;
        }
        return null;
    }

    public <T> int createWithForeignDao(T t2) {
        return this.foreignDao.create(t2);
    }

    public static FieldType createFieldType(L l2, String string, Field field, Class<?> clazz) {
        DatabaseFieldConfig databaseFieldConfig = DatabaseFieldConfig.fromField(l2.a(), string, field);
        if (databaseFieldConfig == null) {
            return null;
        }
        return new FieldType(l2, string, field, databaseFieldConfig, clazz);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (FieldType)object;
        return this.field.equals(((FieldType)object).field) && (this.parentClass == null ? ((FieldType)object).parentClass == null : this.parentClass.equals(((FieldType)object).parentClass));
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.field.getName() + ",class=" + this.field.getDeclaringClass().getSimpleName();
    }

    private boolean isFieldValueDefault(Object object) {
        if (object == null) {
            return true;
        }
        return object.equals(this.getJavaDefaultValueDefault());
    }

    private FieldType findForeignFieldType(Class<?> clazz, Class<?> clazz2, BaseDaoImpl<?, ?> object) {
        String string = this.fieldConfig.getForeignCollectionForeignFieldName();
        for (FieldType fieldType : ((BaseDaoImpl)object).getTableInfo().getFieldTypes()) {
            if (fieldType.getType() != clazz2 || string != null && !fieldType.getField().getName().equals(string)) continue;
            if (!fieldType.fieldConfig.isForeign() && !fieldType.fieldConfig.isForeignAutoRefresh()) {
                throw new SQLException("Foreign collection object " + clazz + " for field '" + this.field.getName() + "' contains a field of class " + clazz2 + " but it's not foreign");
            }
            return fieldType;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Foreign collection class ").append(clazz.getName());
        ((StringBuilder)object).append(" for field '").append(this.field.getName()).append("' column-name does not contain a foreign field");
        if (string != null) {
            ((StringBuilder)object).append(" named '").append(string).append('\'');
        }
        ((StringBuilder)object).append(" of class ").append(clazz2.getName());
        throw new SQLException(((StringBuilder)object).toString());
    }

    private void assignDataType(m object, p dataTypeArray) {
        this.dataPersister = dataTypeArray;
        if (dataTypeArray == null) {
            if (!this.fieldConfig.isForeign() && !this.fieldConfig.isForeignCollection()) {
                throw new SQLException("Data persister for field " + this + " is null but the field is not a foreign or foreignCollection");
            }
            return;
        }
        this.fieldConverter = object.getFieldConverter((p)dataTypeArray);
        if (this.isGeneratedId && !dataTypeArray.isValidGeneratedType()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Generated-id field '").append(this.field.getName());
            ((StringBuilder)object).append("' in ").append(this.field.getDeclaringClass().getSimpleName());
            ((StringBuilder)object).append(" can't be type ").append((Object)this.dataPersister.getSqlType());
            ((StringBuilder)object).append(".  Must be one of: ");
            for (DataType dataType : DataType.values()) {
                p p2 = dataType.getDataPersister();
                if (p2 == null || !p2.isValidGeneratedType()) continue;
                ((StringBuilder)object).append((Object)dataType).append(' ');
            }
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (this.fieldConfig.isThrowIfNull() && !dataTypeArray.isPrimitive()) {
            throw new SQLException("Field " + this.field.getName() + " must be a primitive if set with throwIfNull");
        }
        if (this.isId && !dataTypeArray.isAppropriateId()) {
            throw new SQLException("Field '" + this.field.getName() + "' is of data type " + dataTypeArray + " which cannot be the ID field");
        }
        this.dataTypeConfigObj = dataTypeArray.makeConfigObject(this);
        object = this.fieldConfig.getDefaultValue();
        if (object == null) {
            this.defaultValue = null;
            return;
        }
        if (this.isGeneratedId) {
            throw new SQLException("Field '" + this.field.getName() + "' cannot be a generatedId and have a default value '" + (String)object + "'");
        }
        this.defaultValue = this.fieldConverter.parseDefaultString(this, (String)object);
    }

    static {
        threadLevelCounters = new r();
    }
}

