/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.LocalLog$PatternLevel;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Log$Level;
import com.j256.ormlite.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class LocalLog
implements Log {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.ormlite.logger.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.ormlite.logger.file";
    public static final String LOCAL_LOG_PROPERTIES_FILE = "/ormliteLocalLog.properties";
    private static final Log$Level DEFAULT_LEVEL = Log$Level.DEBUG;
    private static final ThreadLocal<DateFormat> dateFormatThreadLocal = new u();
    private static PrintStream printStream;
    private static final List<LocalLog$PatternLevel> classLevels;
    private final String className;
    private final Log$Level level;

    public LocalLog(String string) {
        this.className = LoggerFactory.getSimpleClassName(string);
        Object object = null;
        if (classLevels != null) {
            for (Object object2 : classLevels) {
                if (!object2.pattern.matcher(string).matches() || object != null && object2.level.ordinal() >= ((Enum)object).ordinal()) continue;
                object = object2.level;
            }
        }
        if (object == null) {
            String string2 = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
            if (string2 == null) {
                object = DEFAULT_LEVEL;
            } else {
                Object object2;
                try {
                    object2 = Log$Level.valueOf(string2.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Level '" + (String)string2 + "' was not found", illegalArgumentException);
                }
                object = object2;
            }
        }
        this.level = object;
    }

    public static void openLogFile(String string) {
        if (string == null) {
            printStream = System.out;
            return;
        }
        try {
            printStream = new PrintStream(new File(string));
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Log file " + string + " was not found", fileNotFoundException);
        }
    }

    @Override
    public boolean isLevelEnabled(Log$Level log$Level) {
        return this.level.isEnabled(log$Level);
    }

    @Override
    public void log(Log$Level log$Level, String string) {
        this.printMessage(log$Level, string, null);
    }

    @Override
    public void log(Log$Level log$Level, String string, Throwable throwable) {
        this.printMessage(log$Level, string, throwable);
    }

    void flush() {
        printStream.flush();
    }

    /*
     * Loose catch block
     */
    static List<LocalLog$PatternLevel> readLevelResourceFile(InputStream inputStream) {
        List<LocalLog$PatternLevel> list;
        block11: {
            list = null;
            if (inputStream != null) {
                list = LocalLog.configureClassLevels(inputStream);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block11;
                catch (IOException iOException) {
                    try {
                        System.err.println("IO exception reading the log properties file '/ormliteLocalLog.properties': " + iOException);
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
        }
        return list;
    }

    private static List<LocalLog$PatternLevel> configureClassLevels(InputStream closeable) {
        Object object;
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
        ArrayList<LocalLog$PatternLevel> arrayList = new ArrayList<LocalLog$PatternLevel>();
        while ((object = ((BufferedReader)closeable).readLine()) != null) {
            Log$Level log$Level;
            if (((String)object).length() == 0 || ((String)object).charAt(0) == '#') continue;
            String[] stringArray = ((String)object).split("=");
            if (stringArray.length != 2) {
                System.err.println("Line is not in the format of 'pattern = level': " + (String)object);
                continue;
            }
            object = Pattern.compile(stringArray[0].trim());
            try {
                log$Level = Log$Level.valueOf(stringArray[1].trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Level '" + stringArray[1] + "' was not found");
                continue;
            }
            arrayList.add(new LocalLog$PatternLevel((Pattern)object, log$Level));
        }
        return arrayList;
    }

    private void printMessage(Log$Level log$Level, String string, Throwable throwable) {
        if (!this.isLevelEnabled(log$Level)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        DateFormat dateFormat = dateFormatThreadLocal.get();
        stringBuilder.append(dateFormat.format(new Date()));
        stringBuilder.append(" [").append(log$Level.name()).append("] ");
        stringBuilder.append(this.className).append(' ');
        stringBuilder.append(string);
        printStream.println(stringBuilder.toString());
        if (throwable != null) {
            throwable.printStackTrace(printStream);
        }
    }

    static {
        classLevels = LocalLog.readLevelResourceFile(LocalLog.class.getResourceAsStream(LOCAL_LOG_PROPERTIES_FILE));
        LocalLog.openLogFile(System.getProperty(LOCAL_LOG_FILE_PROPERTY));
    }
}

