/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ColumnArg;
import com.j256.ormlite.stmt.SelectArg;
import java.sql.SQLException;
import java.util.List;

public abstract class BaseComparison
implements G {
    private static final String NUMBER_CHARACTERS = "0123456789.-+";
    protected final String columnName;
    protected final FieldType fieldType;
    private final Object value;

    public BaseComparison(String string, FieldType fieldType, Object object, boolean bl2) {
        if (bl2 && fieldType != null && !fieldType.isComparable()) {
            throw new SQLException("Field '" + string + "' is of data type " + fieldType.getDataPersister() + " which can not be compared");
        }
        this.columnName = string;
        this.fieldType = fieldType;
        this.value = object;
    }

    @Override
    public abstract void appendOperation(StringBuilder var1);

    @Override
    public void appendSql(m m2, String string, StringBuilder stringBuilder, List<w> list) {
        if (string != null) {
            m2.appendEscapedEntityName(stringBuilder, string);
            stringBuilder.append('.');
        }
        m2.appendEscapedEntityName(stringBuilder, this.columnName);
        stringBuilder.append(' ');
        this.appendOperation(stringBuilder);
        this.appendValue(m2, stringBuilder, list);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void appendValue(m m2, StringBuilder stringBuilder, List<w> list) {
        this.appendArgOrValue(m2, this.fieldType, stringBuilder, list, this.value);
    }

    public void appendArgOrValue(m m2, FieldType object, StringBuilder stringBuilder, List<w> list, Object object2) {
        boolean bl2 = true;
        if (object2 == null) {
            throw new SQLException("argument for '" + ((FieldType)object).getFieldName() + "' is null");
        }
        if (object2 instanceof w) {
            stringBuilder.append('?');
            w w2 = (w)object2;
            w2.setMetaInfo(this.columnName, (FieldType)object);
            list.add(w2);
        } else if (object2 instanceof ColumnArg) {
            ColumnArg columnArg = (ColumnArg)object2;
            object = columnArg.getTableName();
            if (object != null) {
                m2.appendEscapedEntityName(stringBuilder, (String)object);
                stringBuilder.append('.');
            }
            m2.appendEscapedEntityName(stringBuilder, columnArg.getColumnName());
        } else if (((FieldType)object).isArgumentHolderRequired()) {
            stringBuilder.append('?');
            SelectArg selectArg = new SelectArg();
            selectArg.setMetaInfo(this.columnName, (FieldType)object);
            selectArg.setValue(object2);
            list.add(selectArg);
        } else if (((FieldType)object).isForeign() && ((FieldType)object).getType().isAssignableFrom(object2.getClass())) {
            FieldType fieldType = ((FieldType)object).getForeignIdField();
            this.appendArgOrValue(m2, fieldType, stringBuilder, list, fieldType.extractJavaFieldValue(object2));
            bl2 = false;
        } else if (((FieldType)object).isEscapedValue()) {
            m2.appendEscapedWord(stringBuilder, ((FieldType)object).convertJavaFieldToSqlArgValue(object2).toString());
        } else if (((FieldType)object).isForeign()) {
            String string = ((FieldType)object).convertJavaFieldToSqlArgValue(object2).toString();
            if (string.length() > 0 && NUMBER_CHARACTERS.indexOf(string.charAt(0)) < 0) {
                throw new SQLException("Foreign field " + object + " does not seem to be producing a numerical value '" + string + "'. Maybe you are passing the wrong object to comparison: " + this);
            }
            stringBuilder.append(string);
        } else {
            stringBuilder.append(((FieldType)object).convertJavaFieldToSqlArgValue(object2));
        }
        if (bl2) {
            stringBuilder.append(' ');
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.columnName).append(' ');
        this.appendOperation(stringBuilder);
        stringBuilder.append(' ');
        stringBuilder.append(this.value);
        return stringBuilder.toString();
    }
}

