/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.asteriskjava.fastagi.DefaultAgiServer;

public class Cli {
    private void parseOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            this.startAgiServer();
            return;
        }
        Object object = stringArray[0];
        if ("-h".equals(object) || "-help".equals(object)) {
            this.showHelp();
            return;
        }
        if ("-v".equals(object) || "-version".equals(object)) {
            this.showVersion();
            return;
        }
        if ("-a".equals(object) || "-agi".equals(object)) {
            if (stringArray.length >= 2) {
                object = null;
                try {
                    object = new Integer(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid port '" + stringArray[1] + "'. Port must be a number.");
                    this.exit(1);
                }
                this.startAgiServer((Integer)object);
                return;
            }
        } else {
            this.showHelp();
        }
    }

    private void showHelp() {
        this.showVersion();
        System.err.println();
        System.err.println("-a, -agi [port]\n\tStarts a FastAGI server");
        System.err.println("-h, -help\n\tDisplays the available options\n");
        System.err.println("-v, -version\n\tDisplays the version of Asterisk-Java\n");
    }

    private void showVersion() {
        System.out.println("Asterisk-Java " + this.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        String string = "<unknown>";
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/org.asteriskjava/asterisk-java/pom.properties");
        if (inputStream == null) {
            return string;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
                return string;
            }
            catch (IOException iOException2) {}
            return string;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return properties.getProperty("version", string);
        }
        catch (IOException iOException) {
            return properties.getProperty("version", string);
        }
    }

    private void startAgiServer() {
        this.startAgiServer(null);
    }

    private void startAgiServer(Integer n2) {
        DefaultAgiServer defaultAgiServer = new DefaultAgiServer();
        if (n2 != null) {
            defaultAgiServer.setPort(n2);
        }
        defaultAgiServer.startup();
    }

    private void exit(int n2) {
        System.exit(n2);
    }

    public static void main(String[] stringArray) {
        new Cli().parseOptions(stringArray);
    }
}

