/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.MeetMeUserState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.MeetMeRoomImpl;
import org.asteriskjava.manager.action.CommandAction;

class MeetMeUserImpl
extends AbstractLiveObject
implements MeetMeUser {
    private static final String COMMAND_PREFIX = "meetme";
    private static final String MUTE_COMMAND = "mute";
    private static final String UNMUTE_COMMAND = "unmute";
    private static final String KICK_COMMAND = "kick";
    private final MeetMeRoomImpl room;
    private final Integer userNumber;
    private final AsteriskChannelImpl channel;
    private final Date dateJoined;
    private Date dateLeft;
    private MeetMeUserState state;
    private boolean talking;
    private boolean muted;

    MeetMeUserImpl(AsteriskServerImpl asteriskServerImpl, MeetMeRoomImpl meetMeRoomImpl, Integer n2, AsteriskChannelImpl asteriskChannelImpl, Date date) {
        super(asteriskServerImpl);
        this.room = meetMeRoomImpl;
        this.userNumber = n2;
        this.channel = asteriskChannelImpl;
        this.dateJoined = date;
        this.state = MeetMeUserState.JOINED;
    }

    @Override
    public MeetMeRoomImpl getRoom() {
        return this.room;
    }

    @Override
    public Integer getUserNumber() {
        return this.userNumber;
    }

    @Override
    public AsteriskChannelImpl getChannel() {
        return this.channel;
    }

    @Override
    public Date getDateJoined() {
        return this.dateJoined;
    }

    @Override
    public Date getDateLeft() {
        return this.dateLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left(Date date) {
        MeetMeUserState meetMeUserState;
        MeetMeUserImpl meetMeUserImpl = this;
        synchronized (meetMeUserImpl) {
            meetMeUserState = this.state;
            this.dateLeft = date;
            this.state = MeetMeUserState.LEFT;
        }
        this.firePropertyChange("state", (Object)meetMeUserState, (Object)this.state);
    }

    @Override
    public MeetMeUserState getState() {
        return this.state;
    }

    @Override
    public boolean isTalking() {
        return this.talking;
    }

    void setTalking(boolean bl2) {
        boolean bl3 = this.talking;
        this.talking = bl2;
        this.firePropertyChange("talking", bl3, bl2);
    }

    @Override
    public boolean isMuted() {
        return this.muted;
    }

    void setMuted(boolean bl2) {
        boolean bl3 = this.muted;
        this.muted = bl2;
        this.firePropertyChange("muted", bl3, bl2);
    }

    @Override
    public void kick() {
        this.sendMeetMeUserCommand(KICK_COMMAND);
    }

    @Override
    public void mute() {
        this.sendMeetMeUserCommand(MUTE_COMMAND);
    }

    @Override
    public void unmute() {
        this.sendMeetMeUserCommand(UNMUTE_COMMAND);
    }

    private void sendMeetMeUserCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND_PREFIX);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.room.getRoomNumber());
        stringBuffer.append(" ");
        stringBuffer.append(this.userNumber);
        this.server.sendAction(new CommandAction(stringBuffer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("MeetMeUser[");
        AbstractLiveObject abstractLiveObject = this;
        synchronized (abstractLiveObject) {
            stringBuffer.append("dateJoined='").append(this.getDateJoined()).append("',");
            stringBuffer.append("dateLeft='").append(this.getDateLeft()).append("',");
            stringBuffer.append("talking=").append(this.isTalking()).append(",");
            stringBuffer.append("muted=").append(this.isMuted()).append(",");
            stringBuffer.append("room=").append(this.room).append(",");
            n2 = System.identityHashCode(this);
        }
        stringBuffer.append("channel=AsteriskChannel[");
        abstractLiveObject = this.channel;
        synchronized (abstractLiveObject) {
            stringBuffer.append("id='").append(this.channel.getId()).append("',");
            stringBuffer.append("name='").append(this.channel.getName()).append("'],");
        }
        stringBuffer.append("systemHashcode=").append(n2);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

