/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.persistence.svg.SvgParser;
import org.tigris.gef.util.Util;

public class CmdOpenSVG
extends Cmd
implements FilenameFilter {
    static final long serialVersionUID = 0L;

    public CmdOpenSVG() {
        super("OpenSVG");
        this.setArg("filterPattern", "*.svg");
    }

    @Override
    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void doIt() {
        Object object = Globals.curEditor();
        object = new FileDialog(((Editor)object).findFrame(), "Open...", 0);
        ((FileDialog)object).setFilenameFilter(this);
        ((FileDialog)object).setDirectory(Globals.getLastDirectory());
        ((Dialog)object).setVisible(true);
        Object object2 = ((FileDialog)object).getFile();
        object = ((FileDialog)object).getDirectory();
        Globals.setLastDirectory((String)object);
        if (object2 != null) {
            try {
                Globals.showStatus("Reading " + (String)object + (String)object2 + "...");
                Serializable serializable = Util.fileToURL(new File((String)object + (String)object2));
                serializable = SvgParser.SINGLETON.readDiagram((URL)serializable);
                serializable = new Editor((Diagram)serializable);
                Globals.showStatus("Read " + (String)object + (String)object2);
                object = new JGraphFrame((String)object + (String)object2, (Editor)serializable);
                object2 = this.getArg("dimension");
                if (object2 instanceof Dimension) {
                    ((Window)object).setSize((Dimension)object2);
                }
                ((JGraphFrame)object).setVisible(true);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("bad URL");
                return;
            }
            catch (IOException iOException) {
                System.out.println("IOExcept in opensvg");
            }
        }
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }
}

