/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;

public class FigImage
extends Fig
implements ImageObserver {
    private static final long serialVersionUID = 2567695485399374706L;
    protected transient Image _image;
    protected URL _url;
    private static Log LOG = LogFactory.getLog(FigImage.class);

    public FigImage(int n2, int n3, int n4, int n5, Image image) {
        super(n2, n3, n4, n5);
        this._image = image;
    }

    public FigImage(int n2, int n3, Image image) {
        this(n2, n3, 0, 0, image);
        this.setSize(image.getWidth(this), image.getHeight(this));
    }

    public FigImage(int n2, int n3, URL uRL) {
        super(n2, n3, 0, 0);
        this._url = uRL;
        this._image = Globals.getImage(this._url);
        Globals.waitForImages();
        this.setSize(this._image.getWidth(this), this._image.getHeight(this));
    }

    @Override
    public void createDrag(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setLocation(n6, n7);
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        return !((n2 & 0x70) != 0);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._image == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"reloading image");
            }
            if (this._url != null) {
                this._image = Globals.getImage(this._url);
                Globals.waitForImages();
            }
        }
        if (this._image != null) {
            graphics.drawImage(this._image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this);
            return;
        }
        graphics.setColor(this.getFillColor());
        graphics.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setURL(URL uRL) {
        this._url = uRL;
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<image id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("' style='fill:none;' x='").append(this.getX()).append("' y='").append(this.getY()).append("' width='").append(this.getWidth()).append("' height='").append(this.getHeight()).append("' xlink:href='").append(this.getURL()).append(" />");
    }
}

