/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.properties.PropCategoryManager;

public class FigRRect
extends FigRect {
    private static final long serialVersionUID = -4984437962118691063L;
    protected int _radius = 16;

    public FigRRect(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
    }

    public FigRRect(int n2, int n3, int n4, int n5, Color color, Color color2) {
        super(n2, n3, n4, n5, color, color2);
    }

    public int getCornerRadius() {
        return this._radius;
    }

    public void setCornerRadius(int n2) {
        this._radius = n2;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._filled && this._fillColor != null) {
            if (this._lineColor != null && this._lineWidth > 1) {
                this.drawFilledRRectWithWideLine(graphics);
                return;
            }
            this.drawFilledRRect(graphics);
            return;
        }
        if (this._lineColor != null && this._lineWidth > 1) {
            this.drawEmptyRRectWithWideLine(graphics);
            return;
        }
        this.drawEmptyRRect(graphics);
    }

    private void drawFilledRRect(Graphics graphics) {
        graphics.setColor(this._fillColor);
        graphics.fillRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        if (this._lineColor != null && this._lineWidth == 1) {
            graphics.setColor(this._lineColor);
            graphics.drawRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        }
    }

    private void drawFilledRRectWithWideLine(Graphics graphics) {
        int n2 = this._lineWidth << 1;
        graphics.setColor(this._lineColor);
        graphics.fillRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        graphics.setColor(this._fillColor);
        graphics.fillRoundRect(this._x + this._lineWidth, this._y + this._lineWidth, this._w - n2, this._h - n2, this._radius, this._radius);
    }

    private void drawEmptyRRect(Graphics graphics) {
        if (this._lineColor != null && this._lineWidth == 1) {
            graphics.setColor(this._lineColor);
            graphics.drawRoundRect(this._x, this._y, this._w, this._h, this._radius, this._radius);
        }
    }

    private void drawEmptyRRectWithWideLine(Graphics graphics) {
        if (this._lineColor != null && this._lineWidth > 1) {
            int n2 = this._x;
            int n3 = this._y;
            int n4 = this._w;
            int n5 = this._h;
            graphics.setColor(this._lineColor);
            for (int i2 = 0; i2 < this._lineWidth; ++i2) {
                graphics.drawRoundRect(n2++, n3++, n4, n5, this._radius, this._radius);
                n4 -= 2;
                n5 -= 2;
            }
        }
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "cornerRadius");
    }
}

