/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.Native;
import com4j.Task;
import com4j.Wrapper;
import java.util.Iterator;

public class ROT
implements Iterable<Com4jObject> {
    private static final ROT instance = new ROT();

    private ROT() {
    }

    static ROT getInstance() {
        return instance;
    }

    @Override
    public Iterator<Com4jObject> iterator() {
        return new ROTIterator();
    }

    private static class ROTIterator
    implements Iterator<Com4jObject> {
        long rotPointer = 0L;
        long enumMonikerPointer = 0L;
        Com4jObject nextObject = null;

        public ROTIterator() {
            new InitTask().execute();
            this.fetchObject();
        }

        public void finalize() {
            this.cleanUp();
        }

        private void cleanUp() {
            if (this.rotPointer != 0L) {
                Native.release(this.rotPointer);
                this.rotPointer = 0L;
            }
            if (this.enumMonikerPointer != 0L) {
                Native.release(this.enumMonikerPointer);
                this.enumMonikerPointer = 0L;
            }
        }

        private void fetchObject() {
            this.nextObject = (Com4jObject)new GetNextRunningObjectTask().execute();
        }

        @Override
        public boolean hasNext() {
            return this.nextObject != null;
        }

        @Override
        public Com4jObject next() {
            if (this.rotPointer != 0L && this.enumMonikerPointer != 0L && this.nextObject != null) {
                Com4jObject current = this.nextObject;
                this.fetchObject();
                return current;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("You cannot remove an arbitary object form the table");
        }

        private class GetNextRunningObjectTask
        extends Task<Com4jObject> {
            private GetNextRunningObjectTask() {
            }

            @Override
            public Com4jObject call() {
                long pointer = Native.getNextRunningObject(ROTIterator.this.rotPointer, ROTIterator.this.enumMonikerPointer);
                if (pointer == 0L) {
                    ROTIterator.this.cleanUp();
                    return null;
                }
                return Wrapper.create(pointer);
            }
        }

        private class InitTask
        extends Task<Boolean> {
            private InitTask() {
            }

            @Override
            public Boolean call() {
                ROTIterator.this.rotPointer = Native.getRunningObjectTable();
                ROTIterator.this.enumMonikerPointer = Native.getEnumMoniker(ROTIterator.this.rotPointer);
                return Boolean.TRUE;
            }
        }
    }
}

