/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.atreides.pda_utils.PdaErrorDialog;
import ro.atreides.pda_utils.PdaUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.PdaLogic3;
import ro.atreides.vp_pda.v4.PreorderPanel;
import ro.atreides.vp_pda.v4.Sale;
import ro.atreides.vp_pda.v4.Table3;
import ro.atreides.vp_pda.v4.TablesPanel;

public class OrderPanel {
    private PdaLogic3 logic;
    private Label totalLabel;
    private Label masaLabel;
    private Table3 table;
    private Shell parentShell;
    private Table salesTable;

    public OrderPanel(Shell parentShell, PdaLogic3 logic, Table3 table) {
        this.logic = logic;
        this.table = table;
        this.parentShell = parentShell;
        int close = Config3.closeMode ? 80 : 0;
        Shell preorderShell = new Shell(parentShell, close);
        this.salesTable = new Table((Composite)preorderShell, 2560);
        this.salesTable.setHeaderVisible(true);
        this.salesTable.setLinesVisible(true);
        int salesColumnCount = 3;
        TableColumn felC = new TableColumn(this.salesTable, 0);
        felC.setText("Fel");
        TableColumn produsC = new TableColumn(this.salesTable, 0);
        produsC.setText("________Produs_______");
        TableColumn cantC = new TableColumn(this.salesTable, 0);
        cantC.setText("_Cant_");
        for (int i = 0; i < 3; ++i) {
            this.salesTable.getColumn(i).pack();
        }
        this.salesTable.pack();
        this.buildMenu(preorderShell);
        this.masaLabel = new Label((Composite)preorderShell, 2048);
        this.masaLabel.setText("Masa");
        this.totalLabel = new Label((Composite)preorderShell, 2048);
        this.totalLabel.setText("Total");
        Font initialFont = this.totalLabel.getFont();
        FontData[] fontData = initialFont.getFontData();
        for (int k = 0; k < fontData.length; ++k) {
            fontData[k].setHeight(Config3.totalFontSize);
        }
        Font newFont = new Font((Device)parentShell.getDisplay(), fontData);
        this.totalLabel.setFont(newFont);
        if (table.getStatus() == 5) {
            this.totalLabel.setForeground(parentShell.getDisplay().getSystemColor(3));
        }
        this.masaLabel.setBounds(0, 0, 120, 30);
        this.totalLabel.setBounds(122, 0, 100, 30);
        this.salesTable.setBounds(0, 31, 240, 205);
        preorderShell.setSize(240, Config3.dY);
        preorderShell.open();
        this.refreshOrderPanel(this.salesTable);
    }

    private void refreshOrderPanel(Table salesTable) {
        this.masaLabel.setText(this.table.getLabel() + " " + this.logic.getLocatie().getLabel());
        this.logic.refreshSalesAtTable(this.table.getId());
        Vector sales = this.logic.getSalesAtTable(this.table.getId());
        float total = 0.0f;
        for (Sale i : sales) {
            total += i.getCantitateNoua() * i.getPret();
        }
        this.totalLabel.setText(" " + Utils.getString2Decimals((float)total));
        salesTable.removeAll();
        for (Sale s : sales) {
            TableItem item1 = new TableItem(salesTable, 0);
            item1.setText(0, "");
            String s1 = s.getNumeProdus();
            if (Validators.correctString((String)s.getPreparare())) {
                s1 = s1 + " (" + s.getPreparare() + ")";
            }
            item1.setText(1, s1);
            item1.setText(2, Utils.getString3Decimals((float)s.getCantitateNoua()));
            Color c = PdaUtils.getTableBgColor(s.getIdPlatou(), this.parentShell.getDisplay());
            item1.setBackground(c);
        }
    }

    private void buildMenu(final Shell preorderShell) {
        MenuItem nota;
        Menu menu = new Menu((Decorations)preorderShell, 2);
        preorderShell.setMenuBar(menu);
        MenuItem actiuni = new MenuItem(menu, 64);
        actiuni.setText("Actiuni");
        Menu actiuniMenu = new Menu(actiuni);
        actiuni.setMenu(actiuniMenu);
        MenuItem precomanda = new MenuItem(actiuniMenu, 8);
        precomanda.setText("Precomanda");
        precomanda.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                preorderShell.close();
                new PreorderPanel(OrderPanel.this.parentShell, OrderPanel.this.logic, OrderPanel.this.table);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        MenuItem mese = new MenuItem(actiuniMenu, 8);
        mese.setText("Mese");
        mese.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new TablesPanel(OrderPanel.this.parentShell, OrderPanel.this.logic);
                preorderShell.close();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        new MenuItem(actiuniMenu, 2);
        MenuItem mesaje = new MenuItem(actiuniMenu, 8);
        mesaje.setText(this.logic.getNotificationsString());
        mesaje.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OrderPanel.this.logic.notificationsAcknoledged();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        new MenuItem(actiuniMenu, 2);
        if (Config3.showNotaButton) {
            nota = new MenuItem(actiuniMenu, 8);
            nota.setText("Nota");
            nota.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean result = OrderPanel.this.logic.nota(OrderPanel.this.table);
                    if (!result) {
                        new PdaErrorDialog(preorderShell, "Eroare: " + result, "Nu pot continua");
                    } else {
                        new TablesPanel(OrderPanel.this.parentShell, OrderPanel.this.logic);
                        preorderShell.close();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    this.widgetSelected(selectionEvent);
                }
            });
        }
        if (Config3.showIncasatButton) {
            nota = new MenuItem(actiuniMenu, 8);
            nota.setText("Incasat");
            nota.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean result = OrderPanel.this.logic.incasat(OrderPanel.this.table);
                    if (!result) {
                        new PdaErrorDialog(preorderShell, "Eroare: " + result, "Nu pot continua");
                    } else {
                        new TablesPanel(OrderPanel.this.parentShell, OrderPanel.this.logic);
                        preorderShell.close();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    this.widgetSelected(selectionEvent);
                }
            });
        }
    }
}

