/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int[] a = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    public static AztecCode encode(byte[] object, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        BitArray bitArray;
        int n9;
        int n10;
        int n11;
        boolean bl2;
        BitArray bitArray2 = new HighLevelEncoder((byte[])object).encode();
        object = bitArray2;
        n2 = bitArray2.getSize() * n2 / 100 + 11;
        int n12 = ((BitArray)object).getSize() + n2;
        if (n3 != 0) {
            bl2 = n3 < 0;
            n11 = Math.abs(n3);
            if (n11 > (bl2 ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", n3));
            }
            n3 = Encoder.a(n11, bl2);
            n10 = a[n11];
            n9 = n3 - n3 % n10;
            bitArray = Encoder.a((BitArray)object, n10);
            if (bitArray.getSize() + n2 > n9) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (bl2 && bitArray.getSize() > n10 << 6) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            n10 = 0;
            bitArray = null;
            n9 = 0;
            while (true) {
                if (n9 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                bl2 = n9 <= 3;
                n11 = bl2 ? n9 + 1 : n9;
                n3 = Encoder.a(n11, bl2);
                if (n12 <= n3) {
                    if (n10 != a[n11]) {
                        n10 = a[n11];
                        bitArray = Encoder.a((BitArray)object, n10);
                    }
                    n8 = n3 - n3 % n10;
                    if ((!bl2 || bitArray.getSize() <= n10 << 6) && bitArray.getSize() + n2 <= n8) break;
                }
                ++n9;
            }
        }
        BitArray bitArray3 = Encoder.a(bitArray, n3, n10);
        n3 = n8 = bitArray.getSize() / n10;
        n2 = n11;
        boolean bl3 = bl2;
        BitArray bitArray4 = new BitArray();
        if (bl3) {
            bitArray4.appendBits(n2 - 1, 2);
            bitArray4.appendBits(n3 - 1, 6);
            bitArray4 = Encoder.a(bitArray4, 28, 4);
        } else {
            bitArray4.appendBits(n2 - 1, 5);
            bitArray4.appendBits(n3 - 1, 11);
            bitArray4 = Encoder.a(bitArray4, 40, 4);
        }
        BitArray bitArray5 = bitArray4;
        n2 = (bl2 ? 11 : 14) + (n11 << 2);
        int[] nArray = new int[n2];
        if (bl2) {
            n7 = n2;
            for (n10 = 0; n10 < nArray.length; ++n10) {
                nArray[n10] = n10;
            }
        } else {
            n7 = n2 + 1 + 2 * ((n2 / 2 - 1) / 15);
            n10 = n2 / 2;
            int n13 = n7 / 2;
            for (n6 = 0; n6 < n10; ++n6) {
                n5 = n6 + n6 / 15;
                nArray[n10 - n6 - 1] = n13 - n5 - 1;
                nArray[n10 + n6] = n13 + n5 + 1;
            }
        }
        BitMatrix bitMatrix = new BitMatrix(n7);
        n6 = 0;
        for (n4 = 0; n4 < n11; ++n4) {
            n5 = (n11 - n4 << 2) + (bl2 ? 9 : 12);
            for (int i2 = 0; i2 < n5; ++i2) {
                int n14 = i2 << 1;
                for (int i3 = 0; i3 < 2; ++i3) {
                    if (bitArray3.get(n6 + n14 + i3)) {
                        bitMatrix.set(nArray[(n4 << 1) + i3], nArray[(n4 << 1) + i2]);
                    }
                    if (bitArray3.get(n6 + (n5 << 1) + n14 + i3)) {
                        bitMatrix.set(nArray[(n4 << 1) + i2], nArray[n2 - 1 - (n4 << 1) - i3]);
                    }
                    if (bitArray3.get(n6 + (n5 << 2) + n14 + i3)) {
                        bitMatrix.set(nArray[n2 - 1 - (n4 << 1) - i3], nArray[n2 - 1 - (n4 << 1) - i2]);
                    }
                    if (!bitArray3.get(n6 + n5 * 6 + n14 + i3)) continue;
                    bitMatrix.set(nArray[n2 - 1 - (n4 << 1) - i2], nArray[(n4 << 1) + i3]);
                }
            }
            n6 += n5 << 3;
        }
        Encoder.a(bitMatrix, bl2, n7, bitArray5);
        if (bl2) {
            Encoder.a(bitMatrix, n7 / 2, 5);
        } else {
            Encoder.a(bitMatrix, n7 / 2, 7);
            n4 = 0;
            n6 = 0;
            while (n4 < n2 / 2 - 1) {
                for (n5 = n7 / 2 & 1; n5 < n7; n5 += 2) {
                    bitMatrix.set(n7 / 2 - n6, n5);
                    bitMatrix.set(n7 / 2 + n6, n5);
                    bitMatrix.set(n5, n7 / 2 - n6);
                    bitMatrix.set(n5, n7 / 2 + n6);
                }
                n4 += 15;
                n6 += 16;
            }
        }
        AztecCode aztecCode = new AztecCode();
        aztecCode.setCompact(bl2);
        aztecCode.setSize(n7);
        aztecCode.setLayers(n11);
        aztecCode.setCodeWords(n8);
        aztecCode.setMatrix(bitMatrix);
        return aztecCode;
    }

    private static void a(BitMatrix bitMatrix, int n2, int n3) {
        for (int i2 = 0; i2 < n3; i2 += 2) {
            for (int i3 = n2 - i2; i3 <= n2 + i2; ++i3) {
                bitMatrix.set(i3, n2 - i2);
                bitMatrix.set(i3, n2 + i2);
                bitMatrix.set(n2 - i2, i3);
                bitMatrix.set(n2 + i2, i3);
            }
        }
        bitMatrix.set(n2 - n3, n2 - n3);
        bitMatrix.set(n2 - n3 + 1, n2 - n3);
        bitMatrix.set(n2 - n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 - n3);
        bitMatrix.set(n2 + n3, n2 - n3 + 1);
        bitMatrix.set(n2 + n3, n2 + n3 - 1);
    }

    private static void a(BitMatrix bitMatrix, boolean n2, int n3, BitArray bitArray) {
        n3 /= 2;
        if (n2 != 0) {
            for (n2 = 0; n2 < 7; ++n2) {
                int n4 = n3 - 3 + n2;
                if (bitArray.get(n2)) {
                    bitMatrix.set(n4, n3 - 5);
                }
                if (bitArray.get(n2 + 7)) {
                    bitMatrix.set(n3 + 5, n4);
                }
                if (bitArray.get(20 - n2)) {
                    bitMatrix.set(n4, n3 + 5);
                }
                if (!bitArray.get(27 - n2)) continue;
                bitMatrix.set(n3 - 5, n4);
            }
            return;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            int n5 = n3 - 5 + n2 + n2 / 5;
            if (bitArray.get(n2)) {
                bitMatrix.set(n5, n3 - 7);
            }
            if (bitArray.get(n2 + 10)) {
                bitMatrix.set(n3 + 7, n5);
            }
            if (bitArray.get(29 - n2)) {
                bitMatrix.set(n5, n3 + 7);
            }
            if (!bitArray.get(39 - n2)) continue;
            bitMatrix.set(n3 - 7, n5);
        }
    }

    private static BitArray a(BitArray object, int n2, int n3) {
        GenericGF genericGF;
        int n4 = ((BitArray)object).getSize() / n3;
        int n5 = n3;
        switch (n5) {
            case 4: {
                genericGF = GenericGF.AZTEC_PARAM;
                break;
            }
            case 6: {
                genericGF = GenericGF.AZTEC_DATA_6;
                break;
            }
            case 8: {
                genericGF = GenericGF.AZTEC_DATA_8;
                break;
            }
            case 10: {
                genericGF = GenericGF.AZTEC_DATA_10;
                break;
            }
            case 12: {
                genericGF = GenericGF.AZTEC_DATA_12;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported word size " + n5);
            }
        }
        ReedSolomonEncoder reedSolomonEncoder = new ReedSolomonEncoder(genericGF);
        Object object2 = n2 / n3;
        object = Encoder.a((BitArray)object, n3, object2);
        reedSolomonEncoder.encode((int[])object, object2 - n4);
        BitArray bitArray = new BitArray();
        bitArray.appendBits(0, n2 %= n3);
        n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = object[i2];
            bitArray.appendBits((int)object2, n3);
        }
        return bitArray;
    }

    private static int[] a(BitArray bitArray, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = bitArray.getSize() / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                n5 |= bitArray.get(i2 * n2 + i3) ? 1 << n2 - i3 - 1 : 0;
            }
            nArray[i2] = n5;
        }
        return nArray;
    }

    private static BitArray a(BitArray bitArray, int n2) {
        BitArray bitArray2 = new BitArray();
        int n3 = bitArray.getSize();
        int n4 = (1 << n2) - 2;
        for (int i2 = 0; i2 < n3; i2 += n2) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i2 + i3 < n3 && !bitArray.get(i2 + i3)) continue;
                n5 |= 1 << n2 - 1 - i3;
            }
            if ((n5 & n4) == n4) {
                bitArray2.appendBits(n5 & n4, n2);
                --i2;
                continue;
            }
            if ((n5 & n4) == 0) {
                bitArray2.appendBits(n5 | 1, n2);
                --i2;
                continue;
            }
            bitArray2.appendBits(n5, n2);
        }
        return bitArray2;
    }

    private static int a(int n2, boolean bl2) {
        return ((bl2 ? 88 : 112) + (n2 << 4)) * n2;
    }
}

