/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private final UPCEANReader[] a;

    public MultiFormatUPCEANReader(Map<DecodeHintType, ?> map) {
        map = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> arrayList = new ArrayList<UPCEANReader>();
        if (map != null) {
            if (map.contains((Object)BarcodeFormat.EAN_13)) {
                arrayList.add(new EAN13Reader());
            } else if (map.contains((Object)BarcodeFormat.UPC_A)) {
                arrayList.add(new UPCAReader());
            }
            if (map.contains((Object)BarcodeFormat.EAN_8)) {
                arrayList.add(new EAN8Reader());
            }
            if (map.contains((Object)BarcodeFormat.UPC_E)) {
                arrayList.add(new UPCEReader());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new EAN13Reader());
            arrayList.add(new EAN8Reader());
            arrayList.add(new UPCEReader());
        }
        this.a = arrayList.toArray(new UPCEANReader[arrayList.size()]);
    }

    @Override
    public final Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) {
        int[] nArray = UPCEANReader.a(bitArray);
        UPCEANReader[] uPCEANReaderArray = this.a;
        int n3 = this.a.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl2;
            Object object = uPCEANReaderArray[i2];
            try {
                object = ((UPCEANReader)object).decodeRow(n2, bitArray, nArray, map);
            }
            catch (ReaderException readerException) {
                continue;
            }
            n2 = ((Result)object).getBarcodeFormat() == BarcodeFormat.EAN_13 && ((Result)object).getText().charAt(0) == '0' ? 1 : 0;
            bitArray = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
            boolean bl3 = bl2 = bitArray == null || bitArray.contains((Object)BarcodeFormat.UPC_A);
            if (n2 != 0 && bl2) {
                Result result = new Result(((Result)object).getText().substring(1), ((Result)object).getRawBytes(), ((Result)object).getResultPoints(), BarcodeFormat.UPC_A);
                result.putAllMetadata(((Result)object).getResultMetadata());
                return result;
            }
            return object;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public final void reset() {
        UPCEANReader[] uPCEANReaderArray = this.a;
        int n2 = this.a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            uPCEANReaderArray[i2].reset();
        }
    }
}

