/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import java.util.Map;

public abstract class OneDimensionalCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n2 + 'x' + n3);
        }
        int n4 = this.getDefaultMargin();
        if (map != null && map.containsKey((Object)EncodeHintType.MARGIN)) {
            n4 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
        }
        return OneDimensionalCodeWriter.a(this.encode(string), n2, n3, n4);
    }

    private static BitMatrix a(boolean[] blArray, int n2, int n3, int n4) {
        int n5 = blArray.length;
        n4 = n5 + n4;
        n2 = Math.max(n2, n4);
        n3 = Math.max(1, n3);
        n4 = n2 / n4;
        int n6 = (n2 - n5 * n4) / 2;
        BitMatrix bitMatrix = new BitMatrix(n2, n3);
        int n7 = 0;
        while (n7 < n5) {
            if (blArray[n7]) {
                bitMatrix.setRegion(n6, 0, n4, n3);
            }
            ++n7;
            n6 += n4;
        }
        return bitMatrix;
    }

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl2) {
        int n3 = 0;
        for (int n4 : nArray) {
            for (int i2 = 0; i2 < n4; ++i2) {
                blArray[n2++] = bl2;
            }
            n3 += n4;
            bl2 = !bl2;
        }
        return n3;
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

