/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;

public class SerializableType
extends BaseDataType {
    private static final SerializableType singleTon = new SerializableType();

    public static SerializableType getSingleton() {
        return singleTon;
    }

    private SerializableType() {
        super(SqlType.SERIALIZABLE, new Class[0]);
    }

    protected SerializableType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        throw new SQLException("Default values for serializable types are not supported");
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, k k2, int n2) {
        return k2.a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object sqlArgToJava(FieldType object, Object object2, int n2) {
        Object object3;
        object = (byte[])object2;
        object2 = null;
        try {
            object2 = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
            object3 = ((ObjectInputStream)object2).readObject();
        }
        catch (Exception exception) {
            try {
                throw LoggerFactory$1.create("Could not read serialized object from byte array: " + Arrays.toString((byte[])object) + "(len " + ((Object)object).length + ")", exception);
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((ObjectInputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((ObjectInputStream)object2).close();
            return object3;
        }
        catch (IOException iOException) {}
        return object3;
    }

    @Override
    public Object javaToSqlArg(FieldType object, Object object2) {
        object = null;
        try {
            Object object3 = new ByteArrayOutputStream();
            object = new ObjectOutputStream((OutputStream)object3);
            ((ObjectOutputStream)object).writeObject(object2);
            ((ObjectOutputStream)object).close();
            object = null;
            object3 = ((ByteArrayOutputStream)object3).toByteArray();
            return object3;
        }
        catch (Exception exception) {
            try {
                throw LoggerFactory$1.create("Could not write serialized object to byte array: " + object2, exception);
            }
            catch (Throwable throwable) {
                if (object != null) {
                    try {
                        ((ObjectOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean isValidForField(Field field) {
        return Serializable.class.isAssignableFrom(field.getType());
    }

    @Override
    public boolean isStreamType() {
        return true;
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return true;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String string, int n2) {
        throw new SQLException("Serializable type cannot be converted from string to Java");
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Serializable.class;
    }
}

