/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard;

import de.t68.utils.keyboard.KeyboardKey;
import de.t68.utils.keyboard.KeyboardModifier;
import de.t68.utils.keyboard.SpecialKey$SelectKeyboardLayout;
import de.t68.utils.keyboard.VKeyboard;
import de.t68.utils.keyboard.button.KeyboardButton;
import de.t68.utils.keyboard.button.ToggleKeyboardButton;
import de.t68.utils.keyboard.event.VirtualKeyListener;
import de.t68.utils.keyboard.icons.Backspace;
import de.t68.utils.keyboard.icons.Capslock;
import de.t68.utils.keyboard.icons.Enter;
import de.t68.utils.keyboard.icons.Left;
import de.t68.utils.keyboard.icons.Right;
import de.t68.utils.keyboard.icons.Shift;
import de.t68.utils.keyboard.icons.Tab;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jdom2.Element;

public class SpecialKey
extends KeyboardKey {
    public static final String DELETE = "delete";
    public static final String SPACE = "space";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String ENTER = "enter";
    public static final String IME = "ime";
    public static final String SHIFT = "shift";
    public static final String ALTGR = "altgr";
    public static final String ALT = "alt";
    public static final String CAPSLOCK = "capslock";
    public static final String TAB = "tab";
    public static final String Attr_Special = "special";
    String a;
    private final String key;
    public static final String BACKSPACE = "backspace";

    public String getKey() {
        return this.key;
    }

    public SpecialKey(String string, String string2, String string3, int n2) {
        super(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter key is null!");
        }
        this.key = string2;
        this.a = string3;
        this.keyWidth = n2;
    }

    @Override
    public AbstractButton getComponent(VirtualKeyListener object, VKeyboard jComponent) {
        switch (this.key.toLowerCase()) {
            case "capslock": {
                Object object2 = new ToggleKeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)object2).setIcon(new Capslock(32, 32));
                ((ToggleKeyboardButton)object2).addVirtualKeyListener((VirtualKeyListener)object);
                object = object2;
                break;
            }
            case "alt": {
                Object object2 = new ToggleKeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)object2).setText(this.a);
                ((ToggleKeyboardButton)object2).addVirtualKeyListener((VirtualKeyListener)object);
                object = object2;
                if (((VKeyboard)jComponent).getAltModel() == null) {
                    ((VKeyboard)jComponent).setAltModel(((AbstractButton)object).getModel());
                    break;
                }
                ((AbstractButton)object).setModel(((VKeyboard)jComponent).getAltModel());
                break;
            }
            case "altgr": {
                Object object2 = new ToggleKeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)object2).setText(this.a);
                ((ToggleKeyboardButton)object2).addVirtualKeyListener((VirtualKeyListener)object);
                object = object2;
                if (((VKeyboard)jComponent).getAltgrModel() == null) {
                    ((VKeyboard)jComponent).setAltgrModel(((AbstractButton)object).getModel());
                    break;
                }
                ((AbstractButton)object).setModel(((VKeyboard)jComponent).getAltgrModel());
                break;
            }
            case "shift": {
                Object object2 = new ToggleKeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)object2).setIcon(new Shift(32, 32));
                ((ToggleKeyboardButton)object2).addVirtualKeyListener((VirtualKeyListener)object);
                object = object2;
                if (((VKeyboard)jComponent).getShiftModel() == null) {
                    ((VKeyboard)jComponent).setShiftModel(((AbstractButton)object).getModel());
                    break;
                }
                ((AbstractButton)object).setModel(((VKeyboard)jComponent).getShiftModel());
                break;
            }
            case "ime": {
                object = new JToggleButton();
                ((AbstractButton)object).setText(this.a);
                ((JComponent)object).setFont(new Font(this.fontName, 0, this.keyFontSize));
                ((AbstractButton)object).addItemListener(new SpecialKey$SelectKeyboardLayout(this, (VKeyboard)jComponent));
                break;
            }
            case "backspace": {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setIcon(new Backspace(32, 32));
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
                break;
            }
            case "enter": {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setIcon(new Enter(32, 32));
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
                break;
            }
            case "left": {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setIcon(new Left(32, 32));
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
                break;
            }
            case "right": {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setIcon(new Right(32, 32));
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
                break;
            }
            case "tab": {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setIcon(new Tab(32, 32));
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
                break;
            }
            default: {
                jComponent = new KeyboardButton(this.fontName, this.keyFontSize, this.getKeyCode(), this.getKeyChar());
                ((AbstractButton)jComponent).setText(this.a);
                ((KeyboardButton)jComponent).addVirtualKeyListener((VirtualKeyListener)object);
                object = jComponent;
            }
        }
        return object;
    }

    @Override
    public void doAction(JTextComponent jTextComponent, VKeyboard object, int n2) {
        int n3 = jTextComponent.getCaretPosition();
        switch (this.key.toLowerCase()) {
            case "capslock": {
                if (n2 == 401) {
                    ((VKeyboard)object).setCapsLock(!((VKeyboard)object).isCapsLock());
                    return;
                }
                ((VKeyboard)object).setCapsLock(false);
                return;
            }
            case "backspace": {
                try {
                    if (n3 > 0) {
                        jTextComponent.getDocument().remove(n3 - 1, 1);
                    }
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
            }
            case "alt": {
                if (n2 == 401) {
                    ((VKeyboard)object).setModifier(KeyboardModifier.alt);
                    return;
                }
                ((VKeyboard)object).setModifier(KeyboardModifier.normal);
                return;
            }
            case "altgr": {
                if (n2 == 401) {
                    ((VKeyboard)object).setModifier(KeyboardModifier.altshift);
                    return;
                }
                ((VKeyboard)object).setModifier(KeyboardModifier.normal);
                return;
            }
            case "shift": {
                if (n2 == 401) {
                    ((VKeyboard)object).setModifier(KeyboardModifier.shift);
                    return;
                }
                ((VKeyboard)object).setModifier(KeyboardModifier.normal);
                return;
            }
            case "space": {
                this.insertString(jTextComponent, (VKeyboard)object, " ");
                return;
            }
            case "left": {
                if (n3 <= 0) break;
                jTextComponent.setCaretPosition(n3 - 1);
                return;
            }
            case "right": {
                if (n3 >= jTextComponent.getText().length()) break;
                jTextComponent.setCaretPosition(n3 + 1);
                return;
            }
            case "delete": {
                try {
                    if (n3 >= 0 && n3 < jTextComponent.getText().length()) {
                        jTextComponent.getDocument().remove(n3, 1);
                    }
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
            }
            default: {
                try {
                    object = new String(new char[]{this.getKeyChar()});
                    if (!VKeyboard.focusNextComponentAtEnter && ((String)object).equalsIgnoreCase("\n")) {
                        object = new KeyEvent(jTextComponent, 402, System.currentTimeMillis(), 0, 10, '\n');
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(jTextComponent, (AWTEvent)object);
                        return;
                    }
                    jTextComponent.getDocument().insertString(n3, (String)object, null);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    @Override
    public Element getAsElement() {
        Element element = new Element("Key");
        element.setAttribute(Attr_Special, this.key.toString());
        element.setAttribute("length", String.valueOf(this.keyWidth));
        return element;
    }

    @Override
    public void setKeyboardModifier(KeyboardModifier keyboardModifier) {
    }

    public char getKeyChar() {
        switch (this.key.toLowerCase()) {
            case "backspace": {
                return '\b';
            }
            case "enter": {
                return '\n';
            }
            case "space": {
                return ' ';
            }
            case "tab": {
                return '\t';
            }
        }
        return '\uffff';
    }

    public int getKeyCode() {
        switch (this.key.toLowerCase()) {
            case "capslock": {
                return 20;
            }
            case "backspace": {
                return 8;
            }
            case "alt": {
                return 18;
            }
            case "enter": {
                return 10;
            }
            case "altgr": {
                return 65406;
            }
            case "shift": {
                return 16;
            }
            case "ime": {
                return 0;
            }
            case "space": {
                return 32;
            }
            case "left": {
                return 37;
            }
            case "right": {
                return 39;
            }
            case "delete": {
                return 127;
            }
            case "tab": {
                return 9;
            }
        }
        return 0;
    }

    public String getStringKey() {
        switch (this.key.toLowerCase()) {
            case "capslock": {
                return KeyEvent.getKeyText(20);
            }
            case "backspace": {
                return KeyEvent.getKeyText(8);
            }
            case "alt": {
                return KeyEvent.getKeyText(18);
            }
            case "enter": {
                return KeyEvent.getKeyText(10);
            }
            case "shift": {
                return KeyEvent.getKeyText(16);
            }
            case "ime": {
                return "IME";
            }
            case "space": {
                return KeyEvent.getKeyText(32);
            }
            case "left": {
                return KeyEvent.getKeyText(37);
            }
            case "right": {
                return KeyEvent.getKeyText(39);
            }
            case "delete": {
                return KeyEvent.getKeyText(127);
            }
            case "tab": {
                return KeyEvent.getKeyText(9);
            }
        }
        return this.key;
    }

    public static KeyboardKey getKeyboardKey(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter key is null!");
        }
        switch (string2.toLowerCase()) {
            case "capslock": {
                return new SpecialKey(string, string2, "Caps Lock", 2);
            }
            case "backspace": {
                return new SpecialKey(string, string2, "Back Space", 2);
            }
            case "alt": {
                return new SpecialKey(string, string2, "Alt", 2);
            }
            case "enter": {
                return new SpecialKey(string, string2, "Enter", 2);
            }
            case "altgr": {
                return new SpecialKey(string, string2, "Alt Gr", 2);
            }
            case "shift": {
                return new SpecialKey(string, string2, "Shift", 2);
            }
            case "ime": {
                return new SpecialKey(string, string2, "IME", 2);
            }
            case "tab": {
                return new SpecialKey(string, string2, "Tab", 2);
            }
            case "space": {
                return new SpecialKey(string, string2, " ", 8);
            }
            case "left": {
                return new SpecialKey(string, string2, "&#x2190;", 1);
            }
            case "right": {
                return new SpecialKey(string, string2, "&#x2192;", 1);
            }
            case "delete": {
                return new SpecialKey(string, string2, KeyEvent.getKeyText(127), 1);
            }
        }
        return new SpecialKey(string, string2, string2, 1);
    }
}

