/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.IOException;
import java.net.InetAddress;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.AgiServer;
import org.asteriskjava.fastagi.ClassNameMappingStrategy;
import org.asteriskjava.fastagi.CompositeMappingStrategy;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.ResourceBundleMappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.AgiChannelFactory;
import org.asteriskjava.fastagi.internal.AgiConnectionHandler;
import org.asteriskjava.fastagi.internal.DefaultAgiChannelFactory;
import org.asteriskjava.fastagi.internal.FastAgiConnectionHandler;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;
import org.asteriskjava.util.ServerSocketFacade;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.ServerSocketFacadeImpl;

public class DefaultAgiServer
extends AbstractAgiServer
implements AgiServer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private static final int BACKLOG = 200;
    private ServerSocketFacade serverSocket;
    private String configResourceBundleName = "fastagi";
    private int port = 4573;
    private InetAddress address = null;

    public DefaultAgiServer() {
        this(null, null);
    }

    public DefaultAgiServer(AgiChannelFactory agiChannelFactory) {
        this(null, null, agiChannelFactory);
    }

    public DefaultAgiServer(String string) {
        this(string, null);
    }

    public DefaultAgiServer(MappingStrategy mappingStrategy) {
        this(null, mappingStrategy);
    }

    public DefaultAgiServer(AgiScript agiScript) {
        this(null, new StaticMappingStrategy(agiScript));
    }

    public DefaultAgiServer(String string, MappingStrategy mappingStrategy) {
        this(string, mappingStrategy, new DefaultAgiChannelFactory());
    }

    public DefaultAgiServer(String string, MappingStrategy mappingStrategy, AgiChannelFactory object) {
        super((AgiChannelFactory)object);
        if (mappingStrategy == null) {
            mappingStrategy = new CompositeMappingStrategy();
            ((CompositeMappingStrategy)mappingStrategy).addStrategy(new ResourceBundleMappingStrategy());
            ((CompositeMappingStrategy)mappingStrategy).addStrategy(new ClassNameMappingStrategy());
            if (ReflectionUtil.isClassAvailable("javax.script.ScriptEngineManager")) {
                object = (MappingStrategy)ReflectionUtil.newInstance("org.asteriskjava.fastagi.ScriptEngineMappingStrategy");
                if (object != null) {
                    ((CompositeMappingStrategy)mappingStrategy).addStrategy((MappingStrategy)object);
                }
            } else {
                this.logger.warn("ScriptEngine support disabled: It is only availble when running at least Java 6");
            }
            this.setMappingStrategy(mappingStrategy);
        } else {
            this.setMappingStrategy(mappingStrategy);
        }
        if (string != null) {
            this.configResourceBundleName = string;
        }
        this.loadConfig();
    }

    @Deprecated
    public void setBindPort(int n2) {
        this.port = n2;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(this.configResourceBundleName);
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
        try {
            String string;
            try {
                string = resourceBundle.getString("port");
            }
            catch (MissingResourceException missingResourceException) {
                string = resourceBundle.getString("bindPort");
            }
            this.port = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        try {
            this.setPoolSize(Integer.parseInt(resourceBundle.getString("poolSize")));
        }
        catch (Exception exception) {}
        try {
            this.setMaximumPoolSize(Integer.parseInt(resourceBundle.getString("maximumPoolSize")));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected ServerSocketFacade createServerSocket() {
        return new ServerSocketFacadeImpl(this.port, 200, this.address);
    }

    @Override
    public void startup() {
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException iOException) {
            this.logger.error("Unable start AgiServer: cannot to bind to *:" + this.port + ".", iOException);
            throw iOException;
        }
        this.logger.info("Listening on *:" + this.port + ".");
        while (true) {
            Object object;
            try {
                object = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                if (this.isDie()) break;
                this.handleException("IOException while waiting for connections.", iOException);
                continue;
            }
            this.logger.debug("Received connection from " + object.getRemoteAddress());
            object = new FastAgiConnectionHandler(this.getMappingStrategy(), (SocketConnectionFacade)object, this.getAgiChannelFactory());
            try {
                this.execute((Runnable)object);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.logger.warn("Execution was rejected by pool. Try to increase the pool size.");
                ((AgiConnectionHandler)object).release();
            }
        }
        this.logger.info("AgiServer shut down.");
    }

    @Deprecated
    public void run() {
        try {
            this.startup();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                return;
            }
            catch (IOException iOException) {
                this.logger.warn("IOException while closing server socket.", iOException);
            }
        }
    }

    @Override
    protected void finalize() {
        super.finalize();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Deprecated
    public static void main(String[] stringArray) {
        new DefaultAgiServer().startup();
    }
}

