/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AstUtil {
    private static final Set<String> TRUE_LITERALS = new HashSet<String>(20);
    private static final Set<String> NULL_LITERALS;

    private AstUtil() {
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        object = object instanceof String ? (String)object : object.toString();
        return TRUE_LITERALS.contains(((String)object).toLowerCase(Locale.US));
    }

    public static String[] parseCallerId(String string) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        int n2 = string.lastIndexOf(60);
        int n3 = string.lastIndexOf(62);
        if (n2 < 0 || n3 < 0) {
            if ((string = string.trim()).length() == 0) {
                string = null;
            }
            stringArray[0] = string;
            return stringArray;
        }
        String string2 = string.substring(n2 + 1, n3).trim();
        if (string2.length() == 0) {
            string2 = null;
        }
        if ((string = string.substring(0, n2).trim()).startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            string = string.substring(1, string.length() - 1).trim();
        }
        if (string.length() == 0) {
            string = null;
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        return stringArray;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof String)) {
            return false;
        }
        return NULL_LITERALS.contains(((String)object).toLowerCase(Locale.US));
    }

    static {
        TRUE_LITERALS.add("yes");
        TRUE_LITERALS.add("true");
        TRUE_LITERALS.add("y");
        TRUE_LITERALS.add("t");
        TRUE_LITERALS.add("1");
        TRUE_LITERALS.add("on");
        TRUE_LITERALS.add("enabled");
        NULL_LITERALS = new HashSet<String>(20);
        NULL_LITERALS.add("<unknown>");
        NULL_LITERALS.add("unknown");
        NULL_LITERALS.add("none");
        NULL_LITERALS.add("<none>");
        NULL_LITERALS.add("-none-");
        NULL_LITERALS.add("(none)");
        NULL_LITERALS.add("<not set>");
        NULL_LITERALS.add("(not set)");
        NULL_LITERALS.add("<no name>");
        NULL_LITERALS.add("n/a");
        NULL_LITERALS.add("<null>");
        NULL_LITERALS.add("(null)");
    }
}

