/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Map<String, Method> getGetters(Class<?> methodArray) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method method : methodArray.getMethods()) {
            String string = null;
            String string2 = method.getName();
            if (string2.startsWith("get")) {
                string = string2.substring(3);
            } else if (string2.startsWith("is")) {
                string = string2.substring(2);
            }
            if (string == null || string.length() == 0 || method.getParameterTypes().length != 0) continue;
            hashMap.put(string.toLowerCase(Locale.ENGLISH), method);
        }
        return hashMap;
    }

    public static Map<String, Method> getSetters(Class<?> methodArray) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method method : methodArray.getMethods()) {
            String string = method.getName();
            if (!string.startsWith("set") || method.getParameterTypes().length != 1) continue;
            string = string.substring(3).toLowerCase(Locale.US);
            hashMap.put(string, method);
        }
        return hashMap;
    }

    public static String stripIllegalCharacters(String string) {
        char c2;
        int n2;
        boolean bl2 = false;
        if (string == null) {
            return null;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            c2 = string.charAt(n2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n2 = 0; n2 < string.length(); ++n2) {
            c2 = string.charAt(n2);
            if (c2 >= '0' && c2 <= '9') {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 < 'a' || c2 > 'z') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static boolean isClassAvailable(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Object newInstance(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }
}

