/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdAlign
extends Cmd {
    private static final long serialVersionUID = -9169626281664389794L;
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    protected int direction;

    public CmdAlign(int n2) {
        super("Align" + CmdAlign.wordFor(n2));
        this.direction = n2;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Lefts";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "HorizontalCenters";
            }
            case 6: {
                return "VerticalCenters";
            }
            case 7: {
                return "ToGrid";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        int n2;
        int n3;
        Editor editor = Globals.curEditor();
        Vector<Fig> vector = (Vector<Fig>)this.getArg("figs");
        if (vector == null) {
            SelectionManager selectionManager = editor.getSelectionManager();
            if (selectionManager.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            vector = selectionManager.getFigs();
        }
        if ((n3 = vector.size()) == 0) {
            return;
        }
        Rectangle rectangle = ((Fig)vector.elementAt(0)).getBounds();
        for (n2 = 1; n2 < n3; ++n2) {
            rectangle.add(vector.elementAt(n2).getBounds());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Fig fig = vector.elementAt(n2);
            fig.align(rectangle, this.direction, editor);
            fig.endTrans();
        }
    }

    @Override
    public void undoIt() {
    }
}

