/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.OCLExpander;
import org.tigris.gef.ocl.TemplateReader;

public class CmdSavePGML
extends Cmd
implements FilenameFilter {
    private static final long serialVersionUID = 5595884484082379585L;
    private static OCLExpander _expander = null;

    public CmdSavePGML() {
        super("SaveAsPGML");
    }

    public CmdSavePGML(String string) {
        this();
        this.setArg("filterPattern", string);
    }

    @Override
    public void doIt() {
        try {
            _expander = new OCLExpander(TemplateReader.getInstance().read("/org/tigris/gef/xml/dtd/PGML.tee"));
            Object object = Globals.curEditor();
            Diagram diagram = new Diagram("junk", ((Editor)object).getGraphModel(), (LayerPerspective)((Editor)object).getLayerManager().getActiveLayer());
            object = new FileDialog(((Editor)object).findFrame(), "Save Diagram in PGML format", 1);
            ((FileDialog)object).setFilenameFilter(this);
            ((FileDialog)object).setDirectory(Globals.getLastDirectory());
            ((Dialog)object).setVisible(true);
            String string = ((FileDialog)object).getFile();
            object = ((FileDialog)object).getDirectory();
            Globals.setLastDirectory((String)object);
            if (string != null) {
                Globals.showStatus("Writing " + (String)object + string + "...");
                FileWriter fileWriter = new FileWriter((String)object + string);
                System.out.println("Cmd save in PGML...");
                _expander.expand(fileWriter, (Object)diagram);
                System.out.println("save done");
                Globals.showStatus("Wrote " + (String)object + string);
                fileWriter.close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
            return;
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
            return;
        }
        catch (ExpansionException expansionException) {
            System.out.println("got an Exception");
            expansionException.printStackTrace();
            return;
        }
    }

    @Override
    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }
}

