/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigris.gef.properties.ui.ColorEditor;
import org.tigris.gef.properties.ui.ColorTilePanel;

public class ColorPickerGrid
extends JPanel
implements ActionListener {
    protected ColorTilePanel _tiles = new ColorTilePanel(36);
    protected ColorEditor _peColor = null;
    protected static ColorPickerGrid _theInstance = null;
    protected JLabel _statusLabel = new JLabel("No color selected");

    public ColorPickerGrid(Color color) {
        this.setLayout(new BorderLayout());
        this._statusLabel.setFont(new Font("Courier", 0, 10));
        this.setBackground(new Color(0xC0C0C0));
        this.add((Component)this._tiles, "Center");
        this.add((Component)this._statusLabel, "South");
        this._tiles.setColor(color);
        this._tiles.addActionListener(this);
    }

    public void setPEColor(ColorEditor colorEditor) {
        this._peColor = colorEditor;
        if (this._peColor != null) {
            this._tiles.allowSelection(true);
            this.setColor((Color)this._peColor.getValue());
            return;
        }
        this._tiles.allowSelection(false);
        this.updateStatusLabel();
    }

    public void setColor(Color color) {
        this._tiles.setColor(color);
        this.updateStatusLabel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateStatusLabel();
        if (this._peColor != null) {
            this._peColor.setValue(this._tiles.getColor());
        }
    }

    public void updateStatusLabel() {
        if (this._peColor == null) {
            this._statusLabel.setText("No color selected");
            return;
        }
        Color color = this._tiles.getColor();
        String string = Integer.toString(color.getRed(), 16).toUpperCase();
        String string2 = Integer.toString(color.getBlue(), 16).toUpperCase();
        String string3 = Integer.toString(color.getGreen(), 16).toUpperCase();
        if (color.getRed() == 0) {
            string = "00";
        }
        if (color.getBlue() == 0) {
            string2 = "00";
        }
        if (color.getGreen() == 0) {
            string3 = "00";
        }
        this._statusLabel.setText("Red:" + string + " Blue:" + string2 + " Green:" + string3);
    }
}

