/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.hrSSM;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.andreinc.aleph.AlephFormatter;
import ro.deversoft.utils.noarch.ExportedByXml;
import ro.deversoft.utils.noarch.ProguardKeepMethods;
import ro.deversoft.utils.noarch.ProguardKeepNames;

public class HrWorkShiftRule
implements Serializable,
ExportedByXml,
ProguardKeepMethods,
ProguardKeepNames {
    private int workMinutes;
    private int restMinutes;
    private int breakMinutes;
    private int[] workWeek;
    private boolean includeLegalHolidays;
    private String[] workShiftStart;
    private String[] lunchBreakStart;
    private static final Pattern pattern = Pattern.compile("(([0-9]{1,4}/[0-9]{1,6}/([1-7]{1}[,]{0,1}){1,7}/((0|1|2){1}([0-9]){1}:(0|1|2){1}([0-9]){1}[,]{0,1}){1,}/(YES|NO){1})|([0-9]{1,4}/[0-9]{1,6}/([0-9]{1,4}/){1}([1-7]{1}[,]{0,1}){1,7}/((0|1|2){1}([0-9]){1}:(0|1|2){1}([0-9]){1}[,]{0,1}){1,}/(YES|NO){1}/((0|1|2){1}([0-9]){1}:(0|1|2){1}([0-9]){1}[,]{0,1}){1,})|)");

    public static final void main(String[] stringArray) {
        assert (HrWorkShiftRule.checkPattern(pattern, "480/960/1,2,3,4,5/09:00/NO"));
        assert (HrWorkShiftRule.checkPattern(pattern, "480/960/1,2,3,4,5/09:00,17:00,01:00/NO"));
        assert (HrWorkShiftRule.checkPattern(pattern, "480/960/60/1,2,3,4,5,6,7/09:00,21:00/YES/13:00"));
        assert (HrWorkShiftRule.checkPattern(pattern, "480/960/60/1,2,3,4,5,6,7/09:00,21:00/YES/13:00,01:00"));
        assert (HrWorkShiftRule.checkPattern(pattern, "480/960/1,2,3,4,5/09:00/NO"));
        assert (!HrWorkShiftRule.checkPattern(pattern, "480.0/960/60/1,2,3,4,5/09:00/NO/"));
        assert (!HrWorkShiftRule.checkPattern(pattern, "480.0/960/60/1,2,3,4,5/09:00/NO"));
    }

    private static int[] buildWorkWeek(String stringArray) {
        stringArray = stringArray.split(",");
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            nArray[n2++] = Integer.parseInt(string.trim());
        }
        return nArray;
    }

    private static String[] buildWorkShiftStart(String stringArray) {
        stringArray = stringArray.split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            stringArray2[n2++] = string.trim();
        }
        return stringArray2;
    }

    public static HrWorkShiftRule buildFromString(String stringArray) {
        if (stringArray != null && stringArray.length() > 0 && HrWorkShiftRule.checkPattern(pattern, (String)stringArray)) {
            stringArray = stringArray.split("/");
            HrWorkShiftRule hrWorkShiftRule = new HrWorkShiftRule();
            hrWorkShiftRule.setWorkMinutes(Integer.parseInt(stringArray[0]));
            hrWorkShiftRule.setRestMinutes(Integer.parseInt(stringArray[1]));
            if (stringArray.length == 5) {
                hrWorkShiftRule.setBreakMinutes(0);
                hrWorkShiftRule.setWorkWeek(HrWorkShiftRule.buildWorkWeek(stringArray[2]));
                hrWorkShiftRule.setWorkShiftStart(HrWorkShiftRule.buildWorkShiftStart(stringArray[3]));
                hrWorkShiftRule.setIncludeLegalHolidays(stringArray[4].equals("YES"));
            } else if (stringArray.length == 7) {
                hrWorkShiftRule.setBreakMinutes(Integer.parseInt(stringArray[2]));
                hrWorkShiftRule.setWorkWeek(HrWorkShiftRule.buildWorkWeek(stringArray[3]));
                hrWorkShiftRule.setWorkShiftStart(HrWorkShiftRule.buildWorkShiftStart(stringArray[4]));
                hrWorkShiftRule.setIncludeLegalHolidays(stringArray[5].equals("YES"));
                hrWorkShiftRule.setLunchBreakStart(HrWorkShiftRule.buildWorkShiftStart(stringArray[6]));
            }
            return hrWorkShiftRule;
        }
        return null;
    }

    public String toString() {
        String string = Arrays.stream(this.workWeek).mapToObj(Integer::toString).collect(Collectors.joining(","));
        String string2 = "#{workMinutes}/#{restMinutes}/#{breakMinutes}/#{workWeek}/#{workShiftStart}/#{includeLegalHolidays}/#{lunchBreakStart}";
        if (this.lunchBreakStart == null) {
            string2 = "#{workMinutes}/#{restMinutes}/#{workWeek}/#{workShiftStart}/#{includeLegalHolidays}";
        }
        return AlephFormatter.str((String)string2).arg("workMinutes", (Object)this.workMinutes).arg("restMinutes", (Object)this.restMinutes).arg("breakMinutes", (Object)this.breakMinutes).arg("workWeek", (Object)string).arg("workShiftStart", (Object)Arrays.stream(this.workShiftStart).collect(Collectors.joining(","))).arg("includeLegalHolidays", (Object)(this.includeLegalHolidays ? "YES" : "NO")).arg("lunchBreakStart", (Object)(this.lunchBreakStart != null ? Arrays.stream(this.lunchBreakStart).collect(Collectors.joining(",")) : "")).fmt();
    }

    private static boolean checkPattern(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    public int getWorkMinutes() {
        return this.workMinutes;
    }

    public void setWorkMinutes(int n2) {
        this.workMinutes = n2;
    }

    public int getRestMinutes() {
        return this.restMinutes;
    }

    public void setRestMinutes(int n2) {
        this.restMinutes = n2;
    }

    public int getBreakMinutes() {
        return this.breakMinutes;
    }

    public void setBreakMinutes(int n2) {
        this.breakMinutes = n2;
    }

    public int[] getWorkWeek() {
        return this.workWeek;
    }

    public void setWorkWeek(int[] nArray) {
        this.workWeek = nArray;
    }

    public boolean isIncludeLegalHolidays() {
        return this.includeLegalHolidays;
    }

    public void setIncludeLegalHolidays(boolean bl2) {
        this.includeLegalHolidays = bl2;
    }

    public String[] getWorkShiftStart() {
        return this.workShiftStart;
    }

    public void setWorkShiftStart(String[] stringArray) {
        this.workShiftStart = stringArray;
    }

    public String[] getLunchBreakStart() {
        return this.lunchBreakStart;
    }

    public void setLunchBreakStart(String[] stringArray) {
        this.lunchBreakStart = stringArray;
    }

    public String getErrors() {
        if (this.lunchBreakStart != null && this.lunchBreakStart.length != this.workShiftStart.length) {
            return "Pauzele de masa nu corespund turelor !";
        }
        return null;
    }

    public static HrWorkShiftRule buildFromJsonObject(JsonObject stringArray) {
        int n2 = stringArray.get("workMinutes").getAsInt();
        int n3 = stringArray.get("restMinutes").getAsInt();
        int n4 = stringArray.get("breakMinutes").getAsInt();
        boolean bl2 = stringArray.get("includeLegalHolidays").getAsBoolean();
        String[] stringArray2 = (String[])stringArray.get("workWeek");
        int[] nArray = new int[stringArray2.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = stringArray2.get(i2).getAsInt();
        }
        Object object = (JsonArray)stringArray.get("workShiftStart");
        stringArray2 = new String[((JsonArray)object).size()];
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            stringArray2[i3] = ((JsonArray)object).get(i3).getAsString();
        }
        JsonElement jsonElement = stringArray.get("lunchBreakStart");
        stringArray = null;
        if (jsonElement instanceof JsonArray) {
            object = (JsonArray)jsonElement;
            stringArray = new String[((JsonArray)object).size()];
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                stringArray[i4] = ((JsonArray)object).get(i4).getAsString();
            }
        } else if (jsonElement != null) {
            stringArray = new String[]{jsonElement.getAsString()};
        }
        object = new HrWorkShiftRule();
        ((HrWorkShiftRule)object).setWorkMinutes(n2);
        ((HrWorkShiftRule)object).setRestMinutes(n3);
        ((HrWorkShiftRule)object).setBreakMinutes(n4);
        ((HrWorkShiftRule)object).setIncludeLegalHolidays(bl2);
        ((HrWorkShiftRule)object).setWorkWeek(nArray);
        ((HrWorkShiftRule)object).setWorkShiftStart(stringArray2);
        ((HrWorkShiftRule)object).setLunchBreakStart(stringArray);
        return object;
    }
}

