/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.gef.persistence.FontUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGWriter
extends Graphics {
    private Utf8Writer _writer;
    Document _svg;
    Element _root;
    private Color _fColor = Color.black;
    private Color _bgColor = Color.white;
    private Rectangle _drawingArea;
    private Font _font = new Font("Verdana", 0, 8);
    private Rectangle _clip;
    private int _xOffset = 0;
    private int _yOffset = 0;
    private int _hInset = 10;
    private int _vInset = 10;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private String SVGns = "http://www.w3.org/2000/SVG";

    public SVGWriter(OutputStream stream, Rectangle drawingArea) throws IOException, Exception {
        this._writer = new Utf8Writer(stream);
        this._drawingArea = drawingArea;
        this.translate(this._hInset - drawingArea.x, this._vInset - drawingArea.y);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this._svg = builder.newDocument();
        this._root = this._svg.createElement("svg");
        this._root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this._root.setAttribute("width", "" + (2 * this._hInset + this.scaleX(this._drawingArea.width)));
        this._root.setAttribute("height", "" + (2 * this._vInset + this.scaleY(this._drawingArea.height)));
    }

    public Graphics create() {
        return this;
    }

    public Graphics create(int x, int y, int width, int height) {
        return this;
    }

    public void dispose() {
        this._svg.appendChild(this._root);
        this.printDOMTree(this._svg);
        this._writer.close();
    }

    public void printDOMTree(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this._writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                this._writer.print("<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 20001102//EN' 'http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd'>\n");
                this.printDOMTree(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                this._writer.print("<");
                this._writer.print(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    this._writer.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                NodeList children = node.getChildNodes();
                if (children.getLength() > 0) {
                    this._writer.println(">");
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.printDOMTree(children.item(i));
                    }
                    this._writer.print("</");
                    this._writer.print(node.getNodeName());
                    this._writer.println(">");
                    break;
                }
                this._writer.println("/>");
                break;
            }
            case 5: {
                this._writer.print("&");
                this._writer.print(node.getNodeName());
                this._writer.print(";");
                break;
            }
            case 4: {
                this._writer.print("<![CDATA[");
                this._writer.print(node.getNodeValue());
                this._writer.print("]]>");
                break;
            }
            case 3: {
                String text = node.getNodeValue();
                block15: for (int i = 0; i < text.length(); ++i) {
                    switch (text.charAt(i)) {
                        case '&': {
                            this._writer.print("&amp;");
                            continue block15;
                        }
                        case '<': {
                            this._writer.print("&lt;");
                            continue block15;
                        }
                        case '>': {
                            this._writer.print("&gt;");
                            continue block15;
                        }
                        default: {
                            this._writer.print(text.charAt(i));
                        }
                    }
                }
                break;
            }
            case 7: {
                this._writer.print("<?");
                this._writer.print(node.getNodeName());
                String data = node.getNodeValue();
                this._writer.print("");
                this._writer.print(data);
                this._writer.print("?>");
                break;
            }
        }
    }

    public Color getColor() {
        return this._fColor;
    }

    private String getColorAsString() {
        return "#" + Integer.toHexString(this._fColor.getRGB()).substring(2);
    }

    public void setColor(Color c) {
        this._fColor = c;
    }

    private Color getBackgroundColor() {
        return this._bgColor;
    }

    private String getBackgroundColorAsString() {
        return "#" + Integer.toHexString(this._bgColor.getRGB()).substring(2);
    }

    private void setBackgroundColor(Color c) {
        this._bgColor = c;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color otherColor) {
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this._font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontUtility.getFontMetrics(font);
    }

    private String getFontStyleSVG() {
        String style = "font-family:" + this._font.getFamily() + "; font-size:" + this._font.getSize() + ";";
        if (this.getFont().isBold()) {
            style = style + " font-weight:bold;";
        }
        if (this.getFont().isItalic()) {
            style = style + " font-style:italic;";
        }
        return style;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    private int scaleX(int x) {
        return (int)((double)x * this.xScale);
    }

    private int scaleY(int y) {
        return (int)((double)y * this.yScale);
    }

    private int transformX(int x) {
        return this.scaleX(x) + this._xOffset;
    }

    private int transformY(int y) {
        return this.scaleY(y) + this._yOffset;
    }

    private void drawRect(int x, int y, int w, int h, String style) {
        Element rect = this._svg.createElement("rect");
        rect.setAttribute("x", "" + this.transformX(x));
        rect.setAttribute("y", "" + this.transformY(y));
        rect.setAttribute("width", "" + this.scaleX(w));
        rect.setAttribute("height", "" + this.scaleY(h));
        rect.setAttribute("style", style);
        this._root.appendChild(rect);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, "fill: none; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void fillRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, "fill:" + this.getColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void clearRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, "fill:" + this.getBackgroundColorAsString() + "; stroke:" + this.getBackgroundColorAsString() + "; stroke-width:1");
    }

    private void writeEllipsePath(int x, int y, int w, int h, int startAngle, int arcAngle) {
    }

    private void drawOval(int x, int y, int w, int h, String style) {
        Element oval = this._svg.createElement("ellipse");
        oval.setAttribute("cx", "" + this.transformX(x + w / 2));
        oval.setAttribute("cy", "" + this.transformY(y + h / 2));
        oval.setAttribute("rx", "" + (double)this.scaleX(w) / 2.0);
        oval.setAttribute("ry", "" + (double)this.scaleY(h) / 2.0);
        oval.setAttribute("style", style);
        this._root.appendChild(oval);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.drawOval(x, y, w, h, "fill: none; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void fillOval(int x, int y, int w, int h) {
        this.drawOval(x, y, w, h, "fill:" + this.getColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void drawArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
    }

    public void fillArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
    }

    private void drawRoundRect(int x, int y, int w, int h, int arcw, int arch, String style) {
        Element rect = this._svg.createElement("rect");
        rect.setAttribute("x", "" + this.transformX(x));
        rect.setAttribute("y", "" + this.transformY(y));
        rect.setAttribute("width", "" + this.scaleX(w));
        rect.setAttribute("height", "" + this.scaleY(h));
        rect.setAttribute("rx", "" + this.scaleX(arcw));
        rect.setAttribute("ry", "" + this.scaleY(arch));
        rect.setAttribute("style", style);
        this._root.appendChild(rect);
    }

    public void drawRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, "fill:" + this.getBackgroundColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void fillRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.drawRoundRect(x, y, w, h, arcw, arch, "fill:" + this.getColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    private void drawPolygon(int[] xPoints, int[] yPoints, int nPoints, String style) {
        double maxX = 0.0;
        double maxY = 0.0;
        Element polygon = this._svg.createElement("polygon");
        polygon.setAttribute("style", style);
        StringBuffer pointList = new StringBuffer();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                pointList.append(" ");
            }
            pointList.append("" + this.transformX(xPoints[i]) + "," + this.transformY(yPoints[i]));
            if ((double)this.transformX(xPoints[i]) > maxX) {
                maxX = this.transformX(xPoints[i]);
            }
            if (!((double)this.transformY(yPoints[i]) > maxY)) continue;
            maxY = this.transformY(yPoints[i]);
        }
        polygon.setAttribute("points", pointList.toString());
        this._root.appendChild(polygon);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, "fill:none; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void drawPolygon(Polygon poly) {
        this.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, "fill:" + this.getColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
    }

    public void fillPolygon(Polygon poly) {
        this.fillPolygon(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        double maxX = 0.0;
        double maxY = 0.0;
        Element polyline = this._svg.createElement("polyline");
        polyline.setAttribute("style", "fill:none; stroke:" + this.getColorAsString() + "; stroke-width:1");
        StringBuffer pointList = new StringBuffer();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                pointList.append(" ");
            }
            pointList.append("" + this.transformX(xPoints[i]) + "," + this.transformY(yPoints[i]));
            if ((double)this.transformX(xPoints[i]) > maxX) {
                maxX = this.transformX(xPoints[i]);
            }
            if (!((double)this.transformY(yPoints[i]) > maxY)) continue;
            maxY = this.transformY(yPoints[i]);
        }
        polyline.setAttribute("points", pointList.toString());
        this._root.appendChild(polyline);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Element line = this._svg.createElement("line");
        line.setAttribute("x1", "" + this.transformX(x1));
        line.setAttribute("y1", "" + this.transformY(y1));
        line.setAttribute("x2", "" + this.transformX(x2));
        line.setAttribute("y2", "" + this.transformY(y2));
        line.setAttribute("style", "fill:" + this.getColorAsString() + "; stroke:" + this.getColorAsString() + "; stroke-width:1");
        this._root.appendChild(line);
    }

    public void setClip(int x, int y, int w, int h) {
        this._clip = new Rectangle(x, y, w, h);
    }

    public void setClip(Shape clip) {
        Rectangle bounds = clip.getBounds();
        this.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Rectangle getClipBounds() {
        return this._clip;
    }

    public void clipRect(int x, int y, int w, int h) {
        if (this._clip == null) {
            this.setClip(x, y, w, h);
        } else {
            this._clip = this._clip.intersection(new Rectangle(x, y, w, h));
        }
    }

    public Shape getClip() {
        return this._clip;
    }

    public void translate(int x, int y) {
        this._xOffset = x;
        this._yOffset = y;
    }

    public void scale(double xscale, double yscale) {
        this.xScale = xscale;
        this.yScale = yscale;
    }

    public void drawString(String t, int x, int y) {
        Element text = this._svg.createElement("text");
        text.setAttribute("x", "" + this.transformX(x));
        text.setAttribute("y", "" + this.transformY(y));
        text.setAttribute("style", this.getFontStyleSVG());
        text.appendChild(this._svg.createTextNode(t));
        this._root.appendChild(text);
    }

    public void drawString(AttributedCharacterIterator aci, int i1, int i2) {
    }

    public void drawString(CharacterIterator aci, int i1, int i2) {
    }

    private static class Utf8Writer {
        private OutputStreamWriter _writer;

        public Utf8Writer(OutputStream out) {
            try {
                this._writer = new OutputStreamWriter(out, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("[SVGWriter] UTF-8 not supported. Switching to default." + e);
                this._writer = new OutputStreamWriter(out);
            }
        }

        public void print(String s) {
            try {
                this._writer.write(s);
            }
            catch (IOException e) {
                System.err.println("[SVGWriter] " + e);
            }
        }

        public void print(char c) {
            try {
                this._writer.write(c);
            }
            catch (IOException e) {
                System.err.println("[SVGWriter] " + e);
            }
        }

        public void println(String s) {
            try {
                this._writer.write(s);
                this._writer.write(10);
            }
            catch (IOException e) {
                System.err.println("[SVGWriter] " + e);
            }
        }

        public void close() {
            try {
                this._writer.close();
            }
            catch (IOException e) {
                System.err.println("[SVGWriter] " + e);
            }
        }
    }
}

