/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import mseries.utils.SafeCalendarUtils;

public class MonthPopup
extends JWindow {
    JList months;
    MonthModel model = new MonthModel();
    AutoChanger autoChanger;
    Calendar c1;
    int width;
    int height;

    public MonthPopup() {
        this.months = new JList();
        this.setValue(new Date());
        this.months.setModel(this.model);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.getContentPane().add(this.months);
        this.months.setCellRenderer(this.getCellRenderer());
        this.months.setSelectionMode(0);
        this.months.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void setLocationOnScreen(int x, int y) {
        this.setLocation(x, y);
    }

    public Object getValue() {
        return this.months.getSelectedValue();
    }

    public void setValue(Date value) {
        this.model.setMonth(value);
        this.months.setSelectedIndex(3);
    }

    public void setSelectedPoint(Point p) {
        if (p.y < 0 || p.y > this.height) {
            this.months.clearSelection();
        } else {
            int whichSelected = this.months.locationToIndex(p);
            if (whichSelected == 0) {
                if (this.autoChanger == null || this.autoChanger.isIncrementing()) {
                    if (this.autoChanger != null) {
                        this.autoChanger.stopThread();
                    }
                    this.autoChanger = new AutoChanger(this.model);
                    this.autoChanger.setDirection(-1);
                    this.autoChanger.start();
                }
            } else if (whichSelected == this.months.getModel().getSize() - 1) {
                if (this.autoChanger == null || this.autoChanger.isDecrementing()) {
                    if (this.autoChanger != null) {
                        this.autoChanger.stopThread();
                    }
                    this.autoChanger = new AutoChanger(this.model);
                    this.autoChanger.setDirection(1);
                    this.autoChanger.start();
                }
            } else if (this.autoChanger != null) {
                this.autoChanger.stopThread();
                this.autoChanger = null;
            }
            this.months.setSelectedIndex(this.months.locationToIndex(p));
        }
    }

    public ListCellRenderer getCellRenderer() {
        DefaultListCellRenderer r = new DefaultListCellRenderer(){
            DateFormat df = new SimpleDateFormat("MMMMM yyyy");

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Date d = (Date)value;
                this.setText(this.df.format(d));
                this.setHorizontalAlignment(0);
                this.setBackground(isSelected ? UIManager.getColor("ComboBox.selectionBackground") : UIManager.getColor("ComboBox.background"));
                this.setForeground(isSelected ? UIManager.getColor("ComboBox.selectionForeground") : UIManager.getColor("ComboBox.foreground"));
                return this;
            }
        };
        return r;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        MonthPopup f = new MonthPopup();
        f.pack();
        f.setLocationOnScreen(100, 100);
        f.setVisible(true);
    }

    class AutoChanger
    extends Thread {
        static final int INC = 1;
        static final int DEC = -1;
        int dir = 1;
        MonthModel model;
        boolean keepGoing;

        public AutoChanger(MonthModel model) {
            this.model = model;
            this.keepGoing = true;
        }

        public void setDirection(int dir) {
            this.dir = dir;
        }

        public boolean isIncrementing() {
            return this.dir == 1;
        }

        public boolean isDecrementing() {
            return this.dir == -1;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.keepGoing = false;
            }
            this.keepGoing = true;
            while (this.keepGoing) {
                try {
                    this.model.increment(this.dir);
                    Thread.sleep(750L);
                }
                catch (InterruptedException e) {
                    this.keepGoing = false;
                }
            }
        }

        public void stopThread() {
            this.keepGoing = false;
        }
    }

    class MonthModel
    extends AbstractListModel {
        Date firstDate = new Date();
        Calendar firstCal;

        MonthModel() {
        }

        public void setMonth(Date month) {
            this.firstCal = Calendar.getInstance();
            this.firstCal.setTime(month);
            SafeCalendarUtils.doSafeAddition(this.firstCal, 2, -3);
        }

        public Object getElementAt(int i) {
            MonthPopup.this.c1 = (Calendar)this.firstCal.clone();
            SafeCalendarUtils.doSafeAddition(MonthPopup.this.c1, 2, i);
            return MonthPopup.this.c1.getTime();
        }

        public int getSize() {
            return 7;
        }

        public void increment(int inc) {
            SafeCalendarUtils.doSafeAddition(this.firstCal, 2, inc);
            this.fireContentsChanged(this, 0, 6);
        }
    }
}

