/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.layouts.FlexibleGridLayout;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.textures.CompoundTexture;
import com.shfarr.ui.plaf.fh.textures.GradientTexture;
import com.shfarr.ui.plaf.fh.textures.MatrixTexture;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class TextureEditor
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener {
    private JPanel sidePanel = null;
    private JPanel centerPanel = null;
    private JPanel northPanel = null;
    private JComboBox matrixNamesCombo = null;
    private JPanel southPanel = null;
    private JComboBox texturesCombo = null;
    private JPanel textureDisplayer = null;
    private JPanel editor = null;
    private JPanel matrixTextureEditor = null;
    private Texture currentTexture = null;
    private JTable colorList = null;
    private JTable textureList = null;
    private JPanel gradientTextureEditor = null;
    private JPanel compoundTextureEditor = null;
    private JSpinner rotationSpinner = null;
    private JComboBox colorNames = null;
    private String type = "matrix";
    private JRadioButton[] radios = null;
    private JTable workingList = null;
    private JPanel spinnerPanel = null;
    private JPanel listButtonPanel = null;

    public TextureEditor() {
        super(new BorderLayout(3, 3));
        this.setBorder(new EmptyBorder(10, 4, 0, 0));
        this.getNorthPanel();
        this.add((Component)this.getSidePanel(), "East");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout(4, 4));
            this.centerPanel.add((Component)this.getEditor(), "Center");
            this.centerPanel.add((Component)this.getSouthPanel(), "North");
        }
        return this.centerPanel;
    }

    protected JPanel getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(new BorderLayout(4, 4));
            this.editor.setBorder(new EmptyBorder(4, 4, 4, 0));
        }
        return this.editor;
    }

    protected JTable getColorList() {
        if (this.colorList == null) {
            this.colorList = new JTable(new DefaultTableModel(new String[0][], new String[]{"Colors"}));
            this.colorList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.getColorNames()));
        }
        return this.colorList;
    }

    protected JTable getTextureList() {
        if (this.textureList == null) {
            this.textureList = new JTable(new DefaultTableModel(new String[0][], new String[]{"Textures"}));
            JComboBox<String> combo = new JComboBox<String>();
            combo.addActionListener(this);
            combo.setActionCommand("Subtexture Selected");
            Iterator i = ThemeEditor.instance().getEditedTheme().texturePalette().keySet().iterator();
            while (i.hasNext()) {
                combo.addItem((String)i.next());
            }
            this.textureList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(combo));
        }
        return this.textureList;
    }

    protected JComboBox getColorNames() {
        if (this.colorNames == null) {
            this.colorNames = new JComboBox();
            Iterator i = ThemeEditor.instance().getEditedTheme().colorPalette().keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.colorNames.addItem(name);
            }
            int i2 = -10;
            while (i2 < 10) {
                this.colorNames.addItem("" + i2);
                ++i2;
            }
        }
        return this.colorNames;
    }

    protected JSpinner getRotationSpinner() {
        if (this.rotationSpinner == null) {
            this.rotationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 270, 90));
            this.rotationSpinner.addChangeListener(this);
        }
        return this.rotationSpinner;
    }

    protected JPanel getListButtonPanel() {
        if (this.listButtonPanel == null) {
            this.listButtonPanel = new JPanel(new FlexibleGridLayout(2, 2, 4, 4));
            JButton addC = new JButton("+");
            addC.addActionListener(this);
            addC.setMargin(new Insets(1, 3, 1, 3));
            JButton remC = new JButton("-");
            remC.addActionListener(this);
            remC.setMargin(new Insets(1, 3, 1, 3));
            JButton moveR = new JButton(">");
            moveR.addActionListener(this);
            moveR.setMargin(new Insets(1, 3, 1, 3));
            JButton moveL = new JButton("<");
            moveL.addActionListener(this);
            moveL.setMargin(new Insets(1, 3, 1, 3));
            this.listButtonPanel.add(addC);
            this.listButtonPanel.add(remC);
            this.listButtonPanel.add(moveL);
            this.listButtonPanel.add(moveR);
        }
        return this.listButtonPanel;
    }

    protected JPanel getSpinnerPanel() {
        if (this.spinnerPanel == null) {
            this.spinnerPanel = new JPanel(new QueueLayout(4, 0, 2));
            this.spinnerPanel.add(new JLabel("Rotation", 2));
            this.spinnerPanel.add(this.getRotationSpinner());
            this.spinnerPanel.add(new JLabel());
        }
        return this.spinnerPanel;
    }

    protected JPanel getGradientTextureEditor() {
        if (this.gradientTextureEditor == null) {
            this.gradientTextureEditor = new JPanel(new BorderLayout(4, 4));
            JPanel actPanel = new JPanel(new QueueLayout(4, 0, 2));
            JScrollPane scp = new JScrollPane(this.getColorList());
            scp.setPreferredSize(new Dimension(100, 30));
            this.gradientTextureEditor.add((Component)scp, "Center");
            this.gradientTextureEditor.add((Component)actPanel, "West");
        }
        return this.gradientTextureEditor;
    }

    protected JPanel getCompoundTextureEditor() {
        if (this.compoundTextureEditor == null) {
            this.compoundTextureEditor = new JPanel(new BorderLayout(4, 4));
            JPanel actPanel = new JPanel(new QueueLayout(4, 0, 2));
            JScrollPane scp = new JScrollPane(this.getTextureList());
            scp.setPreferredSize(new Dimension(100, 30));
            this.compoundTextureEditor.add((Component)scp, "Center");
            this.compoundTextureEditor.add((Component)actPanel, "West");
        }
        return this.compoundTextureEditor;
    }

    protected JPanel getTextureDisplayer() {
        if (this.textureDisplayer == null) {
            this.textureDisplayer = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    if (TextureEditor.this.currentTexture != null) {
                        Insets i = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
                        Rectangle r = new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                        r.x += i.left;
                        r.y += i.top;
                        r.width -= i.left + i.right;
                        r.height -= i.top + i.bottom;
                        r.width /= 2;
                        GraphicsUtils.paintTiledBackground(g, r, 5);
                        TextureEditor.this.currentTexture.apply(r, (Graphics2D)g, this);
                        r.x += r.width;
                        TextureEditor.this.currentTexture.apply(r, (Graphics2D)g, this);
                        g.setColor(Color.black);
                        g.drawLine(r.x, r.y, r.x, r.y + r.height);
                        r.x -= r.width;
                        r.width *= 2;
                        g.drawRect(r.x, r.y, r.width, r.height);
                    }
                }
            };
            this.textureDisplayer.setPreferredSize(new Dimension(100, 100));
        }
        return this.textureDisplayer;
    }

    protected JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new JPanel(new QueueLayout(4, 100, 2));
            this.southPanel.add(new JLabel("Texture", 4));
            this.southPanel.add(this.getTexturesCombo());
        }
        return this.southPanel;
    }

    protected JPanel getMatrixTextureEditor() {
        if (this.matrixTextureEditor == null) {
            this.matrixTextureEditor = new JPanel(new QueueLayout(4, 0, 2));
            this.matrixTextureEditor.add(new JLabel("Matrix"));
            this.matrixTextureEditor.add(this.getMatrixNamesCombo());
        }
        return this.matrixTextureEditor;
    }

    protected JComboBox getMatrixNamesCombo() {
        if (this.matrixNamesCombo == null) {
            this.matrixNamesCombo = new JComboBox();
            Iterator i = ThemeEditor.instance().getEditedTheme().matrixPalette().keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!name.startsWith("textures/.")) continue;
                this.matrixNamesCombo.addItem(name.substring(10));
            }
        }
        return this.matrixNamesCombo;
    }

    protected JComboBox getTexturesCombo() {
        if (this.texturesCombo == null) {
            this.texturesCombo = new JComboBox();
            this.texturesCombo.setEditable(true);
            this.texturesCombo.addItemListener(this);
            Iterator i = ThemeEditor.instance().getEditedTheme().texturePalette().keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.texturesCombo.addItem(name);
            }
            this.texturesCombo.setPreferredSize(new Dimension(Math.max(this.texturesCombo.getPreferredSize().width, 150), this.texturesCombo.getPreferredSize().height));
        }
        return this.texturesCombo;
    }

    protected JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel(new FlexibleGridLayout(1, 4, 4, 4));
            this.northPanel.setBorder(new EmptyBorder(4, 0, 4, 0));
            this.radios = new JRadioButton[4];
            this.radios[0] = new JRadioButton("None");
            this.radios[0].addActionListener(this);
            this.radios[1] = new JRadioButton("Matrix Based");
            this.radios[1].setSelected(true);
            this.radios[1].addActionListener(this);
            this.radios[2] = new JRadioButton("Gradient");
            this.radios[2].addActionListener(this);
            this.radios[3] = new JRadioButton("Compound");
            this.radios[3].addActionListener(this);
            ButtonGroup group = new ButtonGroup();
            group.add(this.radios[0]);
            group.add(this.radios[1]);
            group.add(this.radios[2]);
            group.add(this.radios[3]);
            this.northPanel.add(this.radios[0]);
            this.northPanel.add(this.radios[1]);
            this.northPanel.add(this.radios[2]);
            this.northPanel.add(this.radios[3]);
        }
        return this.northPanel;
    }

    protected JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new QueueLayout(4, 0, 2));
            this.sidePanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            JButton save = new JButton("Save");
            save.addActionListener(this);
            JButton revert = new JButton("Revert");
            revert.addActionListener(this);
            JButton delete = new JButton("Delete");
            delete.addActionListener(this);
            JButton set = new JButton("Add / Set");
            set.addActionListener(this);
            this.sidePanel.add(save);
            this.sidePanel.add(revert);
            this.sidePanel.add(new JPanel());
            this.sidePanel.add(set);
            this.sidePanel.add(delete);
        }
        return this.sidePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            this.selectSubEditor(e.getActionCommand());
        } else if (e.getActionCommand().equals("+")) {
            ((DefaultTableModel)this.workingList.getModel()).addRow(new String[]{this.workingList.getColumnModel().getColumn(0).getCellEditor().getCellEditorValue().toString()});
            this.updateTexture();
        } else if (e.getActionCommand().equals("-")) {
            if (this.workingList.getSelectedRow() != -1) {
                ((DefaultTableModel)this.workingList.getModel()).removeRow(this.workingList.getSelectedRow());
            }
            this.updateTexture();
        } else if (e.getActionCommand().equals("<")) {
            int se = this.workingList.getSelectedRow();
            if (se > 0) {
                String obj = (String)((DefaultTableModel)this.workingList.getModel()).getValueAt(se, 0);
                ((DefaultTableModel)this.workingList.getModel()).removeRow(this.workingList.getSelectedRow());
                ((DefaultTableModel)this.workingList.getModel()).insertRow(se - 1, new String[]{obj});
                this.workingList.getSelectionModel().setSelectionInterval(se - 1, se - 1);
            }
            this.updateTexture();
        } else if (e.getActionCommand().equals(">")) {
            int se = this.workingList.getSelectedRow();
            if (se < this.workingList.getRowCount() - 1) {
                String obj = (String)((DefaultTableModel)this.workingList.getModel()).getValueAt(se, 0);
                ((DefaultTableModel)this.workingList.getModel()).removeRow(this.workingList.getSelectedRow());
                ((DefaultTableModel)this.workingList.getModel()).insertRow(se + 1, new String[]{obj});
                this.workingList.getSelectionModel().setSelectionInterval(se + 1, se + 1);
            }
            this.updateTexture();
        } else if (e.getActionCommand().equals("Subtexture Selected")) {
            this.updateTexture();
        } else if (e.getActionCommand().equals("Delete")) {
            this.getTexturesCombo().removeItemListener(this);
            String item = (String)this.getTexturesCombo().getSelectedItem();
            ThemeEditor.instance().getEditedTheme().texturePalette().remove(item);
            this.getTexturesCombo().removeAllItems();
            Iterator i = ThemeEditor.instance().getEditedTheme().texturePalette().keySet().iterator();
            while (i.hasNext()) {
                this.getTexturesCombo().addItem((String)i.next());
            }
            this.getTexturesCombo().addItemListener(this);
            this.getTexturesCombo().setSelectedIndex(0);
        } else if (e.getActionCommand().equals("Add / Set")) {
            this.getTexturesCombo().removeItemListener(this);
            String item = (String)this.getTexturesCombo().getSelectedItem();
            ThemeEditor.instance().getEditedTheme().texturePalette().put(item, this.currentTexture);
            this.getTexturesCombo().removeAllItems();
            Iterator i = ThemeEditor.instance().getEditedTheme().texturePalette().keySet().iterator();
            while (i.hasNext()) {
                this.getTexturesCombo().addItem((String)i.next());
            }
            this.getTexturesCombo().addItemListener(this);
            this.getTexturesCombo().setSelectedItem(item);
        } else if (e.getActionCommand().equals("Save")) {
            ThemeEditor.instance().getEditedTheme().saveTextures();
        }
    }

    protected void updateTexture() {
        if (this.type.equals("none")) {
            this.currentTexture = null;
        } else if (this.type.equals("matrix")) {
            this.currentTexture = new MatrixTexture((String[][])ThemeEditor.instance().getEditedTheme().matrixPalette().get("textures/." + this.getMatrixNamesCombo().getSelectedItem()));
        } else if (this.type.equals("gradient")) {
            String[] colors = new String[this.getColorList().getModel().getRowCount()];
            int i = 0;
            while (i < colors.length) {
                colors[i] = (String)this.getColorList().getModel().getValueAt(i, 0);
                ++i;
            }
            this.currentTexture = new GradientTexture(colors);
        } else if (this.type.equals("compound")) {
            String[] textures = new String[this.getTextureList().getModel().getRowCount()];
            int i = 0;
            while (i < textures.length) {
                textures[i] = (String)this.getTextureList().getModel().getValueAt(i, 0);
                ++i;
            }
            this.currentTexture = new CompoundTexture(textures);
        }
        if (this.currentTexture != null) {
            this.currentTexture.setTheme(ThemeEditor.instance().getEditedTheme());
            this.currentTexture.setNaturalRotation((Integer)this.getRotationSpinner().getValue() / 90);
        }
        this.getTextureDisplayer().repaint();
    }

    protected void selectSubEditor(String action) {
        this.getMatrixNamesCombo().removeItemListener(this);
        this.getColorNames().removeItemListener(this);
        if (action.equals("None")) {
            this.type = "none";
            this.getEditor().removeAll();
            this.getEditor().add((Component)this.getNorthPanel(), "North");
            ((JComponent)this.getEditor().getParent()).revalidate();
            ((JComponent)this.getEditor().getParent()).repaint();
        } else if (action.equals("Matrix Based")) {
            this.type = "matrix";
            this.getEditor().removeAll();
            this.getEditor().add((Component)this.getNorthPanel(), "North");
            this.getEditor().add((Component)this.getTextureDisplayer(), "South");
            this.getEditor().add((Component)this.getMatrixTextureEditor(), "Center");
            this.getEditor().add((Component)this.getSpinnerPanel(), "West");
            this.getSpinnerPanel().remove(this.getListButtonPanel());
            this.getMatrixNamesCombo().addItemListener(this);
            ((JComponent)this.getEditor().getParent()).revalidate();
            ((JComponent)this.getEditor().getParent()).repaint();
        } else if (action.equals("Gradient")) {
            this.type = "gradient";
            this.getEditor().removeAll();
            this.getEditor().add((Component)this.getNorthPanel(), "North");
            this.getEditor().add((Component)this.getTextureDisplayer(), "South");
            this.getEditor().add((Component)this.getGradientTextureEditor(), "Center");
            this.getEditor().add((Component)this.getSpinnerPanel(), "West");
            this.getSpinnerPanel().add(this.getListButtonPanel());
            this.getColorNames().addItemListener(this);
            ((JComponent)this.getEditor().getParent()).revalidate();
            ((JComponent)this.getEditor().getParent()).repaint();
            this.workingList = this.getColorList();
        } else if (action.equals("Compound")) {
            this.type = "compound";
            JComboBox combo = (JComboBox)((DefaultCellEditor)this.getTextureList().getColumnModel().getColumn(0).getCellEditor()).getComponent();
            combo.removeActionListener(this);
            combo.removeAllItems();
            Iterator i = ThemeEditor.instance().getEditedTheme().texturePalette().keySet().iterator();
            while (i.hasNext()) {
                combo.addItem((String)i.next());
            }
            this.getEditor().removeAll();
            this.getEditor().add((Component)this.getNorthPanel(), "North");
            this.getEditor().add((Component)this.getTextureDisplayer(), "South");
            this.getEditor().add((Component)this.getCompoundTextureEditor(), "Center");
            this.getEditor().add((Component)this.getSpinnerPanel(), "West");
            this.getSpinnerPanel().add(this.getListButtonPanel());
            ((JComponent)this.getEditor().getParent()).revalidate();
            ((JComponent)this.getEditor().getParent()).repaint();
            this.workingList = this.getTextureList();
            combo.addActionListener(this);
        }
        this.updateTexture();
    }

    public void stateChanged(ChangeEvent e) {
        this.updateTexture();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getMatrixNamesCombo()) {
            this.updateTexture();
        } else if (e.getStateChange() == 1 && e.getSource() == this.getTexturesCombo()) {
            Texture texture = (Texture)ThemeEditor.instance().getEditedTheme().texturePalette().get(this.getTexturesCombo().getSelectedItem());
            if (texture != null) {
                texture.setTheme(ThemeEditor.instance().getEditedTheme());
                this.getRotationSpinner().removeChangeListener(this);
                this.getRotationSpinner().setValue(new Integer(texture.getNaturalRotation() * 90));
                this.getRotationSpinner().addChangeListener(this);
            }
            if (texture == null) {
                this.selectSubEditor("None");
                this.radios[0].setSelected(true);
            } else if (texture instanceof MatrixTexture) {
                this.selectSubEditor("Matrix Based");
                this.radios[1].setSelected(true);
            } else if (texture instanceof GradientTexture) {
                while (this.getColorList().getRowCount() > 0) {
                    ((DefaultTableModel)this.getColorList().getModel()).removeRow(0);
                }
                int i = 0;
                while (i < ((GradientTexture)texture).getColors().length) {
                    ((DefaultTableModel)this.getColorList().getModel()).addRow(new String[]{((GradientTexture)texture).getColors()[i]});
                    ++i;
                }
                this.selectSubEditor("Gradient");
                this.radios[2].setSelected(true);
            } else if (texture instanceof CompoundTexture) {
                while (this.getTextureList().getRowCount() > 0) {
                    ((DefaultTableModel)this.getTextureList().getModel()).removeRow(0);
                }
                int i = 0;
                while (i < ((CompoundTexture)texture).getComponents().length) {
                    ((DefaultTableModel)this.getTextureList().getModel()).addRow(new String[]{((CompoundTexture)texture).getComponents()[i]});
                    ++i;
                }
                this.selectSubEditor("Compound");
                this.radios[3].setSelected(true);
            }
            this.currentTexture = texture;
        } else if (e.getStateChange() == 1 && this.workingList.getEditingRow() != -1) {
            ((DefaultTableModel)this.workingList.getModel()).setValueAt(e.getItem(), this.workingList.getEditingRow(), 0);
            this.updateTexture();
        }
    }
}

