/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.time.LocalDateTime;
import lombok.NonNull;
import ro.deversoft.odf.gearbox.common.PublicGeneralConstants;

public final class JSONCommon {
    public static final String DEFAULT_EMPTY_JSON_STRVAL = "{}";
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE;

    private static void commonCustomizationOfObjectMapper(ObjectMapper jsonObjectMapper) {
        JavaTimeModule module = new JavaTimeModule();
        LocalDateTimeDeserializer localDateTimeDeserializer = new LocalDateTimeDeserializer(PublicGeneralConstants.LOCALDATETIME_FORMATTER_YYYY_MM_DD_HH_MM_SS);
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)localDateTimeDeserializer);
        jsonObjectMapper.registerModule((Module)module);
    }

    public static ObjectMapper acquireJsonObjectMapper() {
        return JSON_OBJECT_MAPPER;
    }

    public static ObjectMapper acquireJsonObjectMapperWithWrapRootValue() {
        return JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE;
    }

    public static final JsonNode readTreeFromNonNullJsonStr(@NonNull String jsonSource) {
        if (jsonSource == null) {
            throw new NullPointerException("jsonSource is marked non-null but is null");
        }
        return JSON_OBJECT_MAPPER.readTree(jsonSource);
    }

    public static final JsonNode readTreeFromJsonStr(String jsonSource) {
        return jsonSource == null ? null : JSONCommon.readTreeFromNonNullJsonStr(jsonSource);
    }

    public static final String writeObjectToString(Object object) {
        return JSON_OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    private JSONCommon() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        JSON_OBJECT_MAPPER.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        JSONCommon.commonCustomizationOfObjectMapper(JSON_OBJECT_MAPPER);
        JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE = new ObjectMapper();
        JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        JSONCommon.commonCustomizationOfObjectMapper(JSON_OBJECT_MAPPER_WITH_WRAP_ROOT_VALUE);
    }
}

