/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitEnumDDD;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitSystemEnum;

public class MeasurementUnitDDD
implements Serializable {
    private String symbol;
    private String description;
    private MeasurementUnitSystemEnum unitSystem;
    private MeasurementUnitEnumDDD standardizedSymbol;
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, MeasurementUnitDDD> getAllAvailableUnits() {
        Map<String, MeasurementUnitDDD> result = Collections.synchronizedMap(new LinkedHashMap());
        Arrays.stream(MeasurementUnitEnumDDD.values()).forEach(k -> {
            if (k == MeasurementUnitEnumDDD.UNRECOGNIZED) {
                return;
            }
            MeasurementUnitDDD build = MeasurementUnitDDD.build(k);
            if (build == null) {
                return;
            }
            result.put(build.getSymbol(), build);
        });
        return result;
    }

    private static MeasurementUnitDDD build(MeasurementUnitEnumDDD unitEnumDDD) {
        MeasurementUnitDDD kg = new MeasurementUnitDDD(unitEnumDDD.name(), unitEnumDDD.name(), unitEnumDDD.measurementUnitSystemEnum, unitEnumDDD);
        return kg;
    }

    public static JsonNode dddToTree(MeasurementUnitDDD ddd) {
        return OBJECT_MAPPER.valueToTree((Object)ddd);
    }

    public static MeasurementUnitDDD treeToValue(JsonNode tree) {
        try {
            MeasurementUnitDDD recipeDDD1 = (MeasurementUnitDDD)OBJECT_MAPPER.treeToValue((TreeNode)tree, MeasurementUnitDDD.class);
            return recipeDDD1;
        }
        catch (JsonProcessingException | NullPointerException e) {
            System.err.println("BAD MeasurementUnit JsonNode FORMAT . JsonNode was : " + tree.toPrettyString());
            return MeasurementUnitDDD.builder().setUnitSystem(MeasurementUnitSystemEnum.COMMONS).setStandardizedSymbol(MeasurementUnitEnumDDD.Other).build();
        }
    }

    public MeasurementUnitSystemEnum getUnitSystem() {
        return this.unitSystem;
    }

    public MeasurementUnitEnumDDD getStandardizedSymbol() {
        return this.standardizedSymbol;
    }

    public static MeasurementUnitDDDBuilder builder() {
        return new MeasurementUnitDDDBuilder();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public MeasurementUnitDDD(String symbol, String description, MeasurementUnitSystemEnum unitSystem, MeasurementUnitEnumDDD standardizedSymbol) {
        this.symbol = symbol;
        this.description = description;
        this.unitSystem = unitSystem;
        this.standardizedSymbol = standardizedSymbol;
    }

    public MeasurementUnitDDD() {
    }

    public MeasurementUnitDDD setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public MeasurementUnitDDD setDescription(String description) {
        this.description = description;
        return this;
    }

    public MeasurementUnitDDD setUnitSystem(MeasurementUnitSystemEnum unitSystem) {
        this.unitSystem = unitSystem;
        return this;
    }

    public MeasurementUnitDDD setStandardizedSymbol(MeasurementUnitEnumDDD standardizedSymbol) {
        this.standardizedSymbol = standardizedSymbol;
        return this;
    }

    public static class MeasurementUnitDDDBuilder {
        private String symbol;
        private String description;
        private MeasurementUnitSystemEnum unitSystem;
        private MeasurementUnitEnumDDD standardizedSymbol;

        MeasurementUnitDDDBuilder() {
        }

        public MeasurementUnitDDDBuilder setSymbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public MeasurementUnitDDDBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public MeasurementUnitDDDBuilder setUnitSystem(MeasurementUnitSystemEnum unitSystem) {
            this.unitSystem = unitSystem;
            return this;
        }

        public MeasurementUnitDDDBuilder setStandardizedSymbol(MeasurementUnitEnumDDD standardizedSymbol) {
            this.standardizedSymbol = standardizedSymbol;
            return this;
        }

        public MeasurementUnitDDD build() {
            return new MeasurementUnitDDD(this.symbol, this.description, this.unitSystem, this.standardizedSymbol);
        }

        public String toString() {
            return "MeasurementUnitDDD.MeasurementUnitDDDBuilder(symbol=" + this.symbol + ", description=" + this.description + ", unitSystem=" + this.unitSystem + ", standardizedSymbol=" + this.standardizedSymbol + ")";
        }
    }
}

