/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.einvoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import ro.deversoft.odf.gearbox.common.CommonUtils;

public enum OrderEInvoiceStatusEnumDDD {
    UNRECOGNIZED(false, false, false),
    ORDER_HAS_NO_INVOICE(false, false, true),
    ORDER_DOES_NOT_NEED_EINVOICE(false, false, true),
    ORDER_EINVOICE_CANCELED(false, false, true),
    ORDER_NEEDS_EINVOICE(true, false, false),
    EINVOICE_STAGE_1_VALIDATED_BEFORE_SUBMISSION(true, false, false),
    EINVOICE_STAGE_1_SYNTAX_ERROR_BEFORE_SUBMISSION(true, true, true),
    EINVOICE_STAGE_1_BUSINESS_ERROR_BEFORE_SUBMISSION(true, true, true),
    EINVOICE_STAGE_2_UPLOADED_OK(true, false, false),
    EINVOICE_STAGE_2_UPLOAD_ERROR_PERMANENT(true, true, true),
    EINVOICE_STAGE_2_UPLOAD_ERROR_MUST_RETRY(true, true, false),
    EINVOICE_STAGE_3_VALIDATED_AFTER_SUBMISSION(true, false, true),
    EINVOICE_STAGE_3_SYNTAX_ERROR_AFTER_SUBMISSION(true, true, true),
    EINVOICE_STAGE_3_BUSINESS_ERROR_AFTER_SUBMISSION(true, true, true);

    boolean eInvoiceEnabled;
    boolean isError;
    boolean isFinalState;

    private OrderEInvoiceStatusEnumDDD(boolean eInvoiceEnabled, boolean isError, boolean isFinalState) {
        this.eInvoiceEnabled = eInvoiceEnabled;
        this.isError = isError;
        this.isFinalState = isFinalState;
    }

    public static List<OrderEInvoiceStatusEnumDDD> buildPendingEInvoiceStatuses() {
        return CommonUtils.listOf(EINVOICE_STAGE_2_UPLOADED_OK, EINVOICE_STAGE_2_UPLOAD_ERROR_MUST_RETRY);
    }

    public static List<OrderEInvoiceStatusEnumDDD> buildOrderEInvoiceErrorStatuses() {
        ArrayList<OrderEInvoiceStatusEnumDDD> result = new ArrayList<OrderEInvoiceStatusEnumDDD>();
        for (OrderEInvoiceStatusEnumDDD value : OrderEInvoiceStatusEnumDDD.values()) {
            if (!value.isError) continue;
            result.add(value);
        }
        return result;
    }

    public static List<OrderEInvoiceStatusEnumDDD> buildOrderEInvoiceAllEnabledStatusesUnlessFinalValidation() {
        List<OrderEInvoiceStatusEnumDDD> result = Arrays.asList(OrderEInvoiceStatusEnumDDD.values()).stream().filter(k -> k != EINVOICE_STAGE_3_VALIDATED_AFTER_SUBMISSION).collect(Collectors.toList());
        return result;
    }
}

