/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.promotion;

import java.util.HashMap;
import ro.deversoft.odf.gearbox.common.CommonUtils;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventDDD;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventFilters;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventOperationType;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventTopic;

public class PromotionBudgetSettlementDDD {
    ODFId venueId;
    double value;
    String description;
    String userEmailPattern;

    public GlobalEventDDD toGlobalEvent() {
        PromotionBudgetSettlementDDD ddd = this;
        GlobalEventFilters filters = GlobalEventFilters.builder().setVenueid(ddd.getVenueId().getUuidValue()).build();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("value", ddd.getValue());
        payloadMap.put("description", ddd.getDescription());
        return GlobalEventDDD.builder().setOperationType(GlobalEventOperationType.SETTLEMENT).setTopic(GlobalEventTopic.USER_PROMOTION_BUGDET).setVenueId(ddd.getVenueId()).setFilters(filters).setPayload(CommonUtils.getJsonNodeFromMap(payloadMap)).build();
    }

    public static PromotionBudgetSettlementDDDBuilder builder() {
        return new PromotionBudgetSettlementDDDBuilder();
    }

    public ODFId getVenueId() {
        return this.venueId;
    }

    public double getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUserEmailPattern() {
        return this.userEmailPattern;
    }

    public PromotionBudgetSettlementDDD setVenueId(ODFId venueId) {
        this.venueId = venueId;
        return this;
    }

    public PromotionBudgetSettlementDDD setValue(double value) {
        this.value = value;
        return this;
    }

    public PromotionBudgetSettlementDDD setDescription(String description) {
        this.description = description;
        return this;
    }

    public PromotionBudgetSettlementDDD setUserEmailPattern(String userEmailPattern) {
        this.userEmailPattern = userEmailPattern;
        return this;
    }

    public PromotionBudgetSettlementDDD() {
    }

    public PromotionBudgetSettlementDDD(ODFId venueId, double value, String description, String userEmailPattern) {
        this.venueId = venueId;
        this.value = value;
        this.description = description;
        this.userEmailPattern = userEmailPattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromotionBudgetSettlementDDD)) {
            return false;
        }
        PromotionBudgetSettlementDDD other = (PromotionBudgetSettlementDDD)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromotionBudgetSettlementDDD;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PromotionBudgetSettlementDDD(super=" + super.toString() + ", venueId=" + this.getVenueId() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", userEmailPattern=" + this.getUserEmailPattern() + ")";
    }

    public static class PromotionBudgetSettlementDDDBuilder {
        private ODFId venueId;
        private double value;
        private String description;
        private String userEmailPattern;

        PromotionBudgetSettlementDDDBuilder() {
        }

        public PromotionBudgetSettlementDDDBuilder setVenueId(ODFId venueId) {
            this.venueId = venueId;
            return this;
        }

        public PromotionBudgetSettlementDDDBuilder setValue(double value) {
            this.value = value;
            return this;
        }

        public PromotionBudgetSettlementDDDBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public PromotionBudgetSettlementDDDBuilder setUserEmailPattern(String userEmailPattern) {
            this.userEmailPattern = userEmailPattern;
            return this;
        }

        public PromotionBudgetSettlementDDD build() {
            return new PromotionBudgetSettlementDDD(this.venueId, this.value, this.description, this.userEmailPattern);
        }

        public String toString() {
            return "PromotionBudgetSettlementDDD.PromotionBudgetSettlementDDDBuilder(venueId=" + this.venueId + ", value=" + this.value + ", description=" + this.description + ", userEmailPattern=" + this.userEmailPattern + ")";
        }
    }
}

