/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.recipe;

import lombok.NonNull;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.domain.ODFIdListDDD;
import ro.deversoft.odf.gearbox.common.domain.StringWithLanguageIndication;
import ro.deversoft.odf.gearbox.common.domain.recipe.RecipeDDD;

public class ComputeRecipeRequestDDD {
    @NonNull
    RecipeDDD recipe;
    Double price;
    ODFIdListDDD allergens;
    ODFIdListDDD additives;
    ODFIdListDDD filters;
    ODFIdListDDD proteins;
    ODFId sessionId;
    StringWithLanguageIndication productName;
    ODFId venueId;

    public static ComputeRecipeRequestDDDBuilder builder() {
        return new ComputeRecipeRequestDDDBuilder();
    }

    @NonNull
    public RecipeDDD getRecipe() {
        return this.recipe;
    }

    public Double getPrice() {
        return this.price;
    }

    public ODFIdListDDD getAllergens() {
        return this.allergens;
    }

    public ODFIdListDDD getAdditives() {
        return this.additives;
    }

    public ODFIdListDDD getFilters() {
        return this.filters;
    }

    public ODFIdListDDD getProteins() {
        return this.proteins;
    }

    public ODFId getSessionId() {
        return this.sessionId;
    }

    public StringWithLanguageIndication getProductName() {
        return this.productName;
    }

    public ODFId getVenueId() {
        return this.venueId;
    }

    public ComputeRecipeRequestDDD setRecipe(@NonNull RecipeDDD recipe) {
        if (recipe == null) {
            throw new NullPointerException("recipe is marked non-null but is null");
        }
        this.recipe = recipe;
        return this;
    }

    public ComputeRecipeRequestDDD setPrice(Double price) {
        this.price = price;
        return this;
    }

    public ComputeRecipeRequestDDD setAllergens(ODFIdListDDD allergens) {
        this.allergens = allergens;
        return this;
    }

    public ComputeRecipeRequestDDD setAdditives(ODFIdListDDD additives) {
        this.additives = additives;
        return this;
    }

    public ComputeRecipeRequestDDD setFilters(ODFIdListDDD filters) {
        this.filters = filters;
        return this;
    }

    public ComputeRecipeRequestDDD setProteins(ODFIdListDDD proteins) {
        this.proteins = proteins;
        return this;
    }

    public ComputeRecipeRequestDDD setSessionId(ODFId sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public ComputeRecipeRequestDDD setProductName(StringWithLanguageIndication productName) {
        this.productName = productName;
        return this;
    }

    public ComputeRecipeRequestDDD setVenueId(ODFId venueId) {
        this.venueId = venueId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputeRecipeRequestDDD)) {
            return false;
        }
        ComputeRecipeRequestDDD other = (ComputeRecipeRequestDDD)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        RecipeDDD this$recipe = this.getRecipe();
        RecipeDDD other$recipe = other.getRecipe();
        if (this$recipe == null ? other$recipe != null : !((Object)this$recipe).equals(other$recipe)) {
            return false;
        }
        ODFIdListDDD this$allergens = this.getAllergens();
        ODFIdListDDD other$allergens = other.getAllergens();
        if (this$allergens == null ? other$allergens != null : !((Object)this$allergens).equals(other$allergens)) {
            return false;
        }
        ODFIdListDDD this$additives = this.getAdditives();
        ODFIdListDDD other$additives = other.getAdditives();
        if (this$additives == null ? other$additives != null : !((Object)this$additives).equals(other$additives)) {
            return false;
        }
        ODFIdListDDD this$filters = this.getFilters();
        ODFIdListDDD other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        ODFIdListDDD this$proteins = this.getProteins();
        ODFIdListDDD other$proteins = other.getProteins();
        if (this$proteins == null ? other$proteins != null : !((Object)this$proteins).equals(other$proteins)) {
            return false;
        }
        ODFId this$sessionId = this.getSessionId();
        ODFId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        StringWithLanguageIndication this$productName = this.getProductName();
        StringWithLanguageIndication other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !((Object)this$productName).equals(other$productName)) {
            return false;
        }
        ODFId this$venueId = this.getVenueId();
        ODFId other$venueId = other.getVenueId();
        return !(this$venueId == null ? other$venueId != null : !((Object)this$venueId).equals(other$venueId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputeRecipeRequestDDD;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        RecipeDDD $recipe = this.getRecipe();
        result = result * 59 + ($recipe == null ? 43 : ((Object)$recipe).hashCode());
        ODFIdListDDD $allergens = this.getAllergens();
        result = result * 59 + ($allergens == null ? 43 : ((Object)$allergens).hashCode());
        ODFIdListDDD $additives = this.getAdditives();
        result = result * 59 + ($additives == null ? 43 : ((Object)$additives).hashCode());
        ODFIdListDDD $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        ODFIdListDDD $proteins = this.getProteins();
        result = result * 59 + ($proteins == null ? 43 : ((Object)$proteins).hashCode());
        ODFId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        StringWithLanguageIndication $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : ((Object)$productName).hashCode());
        ODFId $venueId = this.getVenueId();
        result = result * 59 + ($venueId == null ? 43 : ((Object)$venueId).hashCode());
        return result;
    }

    public ComputeRecipeRequestDDD(@NonNull RecipeDDD recipe, Double price, ODFIdListDDD allergens, ODFIdListDDD additives, ODFIdListDDD filters, ODFIdListDDD proteins, ODFId sessionId, StringWithLanguageIndication productName, ODFId venueId) {
        if (recipe == null) {
            throw new NullPointerException("recipe is marked non-null but is null");
        }
        this.recipe = recipe;
        this.price = price;
        this.allergens = allergens;
        this.additives = additives;
        this.filters = filters;
        this.proteins = proteins;
        this.sessionId = sessionId;
        this.productName = productName;
        this.venueId = venueId;
    }

    public ComputeRecipeRequestDDD() {
    }

    public String toString() {
        return "ComputeRecipeRequestDDD(recipe=" + this.getRecipe() + ", price=" + this.getPrice() + ", allergens=" + this.getAllergens() + ", additives=" + this.getAdditives() + ", filters=" + this.getFilters() + ", proteins=" + this.getProteins() + ", sessionId=" + this.getSessionId() + ", productName=" + this.getProductName() + ", venueId=" + this.getVenueId() + ")";
    }

    public static class ComputeRecipeRequestDDDBuilder {
        private RecipeDDD recipe;
        private Double price;
        private ODFIdListDDD allergens;
        private ODFIdListDDD additives;
        private ODFIdListDDD filters;
        private ODFIdListDDD proteins;
        private ODFId sessionId;
        private StringWithLanguageIndication productName;
        private ODFId venueId;

        ComputeRecipeRequestDDDBuilder() {
        }

        public ComputeRecipeRequestDDDBuilder setRecipe(@NonNull RecipeDDD recipe) {
            if (recipe == null) {
                throw new NullPointerException("recipe is marked non-null but is null");
            }
            this.recipe = recipe;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setPrice(Double price) {
            this.price = price;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setAllergens(ODFIdListDDD allergens) {
            this.allergens = allergens;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setAdditives(ODFIdListDDD additives) {
            this.additives = additives;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setFilters(ODFIdListDDD filters) {
            this.filters = filters;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setProteins(ODFIdListDDD proteins) {
            this.proteins = proteins;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setSessionId(ODFId sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setProductName(StringWithLanguageIndication productName) {
            this.productName = productName;
            return this;
        }

        public ComputeRecipeRequestDDDBuilder setVenueId(ODFId venueId) {
            this.venueId = venueId;
            return this;
        }

        public ComputeRecipeRequestDDD build() {
            return new ComputeRecipeRequestDDD(this.recipe, this.price, this.allergens, this.additives, this.filters, this.proteins, this.sessionId, this.productName, this.venueId);
        }

        public String toString() {
            return "ComputeRecipeRequestDDD.ComputeRecipeRequestDDDBuilder(recipe=" + this.recipe + ", price=" + this.price + ", allergens=" + this.allergens + ", additives=" + this.additives + ", filters=" + this.filters + ", proteins=" + this.proteins + ", sessionId=" + this.sessionId + ", productName=" + this.productName + ", venueId=" + this.venueId + ")";
        }
    }
}

