/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.recipe;

import java.util.ArrayList;
import java.util.List;
import net.andreinc.aleph.AlephFormatter;
import ro.deversoft.odf.gearbox.common.CommonUtils;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.domain.StringI18List;

public class RawMaterialCalculusBean {
    ODFId productId;
    ODFId sessionId;
    double totalQty;
    StringI18List productName;
    List<ODFId> allergensIds;
    List<ODFId> additivesIds;
    private static String humanFriendlyFormat = "Name: \"#{name}\" ProducID: \"#{id}\" TotalQty: \"#{totalqty}\"";

    public void addComposition(double qty) {
        this.totalQty += qty;
    }

    public void addAdditive(ODFId newAdditiveId) {
        if (!this.additivesIds.contains(newAdditiveId)) {
            this.additivesIds.add(newAdditiveId);
        }
    }

    public void addAllAdditives(List<ODFId> newAdditives) {
        newAdditives.stream().forEach(this::addAdditive);
    }

    public void addAllergen(ODFId newAllergenId) {
        if (!this.allergensIds.contains(newAllergenId)) {
            this.allergensIds.add(newAllergenId);
        }
    }

    public void addAllAllergens(List<ODFId> newAllergens) {
        newAllergens.stream().forEach(this::addAllergen);
    }

    public String getHumanFriendlyToString(String lang, String defaultLang) {
        String result = AlephFormatter.str((String)humanFriendlyFormat).arg("name", (Object)this.productName.getForLang(lang, defaultLang)).arg("totalqty", (Object)CommonUtils.roundDoubleUp(this.totalQty, 3)).arg("id", (Object)(this.productId != null ? this.productId.getUuidValue() : "null")).fmt();
        return result;
    }

    private static List<ODFId> $default$allergensIds() {
        return new ArrayList<ODFId>();
    }

    private static List<ODFId> $default$additivesIds() {
        return new ArrayList<ODFId>();
    }

    public static RawMaterialCalculusBeanBuilder builder() {
        return new RawMaterialCalculusBeanBuilder();
    }

    public ODFId getProductId() {
        return this.productId;
    }

    public ODFId getSessionId() {
        return this.sessionId;
    }

    public double getTotalQty() {
        return this.totalQty;
    }

    public StringI18List getProductName() {
        return this.productName;
    }

    public List<ODFId> getAllergensIds() {
        return this.allergensIds;
    }

    public List<ODFId> getAdditivesIds() {
        return this.additivesIds;
    }

    public RawMaterialCalculusBean setProductId(ODFId productId) {
        this.productId = productId;
        return this;
    }

    public RawMaterialCalculusBean setSessionId(ODFId sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public RawMaterialCalculusBean setTotalQty(double totalQty) {
        this.totalQty = totalQty;
        return this;
    }

    public RawMaterialCalculusBean setProductName(StringI18List productName) {
        this.productName = productName;
        return this;
    }

    public RawMaterialCalculusBean setAllergensIds(List<ODFId> allergensIds) {
        this.allergensIds = allergensIds;
        return this;
    }

    public RawMaterialCalculusBean setAdditivesIds(List<ODFId> additivesIds) {
        this.additivesIds = additivesIds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawMaterialCalculusBean)) {
            return false;
        }
        RawMaterialCalculusBean other = (RawMaterialCalculusBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTotalQty(), other.getTotalQty()) != 0) {
            return false;
        }
        ODFId this$productId = this.getProductId();
        ODFId other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !((Object)this$productId).equals(other$productId)) {
            return false;
        }
        ODFId this$sessionId = this.getSessionId();
        ODFId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        StringI18List this$productName = this.getProductName();
        StringI18List other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !((Object)this$productName).equals(other$productName)) {
            return false;
        }
        List<ODFId> this$allergensIds = this.getAllergensIds();
        List<ODFId> other$allergensIds = other.getAllergensIds();
        if (this$allergensIds == null ? other$allergensIds != null : !((Object)this$allergensIds).equals(other$allergensIds)) {
            return false;
        }
        List<ODFId> this$additivesIds = this.getAdditivesIds();
        List<ODFId> other$additivesIds = other.getAdditivesIds();
        return !(this$additivesIds == null ? other$additivesIds != null : !((Object)this$additivesIds).equals(other$additivesIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawMaterialCalculusBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalQty = Double.doubleToLongBits(this.getTotalQty());
        result = result * 59 + (int)($totalQty >>> 32 ^ $totalQty);
        ODFId $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : ((Object)$productId).hashCode());
        ODFId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        StringI18List $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : ((Object)$productName).hashCode());
        List<ODFId> $allergensIds = this.getAllergensIds();
        result = result * 59 + ($allergensIds == null ? 43 : ((Object)$allergensIds).hashCode());
        List<ODFId> $additivesIds = this.getAdditivesIds();
        result = result * 59 + ($additivesIds == null ? 43 : ((Object)$additivesIds).hashCode());
        return result;
    }

    public RawMaterialCalculusBean(ODFId productId, ODFId sessionId, double totalQty, StringI18List productName, List<ODFId> allergensIds, List<ODFId> additivesIds) {
        this.productId = productId;
        this.sessionId = sessionId;
        this.totalQty = totalQty;
        this.productName = productName;
        this.allergensIds = allergensIds;
        this.additivesIds = additivesIds;
    }

    public RawMaterialCalculusBean() {
        this.allergensIds = RawMaterialCalculusBean.$default$allergensIds();
        this.additivesIds = RawMaterialCalculusBean.$default$additivesIds();
    }

    public String toString() {
        return "RawMaterialCalculusBean(productId=" + this.getProductId() + ", sessionId=" + this.getSessionId() + ", totalQty=" + this.getTotalQty() + ", productName=" + this.getProductName() + ", allergensIds=" + this.getAllergensIds() + ", additivesIds=" + this.getAdditivesIds() + ")";
    }

    public static class RawMaterialCalculusBeanBuilder {
        private ODFId productId;
        private ODFId sessionId;
        private double totalQty;
        private StringI18List productName;
        private boolean allergensIds$set;
        private List<ODFId> allergensIds$value;
        private boolean additivesIds$set;
        private List<ODFId> additivesIds$value;

        RawMaterialCalculusBeanBuilder() {
        }

        public RawMaterialCalculusBeanBuilder setProductId(ODFId productId) {
            this.productId = productId;
            return this;
        }

        public RawMaterialCalculusBeanBuilder setSessionId(ODFId sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public RawMaterialCalculusBeanBuilder setTotalQty(double totalQty) {
            this.totalQty = totalQty;
            return this;
        }

        public RawMaterialCalculusBeanBuilder setProductName(StringI18List productName) {
            this.productName = productName;
            return this;
        }

        public RawMaterialCalculusBeanBuilder setAllergensIds(List<ODFId> allergensIds) {
            this.allergensIds$value = allergensIds;
            this.allergensIds$set = true;
            return this;
        }

        public RawMaterialCalculusBeanBuilder setAdditivesIds(List<ODFId> additivesIds) {
            this.additivesIds$value = additivesIds;
            this.additivesIds$set = true;
            return this;
        }

        public RawMaterialCalculusBean build() {
            List allergensIds$value = this.allergensIds$value;
            if (!this.allergensIds$set) {
                allergensIds$value = RawMaterialCalculusBean.$default$allergensIds();
            }
            List additivesIds$value = this.additivesIds$value;
            if (!this.additivesIds$set) {
                additivesIds$value = RawMaterialCalculusBean.$default$additivesIds();
            }
            return new RawMaterialCalculusBean(this.productId, this.sessionId, this.totalQty, this.productName, allergensIds$value, additivesIds$value);
        }

        public String toString() {
            return "RawMaterialCalculusBean.RawMaterialCalculusBeanBuilder(productId=" + this.productId + ", sessionId=" + this.sessionId + ", totalQty=" + this.totalQty + ", productName=" + this.productName + ", allergensIds$value=" + this.allergensIds$value + ", additivesIds$value=" + this.additivesIds$value + ")";
        }
    }
}

