/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.ChannelImageFilter;
import com.shfarr.ui.CompoundImageFilter;
import com.shfarr.ui.DesaturationImageFilter;
import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.ext.FhDefaults;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.RGBImageFilter;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FhButtonUI
extends BasicButtonUI {
    static ChannelImageFilter rolloverFilter = new ChannelImageFilter(1.0, 0.1, 0.1, 0.1);
    static CompoundImageFilter normalFilter = new CompoundImageFilter(new RGBImageFilter[]{new DesaturationImageFilter(1.0), new ChannelImageFilter(1.0, 0.1, 0.1, 0.1)});
    static CompoundImageFilter disabledFilter = new CompoundImageFilter(new RGBImageFilter[]{new DesaturationImageFilter(1.0), new ChannelImageFilter(0.3, 0.0, 0.0, 0.0)});
    private static BasicButtonListener sharedButtonListener;

    public static ComponentUI createUI(JComponent c) {
        return new FhButtonUI();
    }

    public void installUI(JComponent jc) {
        super.installUI(jc);
        AbstractButton b = (AbstractButton)jc;
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c instanceof AbstractButton) {
            Dimension d = super.getPreferredSize(c);
            Insets i = ((AbstractButton)c).getMargin();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            return d;
        }
        return super.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        FHMultiMatrixBorder border;
        ThemeManager.instance().probeAntialiasing(g);
        FHMultiMatrixBorder fHMultiMatrixBorder = border = c.getBorder() instanceof FHMultiMatrixBorder ? (FHMultiMatrixBorder)c.getBorder() : null;
        if (border == null && c.getBorder() instanceof CompoundBorder) {
            if (((CompoundBorder)c.getBorder()).getInsideBorder() instanceof FHMultiMatrixBorder) {
                border = (FHMultiMatrixBorder)((CompoundBorder)c.getBorder()).getInsideBorder();
            } else if (((CompoundBorder)c.getBorder()).getOutsideBorder() instanceof FHMultiMatrixBorder) {
                border = (FHMultiMatrixBorder)((CompoundBorder)c.getBorder()).getOutsideBorder();
            }
        }
        if (border != null) {
            String key = null;
            AbstractButton b = (AbstractButton)c;
            key = b.isRolloverEnabled() ? (b.getModel().isPressed() ? "rollover.pressed" : (b.hasFocus() ? "focused.armed" : (b.getModel().isRollover() ? "rollover.armed" : "rollover"))) : (b.getModel().isPressed() || b.isSelected() ? "pressed" : (b.getModel().isArmed() || b.getModel().isRollover() ? (b.hasFocus() ? "focused.armed" : "armed") : (b.hasFocus() ? "focused" : (b instanceof JButton && ((JButton)b).isDefaultButton() ? "default" : "normal"))));
            border.selectMatrix(key);
        }
        super.paint(g, c);
        if ((!((AbstractButton)c).isRolloverEnabled() || ((AbstractButton)c).getModel().isRollover()) && ((AbstractButton)c).isContentAreaFilled()) {
            Texture texture;
            Insets i;
            Rectangle rect = new Rectangle(0, 0, c.getSize().width, c.getSize().height);
            Insets insets = i = c.getBorder() != null ? c.getBorder().getBorderInsets(c) : null;
            if (i != null) {
                rect.x += i.left;
                rect.y += i.top;
                rect.width -= i.left + i.right;
                rect.height -= i.top + i.bottom;
            }
            if ((texture = FhDefaults.getTextureFor(c)) != null && ThemeManager.instance().probeSmallTextures()) {
                texture.apply(rect, (Graphics2D)g, c);
            }
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Insets i = b.getBorder() != null ? b.getBorder().getBorderInsets(b) : null;
            Rectangle rect = b.getBounds();
            rect.x = 0;
            rect.y = 0;
            g.setColor(UIManager.getColor("Button.backgroundPressed"));
            g.fillRect(rect.x + i.left, rect.y + i.top, rect.width - i.left - i.right, rect.height - i.top - i.bottom);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        g.setColor(UIManager.getColor("Component.absoluteHighlight"));
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
        Color color = c.getForeground();
        if (FhDefaults.getTextType(text) < 0) {
            color = ThemeManager.instance().getCurrentTheme().getColor("negative");
        }
        if (FhDefaults.getTextType(text) > 0) {
            color = ThemeManager.instance().getCurrentTheme().getColor("affirmative");
        }
        if (!model.isEnabled()) {
            color = new Color(GraphicsUtils.blend(color.getRGB(), c.getBackground().getRGB(), 0.5));
        }
        g.setColor(color);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        if (ThemeManager.instance().getPreferences().isManageButtonIcons() && b.getIcon() != null && b.getIcon() instanceof ImageIcon) {
            if (!b.isEnabled()) {
                GraphicsUtils.applyFilter((ImageIcon)b.getIcon(), (RGBImageFilter)disabledFilter).paintIcon(c, g, iconRect.x, iconRect.y);
            } else if (b.isRolloverEnabled() && b.getRolloverIcon() == null) {
                if (b.getModel().isRollover()) {
                    b.getIcon().paintIcon(c, g, iconRect.x, iconRect.y);
                } else {
                    GraphicsUtils.applyFilter((ImageIcon)b.getIcon(), (RGBImageFilter)normalFilter).paintIcon(c, g, iconRect.x, iconRect.y);
                }
            } else if (b.getModel().isRollover() && b.getRolloverIcon() == null) {
                GraphicsUtils.applyFilter((ImageIcon)b.getIcon(), (RGBImageFilter)rolloverFilter).paintIcon(c, g, iconRect.x, iconRect.y);
            } else {
                b.getIcon().paintIcon(c, g, iconRect.x, iconRect.y);
            }
        } else {
            super.paintIcon(g, c, iconRect);
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        if (sharedButtonListener == null) {
            sharedButtonListener = new FhButtonListener(b);
        }
        return sharedButtonListener;
    }

    public static class FhButtonListener
    extends BasicButtonListener {
        public FhButtonListener(AbstractButton ab) {
            super(ab);
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (!SwingUtilities.isLeftMouseButton(e)) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            model.setRollover(false);
            model.setArmed(false);
        }
    }
}

