/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class FhDesktopIconUI
extends BasicDesktopIconUI {
    private JButton button;
    private TitleListener titleListener;
    private int width;

    public static ComponentUI createUI(JComponent cmp) {
        return new FhDesktopIconUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String title = this.frame.getTitle();
        this.button = new JButton(title, icon);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FhDesktopIconUI.this.deiconize();
            }
        });
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        int buttonH = this.button.getPreferredSize().height;
        this.button.setDefaultCapable(false);
        this.desktopIcon.setLayout(new BorderLayout(0, 0));
        this.desktopIcon.add((Component)this.button, "Center");
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.desktopIcon.setOpaque(true);
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        Texture texture = (Texture)UIManager.getDefaults().get("DesktopIcon.texture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(0, 0, c.getSize().width, c.getSize().height), (Graphics2D)g, c);
        }
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("title")) {
                FhDesktopIconUI.this.button.setText((String)e.getNewValue());
            }
            if (e.getPropertyName().equals("frameIcon")) {
                FhDesktopIconUI.this.button.setIcon((Icon)e.getNewValue());
            }
        }
    }
}

