/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme;

import com.shfarr.io.IOUtils;
import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.borders.FhMatrixBorder;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ColorPalette;
import com.shfarr.ui.plaf.fh.theme.Palette;
import com.shfarr.ui.plaf.fh.theme.TexturePalette;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import com.shfarr.ui.plaf.fh.theme.persist.LafObjectDecoder;
import com.shfarr.ui.plaf.fh.theme.persist.LafObjectEncoder;
import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Theme {
    protected String name = null;
    protected ColorPalette alternateColorPalette;
    protected ColorPalette colorPalette;
    protected TexturePalette texturePalette;
    protected Palette fontPalette;
    protected Palette matrixPalette;
    protected Palette metaPalette;
    protected String description = "missing";
    protected String version = "?";
    protected String author = "anonimous";
    protected boolean editable = false;
    protected List changeListeners = null;

    public Theme(String name) throws Exception {
        this.name = name;
        try {
            this.metaPalette();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        this.changeListeners = new Vector();
    }

    public Palette fontPalette() {
        if (this.fontPalette == null) {
            this.loadFonts();
        }
        return this.fontPalette;
    }

    public ColorPalette colorPalette() {
        if (this.colorPalette == null) {
            this.loadColors();
        }
        return this.colorPalette;
    }

    public Palette matrixPalette() {
        if (this.matrixPalette == null) {
            this.loadMatrices();
        }
        return this.matrixPalette;
    }

    public Palette texturePalette() {
        if (this.texturePalette == null) {
            this.loadTextures();
        }
        return this.texturePalette;
    }

    public Palette metaPalette() {
        if (this.metaPalette == null) {
            this.loadMeta();
        }
        return this.metaPalette;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor(String name) {
        try {
            int rgb = 0;
            if (ThemeManager.instance().getPreferences().isUsingCustomBaseColor()) {
                if (this.alternateColorPalette == null) {
                    this.alternateColorPalette = this.colorPalette().derivePalette(ThemeManager.instance().getPreferences().getCustomBaseColor());
                }
                rgb = this.alternateColorPalette.getColor(Integer.parseInt(name)).getRGB();
            } else {
                rgb = this.colorPalette().getColor(Integer.parseInt(name)).getRGB();
            }
            if (ThemeManager.instance().getPreferences().getBrightness() > 0) {
                rgb = GraphicsUtils.brighter(rgb, (float)ThemeManager.instance().getPreferences().getBrightness() / 300.0f);
            } else if (ThemeManager.instance().getPreferences().getBrightness() < 0) {
                rgb = GraphicsUtils.darker(rgb, (float)(-ThemeManager.instance().getPreferences().getBrightness()) / 300.0f);
            }
            return new Color(GraphicsUtils.desaturate(rgb, 1.0f - (float)ThemeManager.instance().getPreferences().getSaturation() / 100.0f));
        }
        catch (Exception e) {
            return (ThemeManager.instance().getPreferences().isUsingCustomBaseColor() ? this.alternateColorPalette : this.colorPalette()).getColor(name);
        }
    }

    public Texture getTexture(String name) {
        Texture tex = (Texture)this.texturePalette().get(name);
        if (tex != null) {
            tex.setTheme(this);
        }
        return tex;
    }

    public Font getFont(String name) {
        Font f = (Font)this.fontPalette().get(name);
        if (ThemeManager.instance().getPreferences().isStrengthenFonts()) {
            return f.deriveFont(1, (float)(f.getSize() * ThemeManager.instance().getPreferences().getFontSizeAdjustment()) / 100.0f);
        }
        return f.deriveFont((float)(f.getSize() * ThemeManager.instance().getPreferences().getFontSizeAdjustment()) / 100.0f);
    }

    public Border getBorder(String str) {
        try {
            return new FhMatrixBorder((String[][])this.matrixPalette().get("borders/." + str));
        }
        catch (Throwable e) {
            return new FhMatrixBorder(new String[][]{new String[0]});
        }
    }

    public Border getBorder(String component, String[] states) {
        Object[] subborders = new Object[states.length];
        int i = 0;
        while (i < states.length) {
            subborders[i] = this.getBorder(String.valueOf(component) + (states[i].equals("normal") ? "" : "." + states[i]));
            ++i;
        }
        try {
            return new FHMultiMatrixBorder(states, subborders);
        }
        catch (Error e) {
            return null;
        }
    }

    public void loadColors() {
        try {
            this.colorPalette = (ColorPalette)IOUtils.xml2Object(this.getResourceURL(".colors.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void loadFonts() {
        try {
            this.fontPalette = (Palette)IOUtils.xml2Object(this.getResourceURL(".fonts.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void loadMatrices() {
        try {
            this.matrixPalette = (Palette)IOUtils.xml2Object(this.getResourceURL(".matrices.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void loadTextures() {
        try {
            this.texturePalette = (TexturePalette)IOUtils.xml2Object(this.getResourceURL(".textures.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void loadMeta() {
        try {
            this.metaPalette = (Palette)IOUtils.xml2Object(this.getResourceURL(".meta.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public Collection themeFiles() {
        try {
            return (Collection)IOUtils.xml2Object(this.getResourceURL(".files.xml"), new LafObjectDecoder());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void saveColors() {
        IOUtils.object2File(this.colorPalette(), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + this.getName() + "/.colors.xml", new LafObjectEncoder());
        this.fireThemeChanged();
    }

    public void saveFonts() {
        IOUtils.object2File(this.fontPalette(), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + this.getName() + "/.fonts.xml", new LafObjectEncoder());
        this.fireThemeChanged();
    }

    public void saveMatrices() {
        IOUtils.object2File(this.matrixPalette(), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + this.getName() + "/.matrices.xml", new LafObjectEncoder());
        this.fireThemeChanged();
    }

    public void saveTextures() {
        IOUtils.object2File(this.texturePalette(), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + this.getName() + "/.textures.xml", new LafObjectEncoder());
        this.fireThemeChanged();
    }

    public void saveMeta() {
        IOUtils.object2File(this.metaPalette(), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + this.getName() + "/.meta.xml", new LafObjectEncoder());
        this.fireThemeChanged();
    }

    protected void fireThemeChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        int i = 0;
        while (i < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.get(i)).stateChanged(ce);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener chl) {
        if (!this.changeListeners.contains(chl)) {
            this.changeListeners.add(chl);
        }
    }

    public void removeChangeListener(ChangeListener chl) {
        this.changeListeners.remove(chl);
    }

    public URL getResourceURL(String res) {
        URL url = ClassLoader.getSystemResource(String.valueOf(this.getName()) + "/" + res);
        if (url == null) {
            try {
                if (!this.getName().endsWith(".jar")) {
                    url = new URL("file:///" + ThemeManager.instance().getPreferences().getThemeDirectory() + "/" + this.getName() + "/" + res);
                    this.setEditable(true);
                } else {
                    url = new URL("jar:file:///" + ThemeManager.instance().getPreferences().getThemeDirectory() + "/" + this.getName() + "!/" + res);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public String getAuthor() {
        return (String)this.metaPalette().get("Author");
    }

    public String getDescription() {
        return (String)this.metaPalette().get("Description");
    }

    public String getVersion() {
        return (String)this.metaPalette().get("Version");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

