/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class UngroupAction
extends UndoableAction {
    private static final long serialVersionUID = -5373541224263019450L;

    public UngroupAction() {
    }

    public UngroupAction(String name) {
        this(name, false);
    }

    public UngroupAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public UngroupAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public UngroupAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Vector<Fig> ungroupedItems = new Vector<Fig>();
        Editor currentEditor = Globals.curEditor();
        Vector selectedFigs = currentEditor.getSelectionManager().getFigs();
        Enumeration eachDE = selectedFigs.elements();
        while (eachDE.hasMoreElements()) {
            Object o = eachDE.nextElement();
            if (!(o instanceof FigGroup)) continue;
            FigGroup fg = (FigGroup)o;
            Iterator it = fg.getFigs().iterator();
            while (it.hasNext()) {
                Fig f = (Fig)it.next();
                currentEditor.add(f);
                ungroupedItems.addElement(f);
            }
            currentEditor.remove(fg);
        }
        currentEditor.getSelectionManager().deselectAll();
        currentEditor.getSelectionManager().select(ungroupedItems);
    }
}

