/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final TranscodingHints.Key KEY_INDEXED = new BooleanKey();

    public PNGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        PNGEncodeParam params;
        OutputStream ostream = output.getOutputStream();
        if (ostream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            int w = img.getWidth();
            int h = img.getHeight();
            DataBufferInt biDB = (DataBufferInt)img.getRaster().getDataBuffer();
            int scanStride = ((SinglePixelPackedSampleModel)img.getSampleModel()).getScanlineStride();
            int dbOffset = biDB.getOffset();
            int[] pixels = biDB.getBankData()[0];
            int p = dbOffset;
            int adjust = scanStride - w;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int pel = 0;
            int i = 0;
            while (i < h) {
                int j = 0;
                while (j < w) {
                    pel = pixels[p];
                    a = pel >> 24 & 0xFF;
                    r = pel >> 16 & 0xFF;
                    g = pel >> 8 & 0xFF;
                    b = pel & 0xFF;
                    r = (255 * (255 - a) + a * r) / 255;
                    g = (255 * (255 - a) + a * g) / 255;
                    b = (255 * (255 - a) + a * b) / 255;
                    pixels[p++] = a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                    ++j;
                }
                p += adjust;
                ++i;
            }
        }
        if (this.hints.containsKey(KEY_INDEXED) && ((Boolean)this.hints.get(KEY_INDEXED)).booleanValue()) {
            img = IndexImage.getIndexedImage(img);
        }
        if ((params = PNGEncodeParam.getDefaultEncodeParam(img)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)params).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (this.hints.containsKey(KEY_GAMMA)) {
            params.setGamma(((Float)this.hints.get(KEY_GAMMA)).floatValue());
        }
        params.setSRGBIntent(0);
        float PixSzMM = this.userAgent.getPixelUnitToMillimeter();
        int numPix = (int)((double)(1000.0f / PixSzMM) + 0.5);
        params.setPhysicalDimension(numPix, numPix, 1);
        try {
            PNGImageEncoder pngEncoder = new PNGImageEncoder(ostream, params);
            pngEncoder.encode(img);
            ostream.close();
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }
}

