/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.internal.Excluder$1;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final Excluder DEFAULT = new Excluder();
    public double version = -1.0;
    public int modifiers = 136;
    public boolean serializeInnerClasses = true;
    public boolean requireExpose;
    public List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    public List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected final Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public final Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        this.clone().version = d2;
        return excluder;
    }

    public final Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        this.clone().modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public final Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        this.clone().serializeInnerClasses = false;
        return excluder;
    }

    public final Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        this.clone().requireExpose = true;
        return excluder;
    }

    public final Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl2, boolean bl3) {
        Excluder excluder = this.clone();
        if (bl2) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl3) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        boolean bl2 = this.excludeClass(clazz, true);
        boolean bl3 = this.excludeClass(clazz, false);
        if (!bl2 && !bl3) {
            return null;
        }
        return new Excluder$1(this, bl3, bl2, gson, typeToken);
    }

    public final boolean excludeField(Field object, boolean bl2) {
        List<ExclusionStrategy> list;
        if ((this.modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.a(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
            return true;
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((list = ((Field)object).getAnnotation(Expose.class)) == null || (bl2 ? !list.serialize() : !list.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.b(((Field)object).getType())) {
            return true;
        }
        if (Excluder.a(((Field)object).getType())) {
            return true;
        }
        list = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!list.isEmpty()) {
            object = new FieldAttributes((Field)object);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((ExclusionStrategy)iterator.next()).shouldSkipField((FieldAttributes)object)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean excludeClass(Class<?> clazz, boolean bl2) {
        if (this.version != -1.0 && !this.a(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.b(clazz)) {
            return true;
        }
        if (Excluder.a(clazz)) {
            return true;
        }
        Iterator<ExclusionStrategy> iterator = (bl2 ? this.serializationStrategies : this.deserializationStrategies).iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private static boolean b(Class<?> clazz) {
        return clazz.isMemberClass() && !Excluder.c(clazz);
    }

    private static boolean c(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean a(Since since, Until until) {
        return this.a(since) && this.a(until);
    }

    private boolean a(Since since) {
        return since == null || !(since.value() > this.version);
    }

    private boolean a(Until until) {
        return until == null || !(until.value() <= this.version);
    }
}

