/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.stream.JsonReader$1;
import com.google.gson.stream.JsonReader$2;
import com.google.gson.stream.JsonScope;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.google.gson.stream.StringPool;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JsonReader
implements Closeable {
    private static final char[] a = ")]}'\n".toCharArray();
    private final StringPool a;
    private final Reader a;
    private boolean a;
    private final char[] b;
    private int a;
    private int b;
    private int c = 1;
    private int d = 1;
    private JsonScope[] a;
    private int e = 0;
    private JsonToken a;
    private String a = 0;
    private String b;
    private int f;
    private int g;
    private boolean b = 0;

    public JsonReader(Reader reader) {
        this.a = new JsonScope[32];
        this.a(JsonScope.EMPTY_DOCUMENT);
        this.b = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.a = reader;
    }

    public final void setLenient(boolean bl2) {
        this.a = bl2;
    }

    public final boolean isLenient() {
        return this.a;
    }

    public void beginArray() {
        this.a(JsonToken.BEGIN_ARRAY);
    }

    public void endArray() {
        this.a(JsonToken.END_ARRAY);
    }

    public void beginObject() {
        this.a(JsonToken.BEGIN_OBJECT);
    }

    public void endObject() {
        this.a(JsonToken.END_OBJECT);
    }

    private void a(JsonToken jsonToken) {
        this.peek();
        if (this.a != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()) + " at line " + this.a() + " column " + this.b());
        }
        this.a();
    }

    public boolean hasNext() {
        this.peek();
        return this.a != JsonToken.END_OBJECT && this.a != JsonToken.END_ARRAY;
    }

    /*
     * Unable to fully structure code
     */
    public JsonToken peek() {
        if (this.a != null) {
            return this.a;
        }
        switch (JsonReader$2.a[this.a[this.e - 1].ordinal()]) {
            case 1: {
                if (this.a) {
                    var1_1 = this;
                    var1_1.a(true);
                    --var1_1.a;
                    if (var1_1.a + JsonReader.a.length <= var1_1.b || var1_1.a(JsonReader.a.length)) {
                        for (var2_3 = 0; var2_3 < JsonReader.a.length; ++var2_3) {
                            if (var1_1.b[var1_1.a + var2_3] == JsonReader.a[var2_3]) {
                                continue;
                            }
                            ** GOTO lbl16
                        }
                        var1_1.a += JsonReader.a.length;
                    }
                }
lbl16:
                // 6 sources

                this.a[this.e - 1] = JsonScope.NONEMPTY_DOCUMENT;
                var1_1 = this.b();
                if (!this.a && this.a != JsonToken.BEGIN_ARRAY && this.a != JsonToken.BEGIN_OBJECT) {
                    throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)this.a + " at line " + this.a() + " column " + this.b());
                }
                return var1_1;
            }
            case 2: {
                return this.a(true);
            }
            case 3: {
                return this.a(false);
            }
            case 4: {
                return this.b(true);
            }
            case 5: {
                var1_2 = this;
                switch (var1_2.a(true)) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        var1_2.a();
                        if (var1_2.a >= var1_2.b && !var1_2.a(1) || var1_2.b[var1_2.a] != '>') break;
                        ++var1_2.a;
                        break;
                    }
                    default: {
                        throw var1_2.a("Expected ':'");
                    }
                }
                var1_2.a[var1_2.e - 1] = JsonScope.NONEMPTY_OBJECT;
                return var1_2.b();
            }
            case 6: {
                return this.b(false);
            }
            case 7: {
                if (this.a(false) == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.a;
                if (!this.a) {
                    throw this.a("Expected EOF");
                }
                return this.b();
            }
            case 8: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private JsonToken a() {
        this.peek();
        JsonToken jsonToken = this.a;
        this.a = null;
        this.b = null;
        this.a = null;
        return jsonToken;
    }

    public String nextName() {
        this.peek();
        if (this.a != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.a() + " column " + this.b());
        }
        String string = this.a;
        this.a();
        return string;
    }

    public String nextString() {
        this.peek();
        if (this.a != JsonToken.STRING && this.a != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.a() + " column " + this.b());
        }
        String string = this.b;
        this.a();
        return string;
    }

    public boolean nextBoolean() {
        this.peek();
        if (this.a != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.a) + " at line " + this.a() + " column " + this.b());
        }
        boolean bl2 = this.b == "true";
        this.a();
        return bl2;
    }

    public void nextNull() {
        this.peek();
        if (this.a != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.a) + " at line " + this.a() + " column " + this.b());
        }
        this.a();
    }

    public double nextDouble() {
        double d2;
        this.peek();
        if (this.a != JsonToken.STRING && this.a != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.a) + " at line " + this.a() + " column " + this.b());
        }
        double d3 = Double.parseDouble(this.b);
        if (d2 >= 1.0 && this.b.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.b + " at line " + this.a() + " column " + this.b());
        }
        if (!this.a && (Double.isNaN(d3) || Double.isInfinite(d3))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + this.b + " at line " + this.a() + " column " + this.b());
        }
        this.a();
        return d3;
    }

    public long nextLong() {
        long l2;
        block4: {
            this.peek();
            if (this.a != JsonToken.STRING && this.a != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.a) + " at line " + this.a() + " column " + this.b());
            }
            try {
                l2 = Long.parseLong(this.b);
            }
            catch (NumberFormatException numberFormatException) {
                double d2 = Double.parseDouble(this.b);
                l2 = (long)d2;
                if ((double)l2 == d2) break block4;
                throw new NumberFormatException("Expected a long but was " + this.b + " at line " + this.a() + " column " + this.b());
            }
        }
        if (l2 >= 1L && this.b.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.b + " at line " + this.a() + " column " + this.b());
        }
        this.a();
        return l2;
    }

    public int nextInt() {
        int n2;
        block4: {
            this.peek();
            if (this.a != JsonToken.STRING && this.a != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.a) + " at line " + this.a() + " column " + this.b());
            }
            try {
                n2 = Integer.parseInt(this.b);
            }
            catch (NumberFormatException numberFormatException) {
                double d2 = Double.parseDouble(this.b);
                n2 = (int)d2;
                if ((double)n2 == d2) break block4;
                throw new NumberFormatException("Expected an int but was " + this.b + " at line " + this.a() + " column " + this.b());
            }
        }
        if ((long)n2 >= 1L && this.b.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.b + " at line " + this.a() + " column " + this.b());
        }
        this.a();
        return n2;
    }

    @Override
    public void close() {
        this.b = null;
        this.a = null;
        this.a[0] = JsonScope.CLOSED;
        this.e = 1;
        this.a.close();
    }

    public void skipValue() {
        this.b = true;
        try {
            int n2 = 0;
            do {
                JsonToken jsonToken;
                if ((jsonToken = this.a()) == JsonToken.BEGIN_ARRAY || jsonToken == JsonToken.BEGIN_OBJECT) {
                    ++n2;
                    continue;
                }
                if (jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT) continue;
                --n2;
            } while (n2 != 0);
            return;
        }
        finally {
            this.b = false;
        }
    }

    private void a(JsonScope jsonScope) {
        if (this.e == this.a.length) {
            JsonScope[] jsonScopeArray = new JsonScope[this.e << 1];
            System.arraycopy(this.a, 0, jsonScopeArray, 0, this.e);
            this.a = jsonScopeArray;
        }
        this.a[this.e++] = jsonScope;
    }

    private JsonToken a(boolean bl2) {
        if (bl2) {
            this.a[this.e - 1] = JsonScope.NONEMPTY_ARRAY;
        } else {
            switch (this.a(true)) {
                case 93: {
                    --this.e;
                    this.a = JsonToken.END_ARRAY;
                    return this.a;
                }
                case 59: {
                    this.a();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.a("Unterminated array");
                }
            }
        }
        switch (this.a(true)) {
            case 93: {
                if (bl2) {
                    --this.e;
                    this.a = JsonToken.END_ARRAY;
                    return this.a;
                }
            }
            case 44: 
            case 59: {
                this.a();
                --this.a;
                this.b = "null";
                this.a = JsonToken.NULL;
                return this.a;
            }
        }
        --this.a;
        return this.b();
    }

    private JsonToken b(boolean bl2) {
        if (bl2) {
            switch (this.a(true)) {
                case 125: {
                    --this.e;
                    this.a = JsonToken.END_OBJECT;
                    return this.a;
                }
            }
            --this.a;
        } else {
            switch (this.a(true)) {
                case 125: {
                    --this.e;
                    this.a = JsonToken.END_OBJECT;
                    return this.a;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.a("Unterminated object");
                }
            }
        }
        int n2 = this.a(true);
        switch (n2) {
            case 39: {
                this.a();
            }
            case 34: {
                this.a = this.a((char)n2);
                break;
            }
            default: {
                this.a();
                --this.a;
                this.a = this.a(false);
                if (this.a.length() != 0) break;
                throw this.a("Expected name");
            }
        }
        this.a[this.e - 1] = JsonScope.DANGLING_NAME;
        this.a = JsonToken.NAME;
        return this.a;
    }

    private JsonToken b() {
        int n2 = this.a(true);
        switch (n2) {
            case 123: {
                this.a(JsonScope.EMPTY_OBJECT);
                this.a = JsonToken.BEGIN_OBJECT;
                return this.a;
            }
            case 91: {
                this.a(JsonScope.EMPTY_ARRAY);
                this.a = JsonToken.BEGIN_ARRAY;
                return this.a;
            }
            case 39: {
                this.a();
            }
            case 34: {
                this.b = this.a((char)n2);
                this.a = JsonToken.STRING;
                return this.a;
            }
        }
        --this.a;
        return this.c();
    }

    private boolean a(int n2) {
        int n3;
        char[] cArray = this.b;
        int n4 = this.c;
        int n5 = this.d;
        int n6 = this.a;
        for (n3 = 0; n3 < n6; ++n3) {
            if (cArray[n3] == '\n') {
                ++n4;
                n5 = 1;
                continue;
            }
            ++n5;
        }
        this.c = n4;
        this.d = n5;
        if (this.b != this.a) {
            this.b -= this.a;
            System.arraycopy(cArray, this.a, cArray, 0, this.b);
        } else {
            this.b = 0;
        }
        this.a = 0;
        while ((n3 = this.a.read(cArray, this.b, 1024 - this.b)) != -1) {
            this.b += n3;
            if (this.c == 1 && this.d == 1 && this.b > 0 && cArray[0] == '\ufeff') {
                ++this.a;
                --this.d;
            }
            if (this.b < n2) continue;
            return true;
        }
        return false;
    }

    private int a() {
        int n2 = this.c;
        for (int i2 = 0; i2 < this.a; ++i2) {
            if (this.b[i2] != '\n') continue;
            ++n2;
        }
        return n2;
    }

    private int b() {
        int n2 = this.d;
        for (int i2 = 0; i2 < this.a; ++i2) {
            if (this.b[i2] == '\n') {
                n2 = 1;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private int a(boolean bl2) {
        block15: {
            char c2;
            char[] cArray = this.b;
            int n2 = this.a;
            int n3 = this.b;
            block9: while (true) {
                if (n2 == n3) {
                    this.a = n2;
                    if (!this.a(1)) break block15;
                    n2 = this.a;
                    n3 = this.b;
                }
                c2 = cArray[n2++];
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                    case '/': {
                        this.a = n2;
                        if (n2 == n3) {
                            --this.a;
                            n2 = this.a(2) ? 1 : 0;
                            ++this.a;
                            if (n2 == 0) {
                                return c2;
                            }
                        }
                        this.a();
                        switch (cArray[this.a]) {
                            case '*': {
                                ++this.a;
                                if (!this.a("*/")) {
                                    throw this.a("Unterminated comment");
                                }
                                n2 = this.a + 2;
                                n3 = this.b;
                                continue block9;
                            }
                            case '/': {
                                ++this.a;
                                this.b();
                                n2 = this.a;
                                n3 = this.b;
                                continue block9;
                            }
                        }
                        return c2;
                    }
                    case '#': {
                        this.a = n2;
                        this.a();
                        this.b();
                        n2 = this.a;
                        n3 = this.b;
                        continue block9;
                    }
                }
                break;
            }
            this.a = n2;
            return c2;
        }
        if (bl2) {
            throw new EOFException("End of input at line " + this.a() + " column " + this.b());
        }
        return -1;
    }

    private void a() {
        if (!this.a) {
            throw this.a("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void b() {
        char c2;
        while ((this.a < this.b || this.a(1)) && (c2 = this.b[this.a++]) != '\r' && c2 != '\n') {
        }
    }

    private boolean a(String string) {
        while (this.a + string.length() <= this.b || this.a(string.length())) {
            block3: {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    if (this.b[this.a + i2] == string.charAt(i2)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.a;
        }
        return false;
    }

    private String a(char c2) {
        char[] cArray = this.b;
        StringBuilder stringBuilder = null;
        do {
            int n2 = this.a;
            int n3 = this.b;
            int n4 = n2;
            while (n2 < n3) {
                char c3;
                if ((c3 = cArray[n2++]) == c2) {
                    this.a = n2;
                    if (this.b) {
                        return "skipped!";
                    }
                    if (stringBuilder == null) {
                        return this.a.get(cArray, n4, n2 - n4 - 1);
                    }
                    stringBuilder.append(cArray, n4, n2 - n4 - 1);
                    return stringBuilder.toString();
                }
                if (c3 != '\\') continue;
                this.a = n2;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(cArray, n4, n2 - n4 - 1);
                stringBuilder.append(this.a());
                n2 = this.a;
                n3 = this.b;
                n4 = n2;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.a = n2;
        } while (this.a(1));
        throw this.a("Unterminated string");
    }

    private String a(boolean bl2) {
        String string;
        StringBuilder stringBuilder = null;
        this.f = -1;
        this.g = 0;
        int n2 = 0;
        block4: while (true) {
            if (this.a + n2 < this.b) {
                switch (this.b[this.a + n2]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.a();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
                continue;
            }
            if (n2 < 1024) {
                if (this.a(n2 + 1)) continue;
                this.b[this.b] = '\u0000';
                break;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.b, this.a, n2);
            this.g += n2;
            this.a += n2;
            n2 = 0;
            if (!this.a(1)) break;
        }
        if (bl2 && stringBuilder == null) {
            this.f = this.a;
            string = null;
        } else if (this.b) {
            string = "skipped!";
        } else if (stringBuilder == null) {
            string = this.a.get(this.b, this.a, n2);
        } else {
            stringBuilder.append(this.b, this.a, n2);
            string = stringBuilder.toString();
        }
        this.g += n2;
        this.a += n2;
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at line " + this.a() + " column " + this.b();
    }

    private char a() {
        if (this.a == this.b && !this.a(1)) {
            throw this.a("Unterminated escape sequence");
        }
        char c2 = this.b[this.a++];
        switch (c2) {
            case 'u': {
                int n2;
                if (this.a + 4 > this.b && !this.a(4)) {
                    throw this.a("Unterminated escape sequence");
                }
                c2 = '\u0000';
                int n3 = n2 + 4;
                for (n2 = this.a; n2 < n3; ++n2) {
                    char c3 = this.b[n2];
                    c2 = (char)(c2 << 4);
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)(c2 + (c3 - 48));
                        continue;
                    }
                    if (c3 >= 'a' && c3 <= 'f') {
                        c2 = (char)(c2 + (c3 - 97 + 10));
                        continue;
                    }
                    if (c3 >= 'A' && c3 <= 'F') {
                        c2 = (char)(c2 + (c3 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + this.a.get(this.b, this.a, 4));
                }
                this.a += 4;
                return c2;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c2;
    }

    private JsonToken c() {
        this.b = this.a(true);
        if (this.g == 0) {
            throw this.a("Expected literal value");
        }
        this.a = this.d();
        if (this.a == JsonToken.STRING) {
            this.a();
        }
        return this.a;
    }

    private JsonToken d() {
        if (this.f == -1) {
            return JsonToken.STRING;
        }
        if (!(this.g != 4 || 'n' != this.b[this.f] && 'N' != this.b[this.f] || 'u' != this.b[this.f + 1] && 'U' != this.b[this.f + 1] || 'l' != this.b[this.f + 2] && 'L' != this.b[this.f + 2] || 'l' != this.b[this.f + 3] && 'L' != this.b[this.f + 3])) {
            this.b = "null";
            return JsonToken.NULL;
        }
        if (!(this.g != 4 || 't' != this.b[this.f] && 'T' != this.b[this.f] || 'r' != this.b[this.f + 1] && 'R' != this.b[this.f + 1] || 'u' != this.b[this.f + 2] && 'U' != this.b[this.f + 2] || 'e' != this.b[this.f + 3] && 'E' != this.b[this.f + 3])) {
            this.b = "true";
            return JsonToken.BOOLEAN;
        }
        if (!(this.g != 5 || 'f' != this.b[this.f] && 'F' != this.b[this.f] || 'a' != this.b[this.f + 1] && 'A' != this.b[this.f + 1] || 'l' != this.b[this.f + 2] && 'L' != this.b[this.f + 2] || 's' != this.b[this.f + 3] && 'S' != this.b[this.f + 3] || 'e' != this.b[this.f + 4] && 'E' != this.b[this.f + 4])) {
            this.b = "false";
            return JsonToken.BOOLEAN;
        }
        this.b = this.a.get(this.b, this.f, this.g);
        return JsonReader.a(this.b, this.f, this.g);
    }

    private static JsonToken a(char[] cArray, int n2, int n3) {
        int n4 = n2;
        char c2 = cArray[n4];
        if (c2 == '-') {
            c2 = cArray[++n4];
        }
        if (c2 == '0') {
            c2 = cArray[++n4];
        } else if (c2 >= '1' && c2 <= '9') {
            c2 = cArray[++n4];
            while (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
            }
        } else {
            return JsonToken.STRING;
        }
        if (c2 == '.') {
            c2 = cArray[++n4];
            while (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
            }
        }
        if (c2 == 'e' || c2 == 'E') {
            if ((c2 = cArray[++n4]) == '+' || c2 == '-') {
                c2 = cArray[++n4];
            }
            if (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
                while (c2 >= '0' && c2 <= '9') {
                    c2 = cArray[++n4];
                }
            } else {
                return JsonToken.STRING;
            }
        }
        if (n4 == n2 + n3) {
            return JsonToken.NUMBER;
        }
        return JsonToken.STRING;
    }

    private IOException a(String string) {
        throw new MalformedJsonException(string + " at line " + this.a() + " column " + this.b());
    }

    static /* synthetic */ JsonToken a(JsonReader jsonReader) {
        return jsonReader.a;
    }

    static /* synthetic */ int a(JsonReader jsonReader) {
        return jsonReader.a();
    }

    static /* synthetic */ int b(JsonReader jsonReader) {
        return jsonReader.b();
    }

    static /* synthetic */ String a(JsonReader jsonReader, String string) {
        jsonReader.b = string;
        return jsonReader.b;
    }

    static /* synthetic */ String a(JsonReader jsonReader) {
        return jsonReader.a;
    }

    static /* synthetic */ String b(JsonReader jsonReader) {
        jsonReader.a = null;
        return null;
    }

    static /* synthetic */ JsonToken a(JsonReader jsonReader, JsonToken jsonToken) {
        jsonReader.a = jsonToken;
        return jsonReader.a;
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReader$1();
    }
}

