/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.client.j2se.Base64Decoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import javax.imageio.ImageIO;

public final class ImageReader {
    private ImageReader() {
    }

    public static BufferedImage readImage(URI uRI) {
        BufferedImage bufferedImage;
        if ("data".equals(uRI.getScheme())) {
            return ImageReader.readDataURIImage(uRI);
        }
        try {
            bufferedImage = ImageIO.read(uRI.toURL());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Resource not found: ".concat(String.valueOf(uRI)), illegalArgumentException);
        }
        if (bufferedImage == null) {
            throw new IOException("Could not load ".concat(String.valueOf(uRI)));
        }
        return bufferedImage;
    }

    public static BufferedImage readDataURIImage(URI object) {
        if (!((String)(object = ((URI)object).getSchemeSpecificPart())).startsWith("image/")) {
            throw new IOException("Unsupported data URI MIME type");
        }
        int n2 = ((String)object).indexOf("base64,");
        if (n2 < 0) {
            throw new IOException("Unsupported data URI encoding");
        }
        object = URLDecoder.decode(((String)object).substring(n2 + 7), "UTF-8");
        object = Base64Decoder.a().a((String)object);
        return ImageIO.read(new ByteArrayInputStream((byte[])object));
    }
}

