/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import java.util.Arrays;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class BitArray
implements Cloneable {
    private int[] a;
    private int a;

    public BitArray() {
        this.a = 0;
        this.a = new int[1];
    }

    public BitArray(int n2) {
        this.a = n2;
        this.a = BitArray.a(n2);
    }

    private BitArray(int[] nArray, int n2) {
        this.a = nArray;
        this.a = n2;
    }

    public final int getSize() {
        return this.a;
    }

    public final int getSizeInBytes() {
        return (this.a + 7) / 8;
    }

    private void a(int n2) {
        if (n2 > this.a.length << 5) {
            int[] nArray = BitArray.a(n2);
            System.arraycopy(this.a, 0, nArray, 0, this.a.length);
            this.a = nArray;
        }
    }

    public final boolean get(int n2) {
        return (this.a[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
    }

    public final void set(int n2) {
        int n3 = n2 / 32;
        this.a[n3] = this.a[n3] | 1 << (n2 & 0x1F);
    }

    public final void flip(int n2) {
        int n3 = n2 / 32;
        this.a[n3] = this.a[n3] ^ 1 << (n2 & 0x1F);
    }

    public final int getNextSet(int n2) {
        if (n2 >= this.a) {
            return this.a;
        }
        int n3 = n2 / 32;
        n2 = this.a[n3] & ~((1 << (n2 & 0x1F)) - 1);
        while (n2 == 0) {
            if (++n3 == this.a.length) {
                return this.a;
            }
            n2 = this.a[n3];
        }
        if ((n2 = (n3 << 5) + Integer.numberOfTrailingZeros(n2)) > this.a) {
            return this.a;
        }
        return n2;
    }

    public final int getNextUnset(int n2) {
        if (n2 >= this.a) {
            return this.a;
        }
        int n3 = n2 / 32;
        n2 = ~this.a[n3] & ~((1 << (n2 & 0x1F)) - 1);
        while (n2 == 0) {
            if (++n3 == this.a.length) {
                return this.a;
            }
            n2 = ~this.a[n3];
        }
        if ((n2 = (n3 << 5) + Integer.numberOfTrailingZeros(n2)) > this.a) {
            return this.a;
        }
        return n2;
    }

    public final void setBulk(int n2, int n3) {
        this.a[n2 / 32] = n3;
    }

    public final void setRange(int n2, int n3) {
        if (n3 < n2 || n2 < 0 || n3 > this.a) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        int n6 = n4;
        while (n6 <= n5) {
            int n7 = n6 > n4 ? 0 : n2 & 0x1F;
            int n8 = n6 < n5 ? 31 : n3 & 0x1F;
            n7 = (2 << n8) - (1 << n7);
            int n9 = n6++;
            this.a[n9] = this.a[n9] | n7;
        }
    }

    public final void clear() {
        int n2 = this.a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2] = 0;
        }
    }

    public final boolean isRange(int n2, int n3, boolean bl2) {
        if (n3 < n2 || n2 < 0 || n3 > this.a) {
            throw new IllegalArgumentException();
        }
        if (n3 == n2) {
            return true;
        }
        int n4 = n2 / 32;
        int n5 = --n3 / 32;
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n6 = i2 > n4 ? 0 : n2 & 0x1F;
            int n7 = i2 < n5 ? 31 : n3 & 0x1F;
            n6 = (2 << n7) - (1 << n6);
            if ((this.a[i2] & n6) == (bl2 ? n6 : 0)) continue;
            return false;
        }
        return true;
    }

    public final void appendBit(boolean bl2) {
        BitArray bitArray = this;
        bitArray.a(bitArray.a + 1);
        if (bl2) {
            int n2 = this.a / 32;
            this.a[n2] = this.a[n2] | 1 << (this.a & 0x1F);
        }
        ++this.a;
    }

    public final void appendBits(int n2, int n3) {
        if (n3 < 0 || n3 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        BitArray bitArray = this;
        bitArray.a(bitArray.a + n3);
        while (n3 > 0) {
            this.appendBit((n2 >> n3 - 1 & 1) == 1);
            --n3;
        }
    }

    public final void appendBitArray(BitArray bitArray) {
        int n2 = bitArray.a;
        BitArray bitArray2 = this;
        bitArray2.a(bitArray2.a + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.appendBit(bitArray.get(i2));
        }
    }

    public final void xor(BitArray bitArray) {
        if (this.a != bitArray.a) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            int n2 = i2;
            this.a[n2] = this.a[n2] ^ bitArray.a[i2];
        }
    }

    public final void toBytes(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                if (this.get(n2)) {
                    n5 |= 1 << 7 - i3;
                }
                ++n2;
            }
            byArray[n3 + i2] = (byte)n5;
        }
    }

    public final int[] getBitArray() {
        return this.a;
    }

    public final void reverse() {
        int n2;
        int[] nArray = new int[this.a.length];
        int n3 = (this.a - 1) / 32;
        int n4 = n3 + 1;
        for (n2 = 0; n2 < n4; ++n2) {
            long l2 = this.a[n2];
            l2 = l2 >> 1 & 0x55555555L | (l2 & 0x55555555L) << 1;
            l2 = l2 >> 2 & 0x33333333L | (l2 & 0x33333333L) << 2;
            l2 = l2 >> 4 & 0xF0F0F0FL | (l2 & 0xF0F0F0FL) << 4;
            l2 = l2 >> 8 & 0xFF00FFL | (l2 & 0xFF00FFL) << 8;
            l2 = l2 >> 16 & 0xFFFFL | (l2 & 0xFFFFL) << 16;
            nArray[n3 - n2] = (int)l2;
        }
        if (this.a != n4 << 5) {
            n2 = (n4 << 5) - this.a;
            int n5 = nArray[0] >>> n2;
            for (int i2 = 1; i2 < n4; ++i2) {
                n3 = nArray[i2];
                nArray[i2 - 1] = n5 |= n3 << 32 - n2;
                n5 = n3 >>> n2;
            }
            nArray[n4 - 1] = n5;
        }
        this.a = nArray;
    }

    private static int[] a(int n2) {
        return new int[(n2 + 31) / 32];
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        object = (BitArray)object;
        return this.a == ((BitArray)object).a && Arrays.equals(this.a, ((BitArray)object).a);
    }

    public final int hashCode() {
        return 31 * this.a + Arrays.hashCode(this.a);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.a);
        for (int i2 = 0; i2 < this.a; ++i2) {
            if ((i2 & 7) == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.get(i2) ? (char)'X' : '.');
        }
        return stringBuilder.toString();
    }

    public final BitArray clone() {
        return new BitArray((int[])this.a.clone(), this.a);
    }
}

