/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.FormatException;
import java.util.HashMap;
import java.util.Map;

public enum CharacterSetECI {
    Cp437(new int[]{0, 2}, new String[0]),
    ISO8859_1(new int[]{1, 3}, "ISO-8859-1"),
    ISO8859_2(4, "ISO-8859-2"),
    ISO8859_3(5, "ISO-8859-3"),
    ISO8859_4(6, "ISO-8859-4"),
    ISO8859_5(7, "ISO-8859-5"),
    ISO8859_6(8, "ISO-8859-6"),
    ISO8859_7(9, "ISO-8859-7"),
    ISO8859_8(10, "ISO-8859-8"),
    ISO8859_9(11, "ISO-8859-9"),
    ISO8859_10(12, "ISO-8859-10"),
    ISO8859_11(13, "ISO-8859-11"),
    ISO8859_13(15, "ISO-8859-13"),
    ISO8859_14(16, "ISO-8859-14"),
    ISO8859_15(17, "ISO-8859-15"),
    ISO8859_16(18, "ISO-8859-16"),
    SJIS(20, "Shift_JIS"),
    Cp1250(21, "windows-1250"),
    Cp1251(22, "windows-1251"),
    Cp1252(23, "windows-1252"),
    Cp1256(24, "windows-1256"),
    UnicodeBigUnmarked(25, "UTF-16BE", "UnicodeBig"),
    UTF8(26, "UTF-8"),
    ASCII(new int[]{27, 170}, "US-ASCII"),
    Big5,
    GB18030(29, "GB2312", "EUC_CN", "GBK"),
    EUC_KR(30, "EUC-KR");

    private static final Map<Integer, CharacterSetECI> VALUE_TO_ECI;
    private static final Map<String, CharacterSetECI> NAME_TO_ECI;
    private final int[] values;
    private final String[] otherEncodingNames;

    private CharacterSetECI() {
        this(new int[]{28}, new String[0]);
    }

    private CharacterSetECI(int n3, String ... stringArray) {
        this.values = new int[]{n3};
        this.otherEncodingNames = stringArray;
    }

    private CharacterSetECI(int[] nArray, String ... stringArray) {
        this.values = nArray;
        this.otherEncodingNames = stringArray;
    }

    public final int getValue() {
        return this.values[0];
    }

    public static CharacterSetECI getCharacterSetECIByValue(int n2) {
        if (n2 < 0 || n2 >= 900) {
            throw FormatException.getFormatInstance();
        }
        return VALUE_TO_ECI.get(n2);
    }

    public static CharacterSetECI getCharacterSetECIByName(String string) {
        return NAME_TO_ECI.get(string);
    }

    static {
        VALUE_TO_ECI = new HashMap<Integer, CharacterSetECI>();
        NAME_TO_ECI = new HashMap<String, CharacterSetECI>();
        for (CharacterSetECI characterSetECI : CharacterSetECI.values()) {
            int n2;
            Object[] objectArray = characterSetECI.values;
            int n3 = characterSetECI.values.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = objectArray[n2];
                VALUE_TO_ECI.put(n4, characterSetECI);
            }
            NAME_TO_ECI.put(characterSetECI.name(), characterSetECI);
            objectArray = characterSetECI.otherEncodingNames;
            n3 = characterSetECI.otherEncodingNames.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = objectArray[n2];
                NAME_TO_ECI.put((String)n5, characterSetECI);
            }
        }
    }
}

