/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.datamatrix.decoder.DecodedBitStreamParser$Mode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] a = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] b = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] c = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] d = b;
    private static final char[] e = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult a(byte[] byArray) {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(0);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        DecodedBitStreamParser$Mode decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ASCII_ENCODE;
        do {
            if (decodedBitStreamParser$Mode == DecodedBitStreamParser$Mode.ASCII_ENCODE) {
                decodedBitStreamParser$Mode = DecodedBitStreamParser.a(bitSource, stringBuilder, stringBuilder2);
                continue;
            }
            switch (decodedBitStreamParser$Mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.a(bitSource, stringBuilder);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.b(bitSource, stringBuilder);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.c(bitSource, stringBuilder);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.d(bitSource, stringBuilder);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.a(bitSource, stringBuilder, arrayList);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ASCII_ENCODE;
        } while (decodedBitStreamParser$Mode != DecodedBitStreamParser$Mode.PAD_ENCODE && bitSource.available() > 0);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, null);
    }

    private static DecodedBitStreamParser$Mode a(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl2 = false;
        block13: do {
            int n2;
            if ((n2 = bitSource.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (n2 <= 128) {
                if (bl2) {
                    n2 += 128;
                }
                stringBuilder.append((char)(n2 - 1));
                return DecodedBitStreamParser$Mode.ASCII_ENCODE;
            }
            if (n2 == 129) {
                return DecodedBitStreamParser$Mode.PAD_ENCODE;
            }
            if (n2 <= 229) {
                if ((n2 -= 130) < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n2);
                continue;
            }
            switch (n2) {
                case 230: {
                    return DecodedBitStreamParser$Mode.C40_ENCODE;
                }
                case 231: {
                    return DecodedBitStreamParser$Mode.BASE256_ENCODE;
                }
                case 232: {
                    stringBuilder.append('\u001d');
                    break;
                }
                case 233: 
                case 234: {
                    break;
                }
                case 235: {
                    bl2 = true;
                    break;
                }
                case 236: {
                    stringBuilder.append("[)>\u001e05\u001d");
                    stringBuilder2.insert(0, "\u001e\u0004");
                    break;
                }
                case 237: {
                    stringBuilder.append("[)>\u001e06\u001d");
                    stringBuilder2.insert(0, "\u001e\u0004");
                    break;
                }
                case 238: {
                    return DecodedBitStreamParser$Mode.ANSIX12_ENCODE;
                }
                case 239: {
                    return DecodedBitStreamParser$Mode.TEXT_ENCODE;
                }
                case 240: {
                    return DecodedBitStreamParser$Mode.EDIFACT_ENCODE;
                }
                case 241: {
                    break;
                }
                default: {
                    if (n2 < 242 || n2 == 254 && bitSource.available() == 0) continue block13;
                    throw FormatException.getFormatInstance();
                }
            }
        } while (bitSource.available() > 0);
        return DecodedBitStreamParser$Mode.ASCII_ENCODE;
    }

    private static void a(BitSource bitSource, StringBuilder stringBuilder) {
        boolean bl2 = false;
        int[] nArray = new int[3];
        int n2 = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n3 = bitSource.readBits(8);
            if (n3 == 254) {
                return;
            }
            DecodedBitStreamParser.a(n3, bitSource.readBits(8), nArray);
            block11: for (n3 = 0; n3 < 3; ++n3) {
                char c2 = nArray[n3];
                switch (n2) {
                    case 0: {
                        if (c2 < '\u0003') {
                            n2 = c2 + 1;
                            continue block11;
                        }
                        if (c2 < '(') {
                            c2 = a[c2];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                                continue block11;
                            }
                            stringBuilder.append(c2);
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl2) {
                            stringBuilder.append((char)(c2 + 128));
                            bl2 = false;
                        } else {
                            stringBuilder.append(c2);
                        }
                        n2 = 0;
                        continue block11;
                    }
                    case 2: {
                        if (c2 < '\u001b') {
                            c2 = b[c2];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else {
                            switch (c2) {
                                case '\u001b': {
                                    stringBuilder.append('\u001d');
                                    break;
                                }
                                case '\u001e': {
                                    bl2 = true;
                                    break;
                                }
                                default: {
                                    throw FormatException.getFormatInstance();
                                }
                            }
                        }
                        n2 = 0;
                        continue block11;
                    }
                    case 3: {
                        if (bl2) {
                            stringBuilder.append((char)(c2 + 224));
                            bl2 = false;
                        } else {
                            stringBuilder.append((char)(c2 + 96));
                        }
                        n2 = 0;
                        continue block11;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void b(BitSource bitSource, StringBuilder stringBuilder) {
        boolean bl2 = false;
        int[] nArray = new int[3];
        int n2 = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n3 = bitSource.readBits(8);
            if (n3 == 254) {
                return;
            }
            DecodedBitStreamParser.a(n3, bitSource.readBits(8), nArray);
            block11: for (n3 = 0; n3 < 3; ++n3) {
                char c2 = nArray[n3];
                switch (n2) {
                    case 0: {
                        if (c2 < '\u0003') {
                            n2 = c2 + 1;
                            continue block11;
                        }
                        if (c2 < '(') {
                            c2 = c[c2];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                                continue block11;
                            }
                            stringBuilder.append(c2);
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl2) {
                            stringBuilder.append((char)(c2 + 128));
                            bl2 = false;
                        } else {
                            stringBuilder.append(c2);
                        }
                        n2 = 0;
                        continue block11;
                    }
                    case 2: {
                        if (c2 < d.length) {
                            c2 = d[c2];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                        } else {
                            switch (c2) {
                                case '\u001b': {
                                    stringBuilder.append('\u001d');
                                    break;
                                }
                                case '\u001e': {
                                    bl2 = true;
                                    break;
                                }
                                default: {
                                    throw FormatException.getFormatInstance();
                                }
                            }
                        }
                        n2 = 0;
                        continue block11;
                    }
                    case 3: {
                        if (c2 < ' ') {
                            c2 = e[c2];
                            if (bl2) {
                                stringBuilder.append((char)(c2 + 128));
                                bl2 = false;
                            } else {
                                stringBuilder.append(c2);
                            }
                            n2 = 0;
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void c(BitSource bitSource, StringBuilder stringBuilder) {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.a(n2, bitSource.readBits(8), nArray);
            block7: for (n2 = 0; n2 < 3; ++n2) {
                int n3 = nArray[n2];
                switch (n3) {
                    case 0: {
                        stringBuilder.append('\r');
                        continue block7;
                    }
                    case 1: {
                        stringBuilder.append('*');
                        continue block7;
                    }
                    case 2: {
                        stringBuilder.append('>');
                        continue block7;
                    }
                    case 3: {
                        stringBuilder.append(' ');
                        continue block7;
                    }
                    default: {
                        if (n3 < 14) {
                            stringBuilder.append((char)(n3 + 44));
                            continue block7;
                        }
                        if (n3 < 40) {
                            stringBuilder.append((char)(n3 + 51));
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void a(int n2, int n3, int[] nArray) {
        n2 = (n2 << 8) + n3 - 1;
        nArray[0] = n3 = n2 / 1600;
        n2 -= n3 * 1600;
        nArray[1] = n3 = n2 / 40;
        nArray[2] = n2 - n3 * 40;
    }

    private static void d(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                int n2 = bitSource.readBits(6);
                if (n2 == 31) {
                    int n3 = 8 - bitSource.getBitOffset();
                    if (n3 != 8) {
                        bitSource.readBits(n3);
                    }
                    return;
                }
                if ((n2 & 0x20) == 0) {
                    n2 |= 0x40;
                }
                stringBuilder.append((char)n2);
            }
        } while (bitSource.available() > 0);
    }

    private static void a(BitSource bitSource, StringBuilder stringBuilder, Collection<byte[]> collection) {
        int n2 = 1 + bitSource.getByteOffset();
        int n3 = DecodedBitStreamParser.a(bitSource.readBits(8), n2++);
        if (n3 == 0) {
            n3 = bitSource.available() / 8;
        } else if (n3 >= 250) {
            n3 = 250 * (n3 - 249) + DecodedBitStreamParser.a(bitSource.readBits(8), n2++);
        }
        if (n3 < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (bitSource.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            byArray[i2] = (byte)DecodedBitStreamParser.a(bitSource.readBits(8), n2++);
        }
        collection.add(byArray);
        try {
            stringBuilder.append(new String(byArray, "ISO8859_1"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform does not support required encoding: ".concat(String.valueOf(unsupportedEncodingException)));
        }
    }

    private static int a(int n2, int n3) {
        if ((n2 -= (n3 = n3 * 149 % 255 + 1)) >= 0) {
            return n2;
        }
        return n2 + 256;
    }
}

