/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code128Writer$CType;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got ".concat(String.valueOf((Object)barcodeFormat)));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 <= 0 || n4 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got ".concat(String.valueOf(n4)));
        }
        block9: for (int i2 = 0; i2 < n4; ++i2) {
            n3 = string.charAt(i2);
            if (n3 >= 32 && n3 <= 126) continue;
            switch (n3) {
                case 241: 
                case 242: 
                case 243: 
                case 244: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Bad character in input: ".concat(String.valueOf((char)n3)));
                }
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n3 = 0;
        int n52 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            n2 = Code128Writer.a(string, n7, n6);
            if (n2 == n6) {
                switch (string.charAt(n7)) {
                    case '\u00f1': {
                        n8 = 102;
                        break;
                    }
                    case '\u00f2': {
                        n8 = 97;
                        break;
                    }
                    case '\u00f3': {
                        n8 = 96;
                        break;
                    }
                    case '\u00f4': {
                        n8 = 100;
                        break;
                    }
                    default: {
                        if (n6 == 100) {
                            n8 = string.charAt(n7) - 32;
                            break;
                        }
                        int n9 = n7++;
                        n8 = Integer.parseInt(string.substring(n9, n9 + 2));
                    }
                }
                ++n7;
            } else {
                n8 = n6 == 0 ? (n2 == 100 ? 104 : 105) : n2;
                n6 = n2;
            }
            arrayList.add(Code128Reader.a[n8]);
            n3 += n8 * n52;
            if (n7 == 0) continue;
            ++n52;
        }
        arrayList.add(Code128Reader.a[n3 %= 103]);
        arrayList.add(Code128Reader.a[106]);
        n2 = 0;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            for (int n52 : (int[])object.next()) {
                n2 += n52;
            }
        }
        object = new boolean[n2];
        int n10 = 0;
        for (int[] nArray : arrayList) {
            n10 += Code128Writer.appendPattern((boolean[])object, n10, nArray, true);
        }
        return object;
    }

    private static Code128Writer$CType a(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        if (n2 >= n3) {
            return Code128Writer$CType.UNCODABLE;
        }
        char c2 = charSequence.charAt(n2);
        if (c2 == '\u00f1') {
            return Code128Writer$CType.FNC_1;
        }
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.UNCODABLE;
        }
        if (n2 + 1 >= n3) {
            return Code128Writer$CType.ONE_DIGIT;
        }
        c2 = charSequence.charAt(n2 + 1);
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.ONE_DIGIT;
        }
        return Code128Writer$CType.TWO_DIGITS;
    }

    private static int a(CharSequence charSequence, int n2, int n3) {
        Code128Writer$CType code128Writer$CType = Code128Writer.a(charSequence, n2);
        if (code128Writer$CType == Code128Writer$CType.UNCODABLE || code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
            return 100;
        }
        if (n3 == 99) {
            return 99;
        }
        if (n3 == 100) {
            if (code128Writer$CType == Code128Writer$CType.FNC_1) {
                return 100;
            }
            code128Writer$CType = Code128Writer.a(charSequence, n2 + 2);
            if (code128Writer$CType == Code128Writer$CType.UNCODABLE || code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            if (code128Writer$CType == Code128Writer$CType.FNC_1) {
                if (Code128Writer.a(charSequence, n2 + 3) == Code128Writer$CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            n2 += 4;
            while ((code128Writer$CType = Code128Writer.a(charSequence, n2)) == Code128Writer$CType.TWO_DIGITS) {
                n2 += 2;
            }
            if (code128Writer$CType == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (code128Writer$CType == Code128Writer$CType.FNC_1) {
            code128Writer$CType = Code128Writer.a(charSequence, n2 + 1);
        }
        if (code128Writer$CType == Code128Writer$CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }
}

