/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got ".concat(String.valueOf((Object)barcodeFormat)));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2;
        int[] nArray;
        int n3;
        int n4 = string.length();
        if (n4 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got ".concat(String.valueOf(n4)));
        }
        int[] nArray2 = new int[9];
        int n5 = n4 + 25;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(i2));
            if (n3 < 0) {
                throw new IllegalArgumentException("Bad contents: ".concat(String.valueOf(string)));
            }
            Code39Writer.a(Code39Reader.a[n3], nArray2);
            nArray = nArray2;
            for (n2 = 0; n2 < 9; ++n2) {
                n3 = nArray[n2];
                n5 += n3;
            }
        }
        boolean[] blArray = new boolean[n5];
        Code39Writer.a(Code39Reader.a, nArray2);
        n3 = Code39Writer.appendPattern(blArray, 0, nArray2, true);
        nArray = new int[]{1};
        n3 += Code39Writer.appendPattern(blArray, n3, nArray, false);
        for (n5 = 0; n5 < n4; ++n5) {
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(n5));
            Code39Writer.a(Code39Reader.a[n2], nArray2);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray2, true);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray, false);
        }
        Code39Writer.a(Code39Reader.a, nArray2);
        Code39Writer.appendPattern(blArray, n3, nArray2, true);
        return blArray;
    }

    private static void a(int n2, int[] nArray) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n3 = n2 & 1 << 8 - i2;
            nArray[i2] = n3 == 0 ? 1 : 2;
        }
    }
}

